/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.zeith.multipart.api.IndexedVoxelShape;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.blocks.BlockMultipartContainer;
import org.zeith.multipart.microblocks.api.MicroblockData;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.grids.MicroblockPlacementGrid;
import org.zeith.multipart.microblocks.api.tile.MicroblockState;
import org.zeith.multipart.microblocks.client.resource.model.ModelGeneratorSystem;
import org.zeith.multipart.microblocks.contents.multipart.MicroblockPartDefinition;
import org.zeith.multipart.microblocks.init.ItemsHM;
import org.zeith.multipart.microblocks.init.PartDefinitionsHM;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderPartPlacement {
    public static float r = 0.0f;
    public static float g = 0.0f;
    public static float b = 0.0f;
    public static float a = 0.4f;

    @SubscribeEvent
    public static void renderLast(RenderLevelStageEvent e) {
        boolean shift;
        PartContainer pc;
        Direction hitDir;
        double z;
        double y;
        double x;
        PoseStack pose;
        MicroblockData data;
        PartPlacement placement;
        MicroblockPlacementGrid grid;
        BlockPos pos;
        BlockState microstate;
        MicroblockType type;
        BlockHitResult hit;
        LocalPlayer pl;
        Minecraft mc;
        block32: {
            List<Vector3f> lines;
            if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                return;
            }
            mc = Minecraft.m_91087_();
            pl = mc.f_91074_;
            HitResult hit0 = mc.f_91077_;
            if (pl == null || hit0 == null || !(hit0 instanceof BlockHitResult)) {
                return;
            }
            hit = (BlockHitResult)hit0;
            ItemStack microblockStack = pl.m_21120_(InteractionHand.MAIN_HAND);
            if (!microblockStack.m_150930_((Item)ItemsHM.MICROBLOCK)) {
                microblockStack = pl.m_21120_(InteractionHand.OFF_HAND);
            }
            if (!microblockStack.m_150930_((Item)ItemsHM.MICROBLOCK)) {
                return;
            }
            type = ItemsHM.MICROBLOCK.getMicroblockType(microblockStack);
            microstate = ItemsHM.MICROBLOCK.getMicroblockMaterialState(microblockStack);
            pos = hit.m_82425_();
            if (type == null || microstate == null || pos == null) {
                return;
            }
            BlockState state = mc.f_91073_.m_8055_(pos);
            VoxelShape bounds = state.m_60771_((BlockGetter)mc.f_91073_, pos, CollisionContext.m_82750_((Entity)pl));
            if (bounds.m_83281_()) {
                bounds = state.m_60651_((BlockGetter)mc.f_91073_, pos, CollisionContext.m_82750_((Entity)pl));
            }
            if ((lines = (grid = type.getPlacementGrid()).getLinesForRendering((Player)pl, bounds, hit)).isEmpty()) {
                return;
            }
            placement = grid.pickPlacement((Player)pl, hit, pos.equals((Object)hit.m_82425_()));
            data = type.createDataForPlacement((Player)pl, hit, pos.equals((Object)hit.m_82425_()));
            if (placement == null) {
                return;
            }
            pose = e.getPoseStack();
            pose.m_85836_();
            Vec3 vec3 = e.getCamera().m_90583_();
            x = (double)pos.m_123341_() - vec3.m_7096_();
            y = (double)pos.m_123342_() - vec3.m_7098_();
            z = (double)pos.m_123343_() - vec3.m_7094_();
            hitDir = hit.m_82434_();
            pc = BlockMultipartContainer.pc((BlockGetter)pl.m_9236_(), (BlockPos)pos);
            boolean bl = shift = pc == null;
            if (pc != null) {
                double desired;
                Vec3 loc = hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)hit.m_82425_()));
                double axial = switch (hit.m_82434_().m_122434_()) {
                    case Direction.Axis.Y -> loc.f_82480_;
                    case Direction.Axis.X -> loc.f_82479_;
                    case Direction.Axis.Z -> loc.f_82481_;
                    default -> -1.0;
                };
                double d = desired = hit.m_82434_().m_122421_() == Direction.AxisDirection.NEGATIVE ? 0.0 : 1.0;
                if (Math.abs(axial - desired) < 0.001) {
                    shift = true;
                } else if (pc.getPartAt(placement) != null) {
                    shift = true;
                } else {
                    MicroblockPartDefinition.MicroblockConfiguration config = new MicroblockPartDefinition.MicroblockConfiguration(new MicroblockState().setType(type, data).setMaterial(microblockStack));
                    if (!placement.canBePlacedAlongside(pc.parts().stream().map(PartEntity::placement).collect(Collectors.toSet()))) {
                        shift = true;
                    } else if (!PartDefinitionsHM.MICROBLOCK.canPlaceAt(pc, config, placement)) {
                        shift = true;
                    } else {
                        for (PartEntity part : pc.parts()) {
                            if (!part.placement().isCompatibleWith(placement)) {
                                shift = true;
                            } else {
                                if (!part.blocksPlacementFor((PartDefinition)PartDefinitionsHM.MICROBLOCK, placement)) continue;
                                shift = true;
                            }
                            break block32;
                        }
                        PartEntity placeEntity = config.create(pc, placement);
                        if (placeEntity == null) {
                            shift = true;
                        } else {
                            VoxelShape shapeOfEntity = placeEntity.getPartOccupiedShape();
                            for (PartEntity entry : pc.parts()) {
                                if (!IndexedVoxelShape.shapesIntersect((VoxelShape)shapeOfEntity, (VoxelShape)entry.getPartOccupiedShapeWith(placeEntity, shapeOfEntity))) continue;
                                shift = true;
                                break;
                            }
                        }
                    }
                }
            }
        }
        if (shift) {
            x += (double)hitDir.m_122429_();
            y += (double)hitDir.m_122430_();
            z += (double)hitDir.m_122431_();
        }
        pose.m_85837_(x, y, z);
        PoseStack.Pose last = pose.m_85850_();
        VertexConsumer buf = mc.m_91269_().m_110108_().m_6299_(RenderType.m_110467_((ResourceLocation)InventoryMenu.f_39692_));
        BlockPos finalPos = shift ? pos.m_121945_(hitDir) : pos;
        PartPlacement pl0 = grid.pickPlacement((Player)pl, hit, finalPos.equals((Object)hit.m_82425_()));
        MicroblockData d0 = type.createDataForPlacement((Player)pl, hit, finalPos.equals((Object)hit.m_82425_()));
        if (pl0 != null) {
            placement = pl0;
            data = d0;
        }
        List<AABB> strips = type.getModelStrips(placement, data);
        pc = BlockMultipartContainer.pc((BlockGetter)mc.f_91073_, (BlockPos)finalPos);
        RandomSource rng = RandomSource.m_216335_((long)pos.m_121878_());
        for (RenderType layer : RenderType.m_110506_()) {
            for (BakedQuad quad : ModelGeneratorSystem.generateMesh(type, placement, data, pc, (BlockAndTintGetter)mc.f_91073_, finalPos, strips, microstate, rng, layer).toBakedBlockQuads()) {
                buf.putBulkData(last, quad, 1.0f, 1.0f, 1.0f, 0.6f, 255, 0, true);
            }
        }
        pose.m_85849_();
    }

    @SubscribeEvent
    public static void renderOutline(RenderHighlightEvent.Block e) {
        MicroblockPlacementGrid grid;
        List<Vector3f> lines;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer pl = mc.f_91074_;
        if (pl == null) {
            return;
        }
        ItemStack microblockStack = pl.m_21120_(InteractionHand.MAIN_HAND);
        if (!microblockStack.m_150930_((Item)ItemsHM.MICROBLOCK)) {
            microblockStack = pl.m_21120_(InteractionHand.OFF_HAND);
        }
        if (!microblockStack.m_150930_((Item)ItemsHM.MICROBLOCK)) {
            return;
        }
        MicroblockType type = ItemsHM.MICROBLOCK.getMicroblockType(microblockStack);
        BlockState microstate = ItemsHM.MICROBLOCK.getMicroblockMaterialState(microblockStack);
        if (type == null || microstate == null) {
            return;
        }
        BlockHitResult hit = e.getTarget();
        BlockPos pos = hit.m_82425_();
        BlockState state = mc.f_91073_.m_8055_(pos);
        VoxelShape bounds = state.m_60771_((BlockGetter)mc.f_91073_, pos, CollisionContext.m_82750_((Entity)pl));
        if (bounds.m_83281_()) {
            bounds = state.m_60651_((BlockGetter)mc.f_91073_, pos, CollisionContext.m_82750_((Entity)pl));
        }
        if ((lines = (grid = type.getPlacementGrid()).getLinesForRendering((Player)pl, bounds, hit)).isEmpty()) {
            return;
        }
        VertexConsumer vb = e.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        PoseStack pose = e.getPoseStack();
        pose.m_85836_();
        PoseStack.Pose last = pose.m_85850_();
        Matrix4f p = last.m_252922_();
        Matrix3f n = last.m_252943_();
        Vec3 vec3 = e.getCamera().m_90583_();
        double x = (double)pos.m_123341_() - vec3.m_7096_();
        double y = (double)pos.m_123342_() - vec3.m_7098_();
        double z = (double)pos.m_123343_() - vec3.m_7094_();
        if (lines.size() % 2 == 0) {
            for (int i = 0; i < lines.size(); i += 2) {
                Vector3f v1 = lines.get(i);
                Vector3f v2 = lines.get(i + 1);
                float x1 = v1.x;
                float y1 = v1.y;
                float z1 = v1.z;
                float x2 = v2.x;
                float y2 = v2.y;
                float z2 = v2.z;
                float dX = x2 - x1;
                float dY = y2 - y1;
                float dZ = z2 - z1;
                float len = Mth.m_14116_((float)(dX * dX + dY * dY + dZ * dZ));
                vb.m_252986_(p, (float)((double)x1 + x), (float)((double)y1 + y), (float)((double)z1 + z)).m_85950_(r, g, b, a).m_252939_(n, dX /= len, dY /= len, dZ /= len).m_5752_();
                vb.m_252986_(p, (float)((double)x2 + x), (float)((double)y2 + y), (float)((double)z2 + z)).m_85950_(r, g, b, a).m_252939_(n, dX, dY, dZ).m_5752_();
            }
        }
        pose.m_85849_();
        e.setCanceled(true);
    }
}

