/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.api.tile;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.multipart.microblocks.HammerMicroblocks;
import org.zeith.multipart.microblocks.api.MicroblockData;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.init.ItemsHM;

public class MicroblockState
implements INBTSerializable<CompoundTag> {
    protected MicroblockType type;
    protected MicroblockData data;
    protected Item material = Items.f_41852_;

    public boolean isValid() {
        return this.type != null && this.material != Items.f_41852_;
    }

    public MicroblockType getType() {
        return this.type;
    }

    public MicroblockData getData() {
        return this.data;
    }

    public MicroblockState setType(MicroblockType type, MicroblockData data) {
        this.type = type;
        this.data = data;
        return this;
    }

    public MicroblockState setMaterial(ItemStack material) {
        this.material = material.m_41720_();
        return this;
    }

    public void copyFrom(MicroblockState state) {
        this.type = state.type;
        this.data = state.data;
        this.material = state.material;
    }

    public ItemStack asStack() {
        if (this.type == null || this.material == null || this.material == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        return ItemsHM.MICROBLOCK.forItemRaw(this.type, this.material.m_7968_(), 1);
    }

    public BlockState asBlockState() {
        return Block.m_49814_((Item)this.material).m_49966_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", Objects.toString(HammerMicroblocks.microblockTypes().getKey((Object)this.type)));
        if (this.data != null) {
            tag.m_128365_("Data", (Tag)this.data.serializeNBT());
        }
        tag.m_128359_("Id", Objects.toString(ForgeRegistries.ITEMS.getKey((Object)this.material)));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.type = (MicroblockType)HammerMicroblocks.microblockTypes().getValue(ResourceLocation.m_135820_((String)tag.m_128461_("Type")));
        if (this.type != null) {
            this.data = this.type.createEmptyData();
            if (this.data != null) {
                this.data.deserializeNBT(tag.m_128469_("Data"));
            }
        }
        this.material = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)tag.m_128461_("Id")));
    }
}

