/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.api.recipe.combination;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.recipe.MicroblockIngredient;
import org.zeith.multipart.microblocks.api.recipe.MicroblockedStack;
import org.zeith.multipart.microblocks.api.recipe.combination.IMicroblockComboRecipe;

public record ShapelessMicroblockRecipe(NonNullList<MicroblockIngredient> inputs, MicroblockType output, boolean outputIsFullBlock, int count) implements IMicroblockComboRecipe
{
    @Override
    public Optional<IMicroblockComboRecipe.FusionRecipeResult> matchAndGetResult(List<MicroblockedStack> provided, int width, int height) {
        if (this.matches(provided)) {
            return Optional.of(this.getBaseResult());
        }
        return Optional.empty();
    }

    @Override
    public IMicroblockComboRecipe.FusionRecipeResult getBaseResult() {
        return new IMicroblockComboRecipe.FusionRecipeResult(this.output, this.outputIsFullBlock, this.count);
    }

    public boolean matches(List<MicroblockedStack> provided) {
        provided = new ArrayList<MicroblockedStack>(provided);
        provided.removeIf(Objects::isNull);
        if (provided.size() != this.inputs.size()) {
            return false;
        }
        boolean[] found = new boolean[this.inputs.size()];
        for (MicroblockedStack microblockedStack : provided) {
            boolean match = false;
            for (int i = 0; i < this.inputs.size(); ++i) {
                MicroblockIngredient in;
                if (found[i] || !(in = (MicroblockIngredient)this.inputs.get(i)).test(microblockedStack)) continue;
                found[i] = true;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        for (Object b : (Object)found) {
            if (b != false) continue;
            return false;
        }
        return true;
    }
}

