/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.api.grids;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.blocks.BlockMultipartContainer;
import org.zeith.multipart.init.PartPlacementsHM;
import org.zeith.multipart.microblocks.api.grids.MicroblockPlacementGrid;

public class PlanarPlacementGrid
extends MicroblockPlacementGrid {
    public static final PlanarPlacementGrid INSTANCE = new PlanarPlacementGrid();
    protected final Map<Direction, List<Vector3f>> lines = new HashMap<Direction, List<Vector3f>>();

    @Override
    @Nullable
    public PartPlacement pickPlacement(Player player, BlockHitResult hit, boolean sameBlock) {
        PartPlacement op;
        PartContainer pc;
        PartPlacement place = null;
        Vec3 loc = hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)hit.m_82425_()));
        float four = 0.25f;
        float ifour = 0.75f;
        if (hit.m_82434_().m_122434_() == Direction.Axis.X) {
            x = loc.f_82480_;
            double z = loc.f_82481_;
            if (x >= (double)four && z >= (double)four && x <= (double)ifour && z <= (double)ifour) {
                place = (PartPlacement)PartPlacementsHM.SIDED_PLACEMENT.apply(hit.m_82434_().m_122424_());
            } else if (x > z && x < 1.0 - z) {
                place = PartPlacementsHM.NORTH;
            } else if (z > (double)ifour && 1.0 - z < x && z > x) {
                place = PartPlacementsHM.SOUTH;
            } else if (z > x && z < 1.0 - x) {
                place = PartPlacementsHM.DOWN;
            } else if (x > (double)ifour && 1.0 - x < z && x > z) {
                place = PartPlacementsHM.UP;
            }
        } else if (hit.m_82434_().m_122434_() == Direction.Axis.Y) {
            x = loc.f_82479_;
            double z = loc.f_82481_;
            if (x >= (double)four && z >= (double)four && x <= (double)ifour && z <= (double)ifour) {
                place = (PartPlacement)PartPlacementsHM.SIDED_PLACEMENT.apply(hit.m_82434_().m_122424_());
            } else if (x > z && x < 1.0 - z) {
                place = PartPlacementsHM.NORTH;
            } else if (z > (double)ifour && 1.0 - z < x && z > x) {
                place = PartPlacementsHM.SOUTH;
            } else if (z > x && z < 1.0 - x) {
                place = PartPlacementsHM.WEST;
            } else if (x > (double)ifour && 1.0 - x < z && x > z) {
                place = PartPlacementsHM.EAST;
            }
        } else if (hit.m_82434_().m_122434_() == Direction.Axis.Z) {
            x = loc.f_82479_;
            double z = loc.f_82480_;
            if (x >= (double)four && z >= (double)four && x <= (double)ifour && z <= (double)ifour) {
                place = (PartPlacement)PartPlacementsHM.SIDED_PLACEMENT.apply(hit.m_82434_().m_122424_());
            } else if (x > z && x < 1.0 - z) {
                place = PartPlacementsHM.DOWN;
            } else if (z > (double)ifour && 1.0 - z < x && z > x) {
                place = PartPlacementsHM.UP;
            } else if (z > x && z < 1.0 - x) {
                place = PartPlacementsHM.WEST;
            } else if (x > (double)ifour && 1.0 - x < z && x > z) {
                place = PartPlacementsHM.EAST;
            }
        }
        if (place != null && place.getDirection() != null && sameBlock && (pc = BlockMultipartContainer.pc((BlockGetter)player.m_9236_(), (BlockPos)hit.m_82425_())) != null && pc.getPartAt(place) != null && pc.getPartAt(op = (PartPlacement)PartPlacementsHM.SIDED_PLACEMENT.apply(place.getDirection().m_122424_())) == null) {
            return op;
        }
        return place;
    }

    @Override
    @NotNull
    public List<Vector3f> getLinesForRendering(Player player, VoxelShape blockBounds, BlockHitResult hit) {
        if (blockBounds.m_83281_()) {
            return List.of();
        }
        AABB boundary = blockBounds.m_83215_();
        if (hit.m_82434_().m_122434_() == Direction.Axis.X) {
            float my = (float)(hit.m_82434_() == Direction.EAST ? boundary.f_82291_ : boundary.f_82288_);
            float four = 0.25f;
            float ifour = 0.75f;
            return List.of(new Vector3f(my, 0.0f, 0.0f), new Vector3f(my, 1.0f, 0.0f), new Vector3f(my, 1.0f, 1.0f), new Vector3f(my, 0.0f, 1.0f), new Vector3f(my, 0.0f, 0.0f), new Vector3f(my, 0.0f, 1.0f), new Vector3f(my, 1.0f, 0.0f), new Vector3f(my, 1.0f, 1.0f), new Vector3f(my, 0.0f, 0.0f), new Vector3f(my, four, four), new Vector3f(my, four, ifour), new Vector3f(my, 0.0f, 1.0f), new Vector3f(my, ifour, four), new Vector3f(my, 1.0f, 0.0f), new Vector3f(my, ifour, ifour), new Vector3f(my, 1.0f, 1.0f), new Vector3f(my, four, four), new Vector3f(my, four, ifour), new Vector3f(my, ifour, four), new Vector3f(my, ifour, ifour), new Vector3f(my, four, four), new Vector3f(my, ifour, four), new Vector3f(my, four, ifour), new Vector3f(my, ifour, ifour));
        }
        if (hit.m_82434_().m_122434_() == Direction.Axis.Y) {
            float my = (float)(hit.m_82434_() == Direction.UP ? boundary.f_82292_ : boundary.f_82289_);
            float four = 0.25f;
            float ifour = 0.75f;
            return List.of(new Vector3f(0.0f, my, 0.0f), new Vector3f(1.0f, my, 0.0f), new Vector3f(1.0f, my, 1.0f), new Vector3f(0.0f, my, 1.0f), new Vector3f(0.0f, my, 0.0f), new Vector3f(0.0f, my, 1.0f), new Vector3f(1.0f, my, 0.0f), new Vector3f(1.0f, my, 1.0f), new Vector3f(0.0f, my, 0.0f), new Vector3f(four, my, four), new Vector3f(four, my, ifour), new Vector3f(0.0f, my, 1.0f), new Vector3f(ifour, my, four), new Vector3f(1.0f, my, 0.0f), new Vector3f(ifour, my, ifour), new Vector3f(1.0f, my, 1.0f), new Vector3f(four, my, four), new Vector3f(four, my, ifour), new Vector3f(ifour, my, four), new Vector3f(ifour, my, ifour), new Vector3f(four, my, four), new Vector3f(ifour, my, four), new Vector3f(four, my, ifour), new Vector3f(ifour, my, ifour));
        }
        if (hit.m_82434_().m_122434_() == Direction.Axis.Z) {
            float my = (float)(hit.m_82434_() == Direction.SOUTH ? boundary.f_82293_ : boundary.f_82290_);
            float four = 0.25f;
            float ifour = 0.75f;
            return List.of(new Vector3f(0.0f, 0.0f, my), new Vector3f(1.0f, 0.0f, my), new Vector3f(1.0f, 1.0f, my), new Vector3f(0.0f, 1.0f, my), new Vector3f(0.0f, 0.0f, my), new Vector3f(0.0f, 1.0f, my), new Vector3f(1.0f, 0.0f, my), new Vector3f(1.0f, 1.0f, my), new Vector3f(0.0f, 0.0f, my), new Vector3f(four, four, my), new Vector3f(four, ifour, my), new Vector3f(0.0f, 1.0f, my), new Vector3f(ifour, four, my), new Vector3f(1.0f, 0.0f, my), new Vector3f(ifour, ifour, my), new Vector3f(1.0f, 1.0f, my), new Vector3f(four, four, my), new Vector3f(four, ifour, my), new Vector3f(ifour, four, my), new Vector3f(ifour, ifour, my), new Vector3f(four, four, my), new Vector3f(ifour, four, my), new Vector3f(four, ifour, my), new Vector3f(ifour, ifour, my));
        }
        return this.lines.getOrDefault(hit.m_82434_(), List.of());
    }
}

