/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.api;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.init.PartPlacementsHM;
import org.zeith.multipart.microblocks.HammerMicroblocks;
import org.zeith.multipart.microblocks.api.MicroblockData;
import org.zeith.multipart.microblocks.api.grids.MicroblockPlacementGrid;
import org.zeith.multipart.microblocks.contents.multipart.entity.MicroblockEntity;

public abstract class MicroblockType {
    protected String descriptionId;
    protected PartPlacement itemRenderPlacement = PartPlacementsHM.NORTH;

    public abstract MicroblockPlacementGrid getPlacementGrid();

    public abstract List<AABB> getModelStrips(PartPlacement var1, @Nullable MicroblockData var2);

    public abstract VoxelShape getShape(PartPlacement var1, @Nullable MicroblockData var2);

    public VoxelShape getOccupationShapeFor(PartPlacement ourPlacement, MicroblockType futureType, PartPlacement futureTypePlacement, MicroblockEntity futureEntity, @Nullable MicroblockData data) {
        return this.getShape(ourPlacement, data);
    }

    @Nullable
    public MicroblockData createDataForPlacement(Player player, BlockHitResult hit, boolean sameBlock) {
        return this.createEmptyData();
    }

    @Nullable
    public MicroblockData createItemData() {
        return this.createEmptyData();
    }

    @Nullable
    public MicroblockData createEmptyData() {
        return null;
    }

    public PartPlacement getPlacementForRendering() {
        return this.itemRenderPlacement;
    }

    public Component getDescription() {
        return Component.m_237115_((String)this.getDescriptionId());
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"microblock_type", (ResourceLocation)HammerMicroblocks.microblockTypes().getKey((Object)this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }
}

