/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.EmptyingAction;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.api.parts.IPart;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.AESubScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.StackWithBounds;
import appeng.client.gui.TextOverride;
import appeng.client.gui.Tooltip;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.layout.SlotGridLayout;
import appeng.client.gui.style.BackgroundGenerator;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.GeneratedBackground;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.SlotPosition;
import appeng.client.gui.style.Text;
import appeng.client.gui.style.TextAlignment;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.ITickingWidget;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.gui.widgets.OpenGuideButton;
import appeng.client.gui.widgets.VerticalButtonBar;
import appeng.client.guidebook.Guide;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.AppEngClient;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.core.sync.packets.SwapSlotsPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.CraftingTermSlot;
import appeng.menu.slot.DisabledSlot;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.IOptionalSlot;
import appeng.menu.slot.ResizableSlot;
import appeng.util.ConfigMenuInventory;
import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AEBaseScreen<T extends AEBaseMenu>
extends AbstractContainerScreen<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AEBaseScreen.class);
    private static final Point HIDDEN_SLOT_POS = new Point(-9999, -9999);
    public static final String TEXT_ID_DIALOG_TITLE = "dialog_title";
    private final VerticalButtonBar verticalToolbar;
    private final OpenGuideButton helpButton;
    private final Set<Slot> drag_click = new HashSet<Slot>();
    private boolean disableShiftClick = false;
    private Stopwatch dbl_clickTimer = Stopwatch.createStarted();
    private ItemStack dbl_whichItem = ItemStack.f_41583_;
    private Slot bl_clicked;
    private boolean handlingRightClick;
    private final Map<String, TextOverride> textOverrides = new HashMap<String, TextOverride>();
    private final Set<SlotSemantic> hiddenSlots = new HashSet<SlotSemantic>();
    protected final WidgetContainer widgets;
    protected final ScreenStyle style;
    protected final AEConfig config = AEConfig.instance();
    private final List<SavedSlotInfo> savedSlotInfos = new ArrayList<SavedSlotInfo>();
    private boolean focusChangedToSomething = false;

    public AEBaseScreen(T menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title);
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.style = Objects.requireNonNull(style, "style");
        this.widgets = new WidgetContainer(style);
        this.verticalToolbar = new VerticalButtonBar();
        this.widgets.add("verticalToolbar", this.verticalToolbar);
        this.helpButton = this.addToLeftToolbar(new OpenGuideButton(btn -> this.openHelp()));
        if (style.getGeneratedBackground() != null) {
            this.f_97726_ = style.getGeneratedBackground().getWidth();
            this.f_97727_ = style.getGeneratedBackground().getHeight();
        } else if (style.getBackground() != null) {
            this.f_97726_ = style.getBackground().getSrcWidth();
            this.f_97727_ = style.getBackground().getSrcHeight();
        }
    }

    @MustBeInvokedByOverriders
    protected void m_7856_() {
        super.m_7856_();
        this.positionSlots();
        this.widgets.populateScreen(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, this.getBounds(true), this);
    }

    private void positionSlots() {
        for (Map.Entry<String, SlotPosition> entry : this.style.getSlots().entrySet()) {
            SlotSemantic semantic = SlotSemantics.getOrThrow(entry.getKey());
            if (this.hiddenSlots.contains(semantic)) continue;
            this.repositionSlots(semantic);
        }
    }

    private Point getSlotPosition(SlotPosition position, int semanticIndex) {
        Point pos = position.resolve(this.getBounds(false));
        SlotGridLayout grid = position.getGrid();
        if (grid != null) {
            pos = grid.getPosition(pos.getX(), pos.getY(), semanticIndex);
        }
        return pos;
    }

    public final void repositionSlots(SlotSemantic semantic) {
        SlotPosition position = this.style.getSlots().get(semantic.id());
        if (position.isHidden()) {
            ((AEBaseMenu)this.f_97732_).hideSlot(semantic.id());
            this.setSlotsHidden(semantic, true);
            return;
        }
        List<Slot> slots = ((AEBaseMenu)this.f_97732_).getSlots(semantic);
        for (int i = 0; i < slots.size(); ++i) {
            Slot slot = slots.get(i);
            if (slot instanceof ResizableSlot) {
                ResizableSlot resizableSlot = (ResizableSlot)slot;
                WidgetStyle widgetStyle = this.style.getWidget(resizableSlot.getStyleId());
                Point pos = widgetStyle.resolve(this.getBounds(false));
                slot.f_40220_ = pos.getX();
                slot.f_40221_ = pos.getY();
                resizableSlot.setWidth(widgetStyle.getWidth());
                resizableSlot.setHeight(widgetStyle.getHeight());
                continue;
            }
            Point pos = this.getSlotPosition(position, i);
            slot.f_40220_ = pos.getX();
            slot.f_40221_ = pos.getY();
        }
    }

    private Rect2i getBounds(boolean absolute) {
        if (absolute) {
            return new Rect2i(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        }
        return new Rect2i(0, 0, this.f_97726_, this.f_97727_);
    }

    private List<Slot> getInventorySlots() {
        return ((AEBaseMenu)this.f_97732_).f_38839_;
    }

    @MustBeInvokedByOverriders
    protected void updateBeforeRender() {
        this.helpButton.setVisibility(this.getHelpTopic() != null);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.updateBeforeRender();
        this.widgets.updateBeforeRender();
        super.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltips(guiGraphics, mouseX, mouseY);
        if (AEConfig.instance().isShowDebugGuiOverlays()) {
            List<Rect2i> exclusionZones = this.getExclusionZones();
            for (Rect2i rectangle2d : exclusionZones) {
                this.fillRect(guiGraphics, rectangle2d, 0x7F00FF00);
            }
            guiGraphics.m_280656_(this.f_97735_, this.f_97735_ + this.f_97726_ - 1, this.f_97736_, -1);
            guiGraphics.m_280656_(this.f_97735_, this.f_97735_ + this.f_97726_ - 1, this.f_97736_ + this.f_97727_ - 1, -1);
            guiGraphics.m_280315_(this.f_97735_, this.f_97736_, this.f_97736_ + this.f_97727_, -1);
            guiGraphics.m_280315_(this.f_97735_ + this.f_97726_ - 1, this.f_97736_, this.f_97736_ + this.f_97727_ - 1, -1);
        }
    }

    protected EmptyingAction getEmptyingAction(Slot slot, ItemStack carried) {
        ItemStack wrappedStack;
        AppEngSlot appEngSlot;
        block6: {
            block5: {
                if (!(slot instanceof AppEngSlot)) break block5;
                appEngSlot = (AppEngSlot)slot;
                if (!carried.m_41619_()) break block6;
            }
            return null;
        }
        InternalInventory internalInventory = appEngSlot.getInventory();
        if (!(internalInventory instanceof ConfigMenuInventory)) {
            return null;
        }
        ConfigMenuInventory configInv = (ConfigMenuInventory)internalInventory;
        EmptyingAction emptyingAction = ContainerItemStrategies.getEmptyingAction(carried);
        if (emptyingAction != null && configInv.isItemValid(slot.f_40217_, wrappedStack = GenericStack.wrapInItemStack(new GenericStack(emptyingAction.what(), 1L)))) {
            return emptyingAction;
        }
        return null;
    }

    private boolean renderEmptyingTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        EmptyingAction emptyingAction = this.getEmptyingAction(this.f_97734_, ((AEBaseMenu)this.f_97732_).m_142621_());
        if (emptyingAction != null) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, Tooltips.getEmptyingTooltip(ButtonToolTips.SetAction, ((AEBaseMenu)this.f_97732_).m_142621_(), emptyingAction));
            return true;
        }
        return false;
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Object appEngSlot;
        List<Component> customTooltip;
        if (this.renderEmptyingTooltip(guiGraphics, mouseX, mouseY)) {
            return;
        }
        Slot slot = this.f_97734_;
        if (slot instanceof AppEngSlot && (customTooltip = ((AppEngSlot)((Object)(appEngSlot = (AppEngSlot)slot))).getCustomTooltip(((AEBaseMenu)this.f_97732_).m_142621_())) != null) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, customTooltip);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.f_97734_ != null && this.f_97734_.m_6657_()) {
            return;
        }
        for (Renderable c : this.f_169369_) {
            Tooltip tooltip;
            Rect2i area;
            ITooltip tooltipWidget;
            if (!(c instanceof ITooltip) || !(tooltipWidget = (ITooltip)c).isTooltipAreaVisible() || mouseX < (area = tooltipWidget.getTooltipArea()).m_110085_() || mouseY < area.m_110086_() || mouseX >= area.m_110085_() + area.m_110090_() || mouseY >= area.m_110086_() + area.m_110091_() || (tooltip = new Tooltip(tooltipWidget.getTooltipMessage())).getContent().isEmpty()) continue;
            this.drawTooltipWithHeader(guiGraphics, tooltip, mouseX, mouseY);
        }
        Tooltip tooltip = this.widgets.getTooltip(mouseX - this.f_97735_, mouseY - this.f_97736_);
        if (tooltip != null) {
            this.drawTooltipWithHeader(guiGraphics, tooltip, mouseX, mouseY);
        }
    }

    private void drawTooltipWithHeader(GuiGraphics guiGraphics, Tooltip tooltip, int mouseX, int mouseY) {
        this.drawTooltipWithHeader(guiGraphics, mouseX, mouseY, tooltip.getContent());
    }

    public void drawTooltip(GuiGraphics guiGraphics, int x, int y, List<Component> lines) {
        if (lines.isEmpty()) {
            return;
        }
        int maxWidth = this.f_96543_ / 2 - 40;
        ArrayList styledLines = new ArrayList(lines.size());
        for (Component line : lines) {
            styledLines.addAll(ComponentRenderUtils.m_94005_((FormattedText)line, (int)maxWidth, (Font)this.f_96547_));
        }
        guiGraphics.m_280245_(this.f_96547_, styledLines, x, y);
    }

    public void drawTooltipWithHeader(GuiGraphics guiGraphics, int x, int y, List<Component> lines) {
        if (lines.isEmpty()) {
            return;
        }
        ArrayList<Component> formattedLines = new ArrayList<Component>(lines.size());
        for (int i = 0; i < lines.size(); ++i) {
            if (i == 0) {
                formattedLines.add((Component)lines.get(i).m_6881_().m_130938_(s -> s.m_131140_(ChatFormatting.WHITE)));
                continue;
            }
            formattedLines.add((Component)lines.get(i).m_6881_().m_130938_(s -> {
                if (s.m_131135_() != null) {
                    return s;
                }
                return s.m_131140_(ChatFormatting.GRAY);
            }));
        }
        this.drawTooltip(guiGraphics, x, y, formattedLines);
    }

    protected final void m_280003_(GuiGraphics guiGraphics, int x, int y) {
        int ox = this.f_97735_;
        int oy = this.f_97736_;
        this.widgets.drawForegroundLayer(guiGraphics, this.getBounds(false), new Point(x - ox, y - oy));
        this.drawFG(guiGraphics, ox, oy, x, y);
        if (this.style != null) {
            for (Map.Entry<String, Text> entry : this.style.getText().entrySet()) {
                TextOverride override = this.textOverrides.get(entry.getKey());
                this.drawText(guiGraphics, entry.getValue(), override);
            }
        }
    }

    private void drawText(GuiGraphics guiGraphics, Text text, @Nullable TextOverride override) {
        List lines;
        if (override != null && override.isHidden()) {
            return;
        }
        int color = this.style.getColor(text.getColor()).toARGB();
        Point pos = text.getPosition().resolve(this.getBounds(false));
        float scale = text.getScale();
        Component content = text.getText();
        if (override != null && override.getContent() != null) {
            content = override.getContent().m_6881_().m_130948_(content.m_7383_());
        }
        if (text.getMaxWidth() <= 0) {
            FormattedCharSequence line = content.m_7532_();
            lines = List.of(line);
        } else {
            lines = this.f_96547_.m_92923_((FormattedText)content, text.getMaxWidth());
        }
        int y = pos.getY();
        for (FormattedCharSequence line : lines) {
            int lineWidth = this.f_96547_.m_92724_(line);
            int x = pos.getX();
            if (text.getAlign() == TextAlignment.CENTER) {
                textWidth = Math.round((float)lineWidth * scale);
                x -= textWidth / 2;
            } else if (text.getAlign() == TextAlignment.RIGHT) {
                textWidth = Math.round((float)lineWidth * scale);
                x -= textWidth;
            }
            if (text.getScale() == 1.0f) {
                guiGraphics.m_280649_(this.f_96547_, line, x, y, color, false);
            } else {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)x, (float)y, 1.0f);
                guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
                guiGraphics.m_280649_(this.f_96547_, line, 0, 0, color, false);
                guiGraphics.m_280168_().m_85849_();
            }
            float f = y;
            float f2 = text.getScale();
            Objects.requireNonNull(this.f_96547_);
            y = (int)(f + f2 * 9.0f);
        }
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    protected final void m_7286_(GuiGraphics guiGraphics, float f, int x, int y) {
        this.drawBG(guiGraphics, this.f_97735_, this.f_97736_, x, y, f);
        this.widgets.drawBackgroundLayer(guiGraphics, this.getBounds(true), new Point(x - this.f_97735_, y - this.f_97736_));
        for (Slot slot : this.getInventorySlots()) {
            if (!(slot instanceof IOptionalSlot)) continue;
            this.drawOptionalSlotBackground(guiGraphics, (IOptionalSlot)slot, false);
        }
    }

    private void drawOptionalSlotBackground(GuiGraphics guiGraphics, IOptionalSlot slot, boolean alwaysDraw) {
        if (alwaysDraw || slot.isRenderDisabled()) {
            float alpha = slot.isSlotEnabled() ? 1.0f : 0.4f;
            Point pos = slot.getBackgroundPos();
            Icon.SLOT_BACKGROUND.getBlitter().dest(this.f_97735_ + pos.getX(), this.f_97736_ + pos.getY()).color(1.0f, 1.0f, 1.0f, alpha).blit(guiGraphics);
        }
    }

    private Point getMousePoint(double x, double y) {
        return new Point((int)Math.round(x - (double)this.f_97735_), (int)Math.round(y - (double)this.f_97736_));
    }

    public void m_7522_(@Nullable GuiEventListener listener) {
        if (listener != null) {
            this.focusChangedToSomething = true;
        }
        super.m_7522_(listener);
    }

    public boolean m_6050_(double x, double y, double wheelDelta) {
        return wheelDelta != 0.0 && this.widgets.onMouseWheel(this.getMousePoint(x, y), wheelDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        ComponentPath currentFocus;
        this.drag_click.clear();
        if (btn == 1) {
            this.handlingRightClick = true;
            try {
                for (GuiEventListener widget : this.m_6702_()) {
                    if (!widget.m_5953_(xCoord, yCoord)) continue;
                    boolean bl = super.m_6375_(xCoord, yCoord, 0);
                    return bl;
                }
            }
            finally {
                this.handlingRightClick = false;
            }
        }
        if (this.widgets.onMouseDown(this.getMousePoint(xCoord, yCoord), btn)) {
            return true;
        }
        this.focusChangedToSomething = false;
        boolean result = super.m_6375_(xCoord, yCoord, btn);
        if (!this.focusChangedToSomething && (currentFocus = this.m_264435_()) != null) {
            currentFocus.m_264432_(false);
        }
        return result;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.widgets.onMouseUp(this.getMousePoint(mouseX, mouseY), button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        ItemStack itemstack = ((AEBaseMenu)this.m_6262_()).m_142621_();
        Point mousePos = new Point((int)Math.round(mouseX - (double)this.f_97735_), (int)Math.round(mouseY - (double)this.f_97736_));
        if (this.widgets.onMouseDrag(mousePos, mouseButton)) {
            return true;
        }
        if (slot instanceof FakeSlot && !itemstack.m_41619_()) {
            this.drag_click.add(slot);
            if (this.drag_click.size() > 1) {
                for (Slot dr : this.drag_click) {
                    InventoryActionPacket p = new InventoryActionPacket(mouseButton == 0 ? InventoryAction.PICKUP_OR_SET_DOWN : InventoryAction.PLACE_SINGLE, dr.f_40219_, 0L);
                    NetworkHandler.instance().sendToServer(p);
                }
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    protected void m_6597_(@Nullable Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (((AEBaseMenu)this.m_6262_()).isClientSideSlot(slot)) {
            return;
        }
        if (slot instanceof DisabledSlot) {
            return;
        }
        if (this.drag_click.size() <= 1 && mouseButton == 1 && this.getEmptyingAction(slot, ((AEBaseMenu)this.f_97732_).m_142621_()) != null) {
            InventoryActionPacket p = new InventoryActionPacket(InventoryAction.EMPTY_ITEM, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof FakeSlot) {
            if (this.drag_click.size() > 1) {
                return;
            }
            InventoryAction action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof CraftingTermSlot) {
            InventoryAction action = AEBaseScreen.m_96638_() ? InventoryAction.CRAFT_SHIFT : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot != null && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)32)) {
            int slotNum = slot.f_40219_;
            InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slotNum, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot != null && !this.disableShiftClick && AEBaseScreen.m_96638_() && mouseButton == 0) {
            this.disableShiftClick = true;
            if (this.dbl_whichItem.m_41619_() || this.bl_clicked != slot || this.dbl_clickTimer.elapsed(TimeUnit.MILLISECONDS) > 250L) {
                this.bl_clicked = slot;
                this.dbl_clickTimer = Stopwatch.createStarted();
                this.dbl_whichItem = slot.m_6657_() ? slot.m_7993_().m_41777_() : ItemStack.f_41583_;
            } else if (!this.dbl_whichItem.m_41619_()) {
                List<Slot> slots = this.getInventorySlots();
                for (Slot inventorySlot : slots) {
                    if (inventorySlot == null || !inventorySlot.m_8010_((Player)this.getPlayer()) || !inventorySlot.m_6657_() || !AEBaseScreen.isSameInventory(inventorySlot, slot) || !AbstractContainerMenu.m_38899_((Slot)inventorySlot, (ItemStack)this.dbl_whichItem, (boolean)true)) continue;
                    this.m_6597_(inventorySlot, inventorySlot.f_40219_, 0, ClickType.QUICK_MOVE);
                }
                this.dbl_whichItem = ItemStack.f_41583_;
            }
            this.disableShiftClick = false;
        }
        super.m_6597_(slot, slotIdx, mouseButton, clickType);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int screenX, int screenY, int button) {
        Point mousePos = new Point((int)Math.round(mouseX - (double)screenX), (int)Math.round(mouseY - (double)screenY));
        if (this.widgets.hitTest(mousePos)) {
            return false;
        }
        return super.m_7467_(mouseX, mouseY, screenX, screenY, button);
    }

    protected LocalPlayer getPlayer() {
        return Objects.requireNonNull(this.getMinecraft().f_91074_);
    }

    protected boolean m_97805_(int keyCode, int scanCode) {
        Slot theSlot = this.getSlotUnderMouse();
        if (((AEBaseMenu)this.m_6262_()).m_142621_().m_41619_() && theSlot != null) {
            if (this.f_96541_.f_91066_.f_92093_.m_90832_(keyCode, scanCode)) {
                this.m_6597_(theSlot, theSlot.f_40219_, 40, ClickType.SWAP);
                return true;
            }
            for (int j = 0; j < 9; ++j) {
                if (!this.getMinecraft().f_91066_.f_92056_[j].m_90832_(keyCode, scanCode)) continue;
                List<Slot> slots = this.getInventorySlots();
                for (Slot s : slots) {
                    if (s.f_40217_ != j || s.f_40218_ != ((AEBaseMenu)this.f_97732_).getPlayerInventory() || s.m_8010_(((AEBaseMenu)this.f_97732_).getPlayerInventory().f_35978_)) continue;
                    return false;
                }
                if (theSlot.m_6641_() == 64) {
                    this.m_6597_(theSlot, theSlot.f_40219_, j, ClickType.SWAP);
                    return true;
                }
                for (Slot s : slots) {
                    if (s.f_40217_ != j || s.f_40218_ != ((AEBaseMenu)this.f_97732_).getPlayerInventory()) continue;
                    NetworkHandler.instance().sendToServer(new SwapSlotsPacket(s.f_40219_, theSlot.f_40219_));
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean m_97774_(Slot slot, double x, double y) {
        if (slot instanceof ResizableSlot) {
            ResizableSlot resizableSlot = (ResizableSlot)slot;
            int width = resizableSlot.getWidth();
            int height = resizableSlot.getHeight();
            return this.m_6774_(slot.f_40220_, slot.f_40221_, width, height, x, y);
        }
        return super.m_97774_(slot, x, y);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        Blitter background;
        GeneratedBackground generatedBackground = this.style.getGeneratedBackground();
        if (generatedBackground != null) {
            BackgroundGenerator.draw(generatedBackground.getWidth(), generatedBackground.getHeight(), guiGraphics, offsetX, offsetY);
        }
        if ((background = this.style.getBackground()) != null) {
            background.dest(offsetX, offsetY).blit(guiGraphics);
        }
    }

    public void drawItem(GuiGraphics guiGraphics, int x, int y, ItemStack is) {
        guiGraphics.m_280480_(is, x, y);
        guiGraphics.m_280370_(this.f_96547_, is, x, y);
    }

    protected Component getGuiDisplayName(Component in) {
        return this.f_96539_.getString().isEmpty() ? in : this.f_96539_;
    }

    public void m_280092_(GuiGraphics guiGraphics, Slot s) {
        if (s instanceof AppEngSlot) {
            AppEngSlot appEngSlot = (AppEngSlot)s;
            try {
                this.renderAppEngSlot(guiGraphics, appEngSlot);
            }
            catch (Exception err) {
                AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err, new Object[0]);
            }
        } else {
            super.m_280092_(guiGraphics, s);
        }
    }

    private void renderAppEngSlot(GuiGraphics guiGraphics, AppEngSlot s) {
        ItemStack is = s.m_7993_();
        if ((s.renderIconWithItem() || is.m_41619_()) && s.isSlotEnabled() && s.getIcon() != null) {
            s.getIcon().getBlitter().dest(s.f_40220_, s.f_40221_).opacity(s.getOpacityOfIcon()).blit(guiGraphics);
        }
        if (!s.isValid()) {
            guiGraphics.m_280509_(s.f_40220_, s.f_40221_, 16 + s.f_40220_, 16 + s.f_40221_, 0x66FF6666);
        }
        super.m_280092_(guiGraphics, (Slot)s);
    }

    public void m_181908_() {
        super.m_181908_();
        this.widgets.tick();
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof ITickingWidget)) continue;
            ((ITickingWidget)child).tick();
        }
    }

    public boolean isHandlingRightClick() {
        return this.handlingRightClick;
    }

    protected final <B extends Button> B addToLeftToolbar(B button) {
        this.verticalToolbar.add(button);
        return button;
    }

    public List<Rect2i> getExclusionZones() {
        ArrayList<Rect2i> result = new ArrayList<Rect2i>(2);
        this.widgets.addExclusionZones(result, this.getBounds(true));
        return result;
    }

    protected void fillRect(GuiGraphics guiGraphics, Rect2i rect, int color) {
        guiGraphics.m_280509_(rect.m_110085_(), rect.m_110086_(), rect.m_110085_() + rect.m_110090_(), rect.m_110086_() + rect.m_110091_(), color);
    }

    private TextOverride getOrCreateTextOverride(String id) {
        return this.textOverrides.computeIfAbsent(id, x -> new TextOverride());
    }

    protected final void setTextHidden(String id, boolean hidden) {
        this.getOrCreateTextOverride(id).setHidden(hidden);
    }

    public final void setSlotsHidden(SlotSemantic semantic, boolean hidden) {
        if (hidden) {
            if (this.hiddenSlots.add(semantic)) {
                for (Slot slot : ((AEBaseMenu)this.f_97732_).getSlots(semantic)) {
                    slot.f_40220_ = HIDDEN_SLOT_POS.getX();
                    slot.f_40221_ = HIDDEN_SLOT_POS.getY();
                }
            }
        } else if (this.hiddenSlots.remove(semantic) && this.style != null) {
            this.positionSlots();
        }
    }

    protected final void setTextContent(String id, Component content) {
        this.getOrCreateTextOverride(id).setContent(content);
    }

    public ScreenStyle getStyle() {
        return this.style;
    }

    @Nullable
    public StackWithBounds getStackUnderMouse(double mouseX, double mouseY) {
        if (this.f_97734_ != null) {
            return StackWithBounds.fromSlot(this, this.f_97734_);
        }
        return null;
    }

    public final int getGuiLeft() {
        return this.f_97735_;
    }

    public final int getGuiTop() {
        return this.f_97736_;
    }

    public final Minecraft getMinecraft() {
        return this.f_96541_;
    }

    public final Slot getSlotUnderMouse() {
        return this.f_97734_;
    }

    public static boolean isSameInventory(Slot a, Slot b) {
        if (a instanceof AppEngSlot) {
            AppEngSlot appEngSlotA = (AppEngSlot)a;
            if (b instanceof AppEngSlot) {
                AppEngSlot appEngSlotB = (AppEngSlot)b;
                return appEngSlotA.f_40218_ == appEngSlotB.f_40218_;
            }
        }
        return a.f_40218_ == b.f_40218_;
    }

    public void renderCustomSlotHighlight(GuiGraphics guiGraphics, int x, int y, int z) {
        int h;
        int w;
        Slot slot = this.f_97734_;
        if (slot instanceof ResizableSlot) {
            ResizableSlot resizableSlot = (ResizableSlot)slot;
            w = resizableSlot.getWidth();
            h = resizableSlot.getHeight();
        } else {
            w = 16;
            h = 16;
        }
        guiGraphics.m_285978_(RenderType.m_286086_(), x, y, x + w, y + h, -2130706433, -2130706433, z);
    }

    protected final void switchToScreen(AEBaseScreen<?> screen) {
        this.savedSlotInfos.clear();
        for (Slot slot : ((AEBaseMenu)this.f_97732_).f_38839_) {
            this.savedSlotInfos.add(new SavedSlotInfo(slot));
            slot.f_40220_ = HIDDEN_SLOT_POS.getX();
            slot.f_40221_ = HIDDEN_SLOT_POS.getY();
        }
        this.f_96541_.f_91080_ = null;
        this.f_96541_.m_91152_(screen);
        if (!screen.savedSlotInfos.isEmpty()) {
            for (SavedSlotInfo savedSlotInfo : screen.savedSlotInfos) {
                savedSlotInfo.restore();
            }
            screen.savedSlotInfos.clear();
        }
    }

    protected <P extends AEBaseScreen<T>> void onReturnFromSubScreen(AESubScreen<T, P> subScreen) {
    }

    protected void openHelp() {
        PageAnchor topic = this.getHelpTopic();
        if (topic != null) {
            AppEng.instance().openGuideAtAnchor(topic);
        } else {
            LOG.warn("No topic assigned to screen {}, but button was clicked", (Object)this);
        }
    }

    @Nullable
    protected PageAnchor getHelpTopic() {
        String helpTopic = this.style.getHelpTopic();
        if (helpTopic != null) {
            int sep = helpTopic.indexOf(35);
            String fragment = null;
            if (sep != -1) {
                fragment = helpTopic.substring(sep + 1);
                helpTopic = helpTopic.substring(0, sep);
            }
            try {
                return new PageAnchor(AppEng.makeId(helpTopic), fragment);
            }
            catch (Exception e) {
                LOG.warn("Invalid helpTopic for screen {}: {}", (Object)this, (Object)helpTopic);
            }
        }
        Guide guide = AppEngClient.instance().getGuide();
        ItemIndex itemIndex = guide.getIndex(ItemIndex.class);
        Object target = ((AEBaseMenu)this.m_6262_()).getTarget();
        if (target instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)target;
            Block block = be.m_58900_().m_60734_();
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
            return (PageAnchor)itemIndex.get(blockId);
        }
        if (target instanceof IPart) {
            IPart part = (IPart)target;
            Item item = part.getPartItem().m_5456_();
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            return (PageAnchor)itemIndex.get(itemId);
        }
        if (target instanceof ItemMenuHost) {
            ItemMenuHost menuHost = (ItemMenuHost)target;
            Item item = menuHost.getItemStack().m_41720_();
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            return (PageAnchor)itemIndex.get(itemId);
        }
        return null;
    }

    record SavedSlotInfo(Slot slot, boolean active, int x, int y) {
        public SavedSlotInfo(Slot slot) {
            this(slot, slot.m_6659_(), slot.f_40220_, slot.f_40221_);
        }

        public void restore() {
            Slot slot = this.slot;
            if (slot instanceof AppEngSlot) {
                AppEngSlot appEngSlot = (AppEngSlot)slot;
                appEngSlot.setActive(this.active);
            }
            this.slot.f_40220_ = this.x;
            this.slot.f_40221_ = this.y;
        }
    }
}

