/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.util.AEColor;
import appeng.block.paint.PaintSplotches;
import appeng.block.paint.PaintSplotchesBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.helpers.Splotch;
import appeng.items.misc.PaintBallItem;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class PaintSplotchesBlockEntity
extends AEBaseBlockEntity {
    public static final ModelProperty<PaintSplotches> SPLOTCHES = new ModelProperty();
    private List<Splotch> dots = null;

    public PaintSplotchesBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        FriendlyByteBuf myDat = new FriendlyByteBuf(Unpooled.buffer());
        this.writeBuffer(myDat);
        if (myDat.hasArray()) {
            data.m_128382_("dots", myDat.array());
        }
    }

    private void writeBuffer(FriendlyByteBuf out) {
        if (this.dots == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(this.dots.size());
        for (Splotch s : this.dots) {
            s.writeToStream(out);
        }
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        if (data.m_128441_("dots")) {
            this.readBuffer(new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])data.m_128463_("dots"))));
        }
    }

    private void readBuffer(FriendlyByteBuf in) {
        int howMany = in.readByte();
        if (howMany == 0) {
            this.dots = null;
            return;
        }
        this.dots = new ArrayList<Splotch>(howMany);
        for (int x = 0; x < howMany; ++x) {
            this.dots.add(new Splotch(in));
        }
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        this.writeBuffer(data);
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        super.readFromStream(data);
        this.readBuffer(data);
        return true;
    }

    public void neighborChanged() {
        if (this.dots == null) {
            return;
        }
        for (Direction side : Direction.values()) {
            if (this.isSideValid(side)) continue;
            this.removeSide(side);
        }
        this.updateData();
    }

    public boolean isSideValid(Direction side) {
        BlockPos p = this.f_58858_.m_121945_(side);
        BlockState blk = this.f_58857_.m_8055_(p);
        return blk.m_60783_((BlockGetter)this.f_58857_, p, side.m_122424_());
    }

    private void removeSide(Direction side) {
        this.dots.removeIf(s -> s.getSide() == side);
        this.markForUpdate();
        this.saveChanges();
    }

    private void updateData() {
        if (this.dots.isEmpty()) {
            this.dots = null;
        }
        if (this.dots == null) {
            this.f_58857_.m_7471_(this.f_58858_, false);
        } else {
            int lumenCount = 0;
            for (Splotch dot : this.dots) {
                if (dot.isLumen() && ++lumenCount >= 2) break;
            }
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PaintSplotchesBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(lumenCount)));
        }
    }

    public void cleanSide(Direction side) {
        if (this.dots == null) {
            return;
        }
        this.removeSide(side);
        this.updateData();
    }

    public void addBlot(ItemStack type, Direction side, Vec3 hitVec) {
        BlockPos p = this.f_58858_.m_121945_(side);
        BlockState blk = this.f_58857_.m_8055_(p);
        if (blk.m_60783_((BlockGetter)this.f_58857_, p, side.m_122424_())) {
            PaintBallItem ipb = (PaintBallItem)type.m_41720_();
            AEColor col = ipb.getColor();
            boolean lit = ipb.isLumen();
            if (this.dots == null) {
                this.dots = new ArrayList<Splotch>();
            }
            if (this.dots.size() > 20) {
                this.dots.remove(0);
            }
            this.dots.add(new Splotch(col, lit, side, hitVec));
            this.updateData();
            this.markForUpdate();
            this.saveChanges();
        }
    }

    public Collection<Splotch> getDots() {
        if (this.dots == null) {
            return Collections.emptyList();
        }
        return this.dots;
    }

    @Override
    public ModelData getModelData() {
        return ModelData.builder().with(SPLOTCHES, (Object)new PaintSplotches(this.getDots())).build();
    }
}

