/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.block;

import com.progwml6.ironshulkerbox.common.Util;
import com.progwml6.ironshulkerbox.common.block.CopperShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.CrystalShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.DiamondShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.GoldShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.ObsidianShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.CopperShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.CrystalShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.DiamondShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.GoldShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.IronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.ObsidianShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public enum IronShulkerBoxesTypes implements StringRepresentable
{
    IRON(54, 9, 184, 222, new ResourceLocation("ironshulkerbox", "textures/gui/iron_container.png"), 256, 256),
    GOLD(81, 9, 184, 276, new ResourceLocation("ironshulkerbox", "textures/gui/gold_container.png"), 256, 276),
    DIAMOND(108, 12, 238, 276, new ResourceLocation("ironshulkerbox", "textures/gui/diamond_container.png"), 256, 276),
    COPPER(45, 9, 184, 204, new ResourceLocation("ironshulkerbox", "textures/gui/copper_container.png"), 256, 256),
    CRYSTAL(108, 12, 238, 276, new ResourceLocation("ironshulkerbox", "textures/gui/diamond_container.png"), 256, 276),
    OBSIDIAN(108, 12, 238, 276, new ResourceLocation("ironshulkerbox", "textures/gui/diamond_container.png"), 256, 276),
    VANILLA(0, 0, 0, 0, new ResourceLocation("textures/gui/container/shulker_box.png"), 0, 0);

    private final String name = Util.toEnglishName(this.name());
    public final int size;
    public final int rowLength;
    public final int xSize;
    public final int ySize;
    public final ResourceLocation guiTexture;
    public final int textureXSize;
    public final int textureYSize;

    private IronShulkerBoxesTypes(int size, int rowLength, int xSize, int ySize, ResourceLocation guiTexture, int textureXSize, int textureYSize) {
        this.size = size;
        this.rowLength = rowLength;
        this.xSize = xSize;
        this.ySize = ySize;
        this.guiTexture = guiTexture;
        this.textureXSize = textureXSize;
        this.textureYSize = textureYSize;
    }

    public String getId() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getEnglishName() {
        return this.name;
    }

    public String m_7912_() {
        return this.getEnglishName();
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public boolean isTransparent() {
        return this == CRYSTAL;
    }

    @Nullable
    public AbstractIronShulkerBoxBlockEntity makeEntity(BlockPos blockPos, BlockState blockState, @Nullable DyeColor color) {
        return switch (this) {
            case IRON -> new IronShulkerBoxBlockEntity(color, blockPos, blockState);
            case GOLD -> new GoldShulkerBoxBlockEntity(color, blockPos, blockState);
            case DIAMOND -> new DiamondShulkerBoxBlockEntity(color, blockPos, blockState);
            case COPPER -> new CopperShulkerBoxBlockEntity(color, blockPos, blockState);
            case CRYSTAL -> new CrystalShulkerBoxBlockEntity(color, blockPos, blockState);
            case OBSIDIAN -> new ObsidianShulkerBoxBlockEntity(color, blockPos, blockState);
            default -> null;
        };
    }

    public static Block get(IronShulkerBoxesTypes type, @Nullable DyeColor color) {
        if (color == null) {
            return switch (type) {
                case IRON -> (IronShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get());
                case GOLD -> (GoldShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get());
                case DIAMOND -> (DiamondShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get());
                case CRYSTAL -> (CrystalShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get());
                case COPPER -> (CopperShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get());
                case OBSIDIAN -> (ObsidianShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get());
                default -> Blocks.f_50456_;
            };
        }
        return switch (type) {
            case IRON -> (IronShulkerBoxBlock)((Object)((RegistryObject)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get());
            case GOLD -> (GoldShulkerBoxBlock)((Object)((RegistryObject)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get());
            case DIAMOND -> (DiamondShulkerBoxBlock)((Object)((RegistryObject)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get());
            case CRYSTAL -> (CrystalShulkerBoxBlock)((Object)((RegistryObject)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get());
            case COPPER -> (CopperShulkerBoxBlock)((Object)((RegistryObject)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get());
            case OBSIDIAN -> (ObsidianShulkerBoxBlock)((Object)((RegistryObject)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get());
            default -> {
                switch (color) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case WHITE: {
                        yield Blocks.f_50457_;
                    }
                    case ORANGE: {
                        yield Blocks.f_50458_;
                    }
                    case MAGENTA: {
                        yield Blocks.f_50459_;
                    }
                    case LIGHT_BLUE: {
                        yield Blocks.f_50460_;
                    }
                    case YELLOW: {
                        yield Blocks.f_50461_;
                    }
                    case LIME: {
                        yield Blocks.f_50462_;
                    }
                    case PINK: {
                        yield Blocks.f_50463_;
                    }
                    case GRAY: {
                        yield Blocks.f_50464_;
                    }
                    case LIGHT_GRAY: {
                        yield Blocks.f_50465_;
                    }
                    case CYAN: {
                        yield Blocks.f_50466_;
                    }
                    case PURPLE: {
                        yield Blocks.f_50520_;
                    }
                    case BLUE: {
                        yield Blocks.f_50521_;
                    }
                    case BROWN: {
                        yield Blocks.f_50522_;
                    }
                    case GREEN: {
                        yield Blocks.f_50523_;
                    }
                    case RED: {
                        yield Blocks.f_50524_;
                    }
                    case BLACK: 
                }
                yield Blocks.f_50525_;
            }
        };
    }
}

