/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.AdAstra;
import earth.terrarium.adastra.client.ClientPlatformUtils;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.dimension.AdAstraPlanetRenderers;
import earth.terrarium.adastra.client.models.armor.SpaceSuitModel;
import earth.terrarium.adastra.client.models.entities.mobs.CorruptedLunarianModel;
import earth.terrarium.adastra.client.models.entities.mobs.GlacianRamModel;
import earth.terrarium.adastra.client.models.entities.mobs.LunarianModel;
import earth.terrarium.adastra.client.models.entities.mobs.MartianRaptorModel;
import earth.terrarium.adastra.client.models.entities.mobs.MoglerModel;
import earth.terrarium.adastra.client.models.entities.mobs.PygroBruteModel;
import earth.terrarium.adastra.client.models.entities.mobs.PygroModel;
import earth.terrarium.adastra.client.models.entities.mobs.StarCrawlerModel;
import earth.terrarium.adastra.client.models.entities.mobs.SulfurCreeperModel;
import earth.terrarium.adastra.client.models.entities.mobs.ZombifiedPygroModel;
import earth.terrarium.adastra.client.models.entities.vehicles.LanderModel;
import earth.terrarium.adastra.client.models.entities.vehicles.RocketModel;
import earth.terrarium.adastra.client.models.entities.vehicles.RoverModel;
import earth.terrarium.adastra.client.particle.LargeFlameParticle;
import earth.terrarium.adastra.client.particle.OxygenBubbleParticle;
import earth.terrarium.adastra.client.radio.audio.RadioHandler;
import earth.terrarium.adastra.client.renderers.blocks.EnergizerBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.FlagBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.GlobeBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.GravityNormalizerBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.OxygenDistributorBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.blocks.SlidingDoorBlockEntityRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.CorruptedLunarianRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.GlacianRamRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.LunarianRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.LunarianWanderingTraderRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.MartianRaptorRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.MoglerRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.PygroBruteRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.PygroRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.StarCrawlerRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.SulfurCreeperRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.ZombifiedMoglerRenderer;
import earth.terrarium.adastra.client.renderers.entities.mobs.ZombifiedPygroRenderer;
import earth.terrarium.adastra.client.renderers.entities.vehicles.LanderRenderer;
import earth.terrarium.adastra.client.renderers.entities.vehicles.RocketRenderer;
import earth.terrarium.adastra.client.renderers.entities.vehicles.RoverRenderer;
import earth.terrarium.adastra.client.renderers.world.OverlayRenderer;
import earth.terrarium.adastra.client.screens.PlanetsScreen;
import earth.terrarium.adastra.client.screens.machines.CoalGeneratorScreen;
import earth.terrarium.adastra.client.screens.machines.CompressorScreen;
import earth.terrarium.adastra.client.screens.machines.CryoFreezerScreen;
import earth.terrarium.adastra.client.screens.machines.EtrionicBlastFurnaceScreen;
import earth.terrarium.adastra.client.screens.machines.FuelRefineryScreen;
import earth.terrarium.adastra.client.screens.machines.GravityNormalizerScreen;
import earth.terrarium.adastra.client.screens.machines.NasaWorkbenchScreen;
import earth.terrarium.adastra.client.screens.machines.OxygenDistributorScreen;
import earth.terrarium.adastra.client.screens.machines.OxygenLoaderScreen;
import earth.terrarium.adastra.client.screens.machines.SolarPanelScreen;
import earth.terrarium.adastra.client.screens.machines.WaterPumpScreen;
import earth.terrarium.adastra.client.screens.player.OverlayScreen;
import earth.terrarium.adastra.client.screens.vehicles.LanderScreen;
import earth.terrarium.adastra.client.screens.vehicles.RocketScreen;
import earth.terrarium.adastra.client.screens.vehicles.RoverScreen;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.items.EtrionicCapacitorItem;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundSyncKeybindPacket;
import earth.terrarium.adastra.common.registry.ModBlockEntityTypes;
import earth.terrarium.adastra.common.registry.ModBlocks;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import earth.terrarium.adastra.common.registry.ModItems;
import earth.terrarium.adastra.common.registry.ModMenus;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import earth.terrarium.adastra.common.tags.ModItemTags;
import earth.terrarium.adastra.common.utils.KeybindManager;
import earth.terrarium.adastra.common.utils.radio.RadioHolder;
import earth.terrarium.botarium.client.ClientHooks;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class AdAstraClient {
    public static final OverlayRenderer OXYGEN_OVERLAY_RENDERER = new OverlayRenderer(1083821311, () -> AdAstraConfigClient.showOxygenDistributorArea, (Supplier<Block>)ModBlocks.OXYGEN_DISTRIBUTOR);
    public static final OverlayRenderer GRAVITY_OVERLAY_RENDERER = new OverlayRenderer(1088302868, () -> AdAstraConfigClient.showGravityNormalizerArea, (Supplier<Block>)ModBlocks.GRAVITY_NORMALIZER);
    public static final KeyMapping KEY_TOGGLE_SUIT_FLIGHT = new KeyMapping(ConstantComponents.TOGGLE_SUIT_FLIGHT_KEY.getString(), 86, ConstantComponents.AD_ASTRA_CATEGORY.getString());
    public static final KeyMapping KEY_OPEN_RADIO = new KeyMapping(ConstantComponents.OPEN_RADIO_KEY.getString(), 82, ConstantComponents.AD_ASTRA_CATEGORY.getString());

    public static void init() {
        AdAstra.CONFIGURATOR.registerConfig(AdAstraConfigClient.class);
        AdAstraClient.registerScreens();
        AdAstraClient.registerBlockEntityRenderers();
        AdAstraClient.registerEntityRenderers();
        AdAstraClient.registerItemProperties();
        AdAstraClient.registerRenderLayers();
        AdAstraClient.registerArmor();
    }

    private static void registerScreens() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.COAL_GENERATOR.get()), CoalGeneratorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.COMPRESSOR.get()), CompressorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.ETRIONIC_BLAST_FURNACE.get()), EtrionicBlastFurnaceScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.OXYGEN_LOADER.get()), OxygenLoaderScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.FUEL_REFINERY.get()), FuelRefineryScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.WATER_PUMP.get()), WaterPumpScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.SOLAR_PANEL.get()), SolarPanelScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.OXYGEN_DISTRIBUTOR.get()), OxygenDistributorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.GRAVITY_NORMALIZER.get()), GravityNormalizerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.CRYO_FREEZER.get()), CryoFreezerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.NASA_WORKBENCH.get()), NasaWorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.ROCKET.get()), RocketScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.ROVER.get()), RoverScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.LANDER.get()), LanderScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.PLANETS.get()), PlanetsScreen::new);
    }

    private static void registerBlockEntityRenderers() {
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.ENERGIZER.get()), c -> new EnergizerBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.GLOBE.get()), c -> new GlobeBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.OXYGEN_DISTRIBUTOR.get()), c -> new OxygenDistributorBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.GRAVITY_NORMALIZER.get()), c -> new GravityNormalizerBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.FLAG.get()), c -> new FlagBlockEntityRenderer());
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.SLIDING_DOOR.get()), c -> new SlidingDoorBlockEntityRenderer());
    }

    private static void registerEntityRenderers() {
        ClientHooks.registerEntityRenderer(ModEntityTypes.AIR_VORTEX, NoopRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.ROVER, RoverRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_1_ROCKET, c -> new RocketRenderer(c, RocketModel.TIER_1_LAYER, RocketRenderer.TIER_1_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_2_ROCKET, c -> new RocketRenderer(c, RocketModel.TIER_2_LAYER, RocketRenderer.TIER_2_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_3_ROCKET, c -> new RocketRenderer(c, RocketModel.TIER_3_LAYER, RocketRenderer.TIER_3_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.TIER_4_ROCKET, c -> new RocketRenderer(c, RocketModel.TIER_4_LAYER, RocketRenderer.TIER_4_TEXTURE));
        ClientHooks.registerEntityRenderer(ModEntityTypes.LANDER, c -> new LanderRenderer(c, LanderModel.LAYER));
        ClientHooks.registerEntityRenderer(ModEntityTypes.LUNARIAN, LunarianRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.CORRUPTED_LUNARIAN, CorruptedLunarianRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.STAR_CRAWLER, StarCrawlerRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.MARTIAN_RAPTOR, MartianRaptorRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.PYGRO, PygroRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.ZOMBIFIED_PYGRO, ZombifiedPygroRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.PYGRO_BRUTE, PygroBruteRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.MOGLER, MoglerRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.ZOMBIFIED_MOGLER, ZombifiedMoglerRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.SULFUR_CREEPER, SulfurCreeperRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.LUNARIAN_WANDERING_TRADER, LunarianWanderingTraderRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.GLACIAN_RAM, GlacianRamRenderer::new);
        ClientHooks.registerEntityRenderer(ModEntityTypes.ICE_SPIT, ThrownItemRenderer::new);
    }

    public static void registerArmor() {
        ClientPlatformUtils.registerArmor(SpaceSuitModel.SPACE_SUIT_TEXTURE, SpaceSuitModel.SPACE_SUIT_LAYER, SpaceSuitModel::new, (Item)ModItems.SPACE_HELMET.get(), (Item)ModItems.SPACE_SUIT.get(), (Item)ModItems.SPACE_PANTS.get(), (Item)ModItems.SPACE_BOOTS.get());
        ClientPlatformUtils.registerArmor(SpaceSuitModel.NETHERITE_SPACE_SUIT_TEXTURE, SpaceSuitModel.NETHERITE_SPACE_SUIT_LAYER, SpaceSuitModel::new, (Item)ModItems.NETHERITE_SPACE_HELMET.get(), (Item)ModItems.NETHERITE_SPACE_SUIT.get(), (Item)ModItems.NETHERITE_SPACE_PANTS.get(), (Item)ModItems.NETHERITE_SPACE_BOOTS.get());
        ClientPlatformUtils.registerArmor(SpaceSuitModel.JET_SUIT_TEXTURE, SpaceSuitModel.JET_SUIT_LAYER, SpaceSuitModel::new, (Item)ModItems.JET_SUIT_HELMET.get(), (Item)ModItems.JET_SUIT.get(), (Item)ModItems.JET_SUIT_PANTS.get(), (Item)ModItems.JET_SUIT_BOOTS.get());
    }

    public static void onRegisterEntityLayers(ClientPlatformUtils.LayerDefinitionRegistry consumer) {
        consumer.register(RoverModel.LAYER, RoverModel::createBodyLayer);
        RocketModel.register(consumer);
        consumer.register(LanderModel.LAYER, LanderModel::createBodyLayer);
        SpaceSuitModel.register(consumer);
        consumer.register(LunarianModel.LAYER_LOCATION, LunarianModel::createBodyLayer);
        consumer.register(CorruptedLunarianModel.LAYER_LOCATION, CorruptedLunarianModel::createBodyLayer);
        consumer.register(StarCrawlerModel.LAYER_LOCATION, StarCrawlerModel::createBodyLayer);
        consumer.register(MartianRaptorModel.LAYER_LOCATION, MartianRaptorModel::createBodyLayer);
        consumer.register(PygroModel.LAYER_LOCATION, PygroModel::createBodyLayer);
        consumer.register(PygroBruteModel.LAYER_LOCATION, PygroBruteModel::createBodyLayer);
        consumer.register(ZombifiedPygroModel.LAYER_LOCATION, ZombifiedPygroModel::createBodyLayer);
        consumer.register(MoglerModel.LAYER_LOCATION, MoglerModel::createBodyLayer);
        consumer.register(SulfurCreeperModel.LAYER_LOCATION, SulfurCreeperModel::createBodyLayer);
        consumer.register(GlacianRamModel.LAYER_LOCATION, GlacianRamModel::createBodyLayer);
    }

    private static void registerItemProperties() {
        ClientHooks.registerItemProperty((Item)((Item)ModItems.ETRIONIC_CAPACITOR.get()), (ResourceLocation)new ResourceLocation("ad_astra", "toggled"), (stack, level, entity, i) -> EtrionicCapacitorItem.active(stack) ? 0.0f : 1.0f);
    }

    public static void registerRenderLayers() {
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.VENT.get()), (RenderType)RenderType.m_110463_());
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.STEEL_DOOR.get()), (RenderType)RenderType.m_110463_());
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.STEEL_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.AERONOS_LADDER.get()), (RenderType)RenderType.m_110463_());
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.STROPHAR_LADDER.get()), (RenderType)RenderType.m_110463_());
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.GLACIAN_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
    }

    public static void onRegisterParticles(BiConsumer<ParticleType<SimpleParticleType>, ClientPlatformUtils.SpriteParticleRegistration<SimpleParticleType>> consumer) {
        consumer.accept((ParticleType<SimpleParticleType>)((ParticleType)ModParticleTypes.ACID_RAIN.get()), SplashParticle.Provider::new);
        consumer.accept((ParticleType<SimpleParticleType>)((ParticleType)ModParticleTypes.LARGE_FLAME.get()), LargeFlameParticle.Provider::new);
        consumer.accept((ParticleType<SimpleParticleType>)((ParticleType)ModParticleTypes.LARGE_SMOKE.get()), LargeFlameParticle.Provider::new);
        consumer.accept((ParticleType<SimpleParticleType>)((ParticleType)ModParticleTypes.OXYGEN_BUBBLE.get()), OxygenBubbleParticle.Provider::new);
    }

    public static void onRegisterModels(Consumer<ResourceLocation> consumer) {
        ModBlocks.GLOBES.stream().forEach(b -> consumer.accept(new ResourceLocation("ad_astra", "block/%s_cube".formatted(b.getId().m_135815_()))));
        consumer.accept(new ResourceLocation("ad_astra", "block/%s_flipped".formatted(ModBlocks.AIRLOCK.getId().m_135815_())));
        consumer.accept(new ResourceLocation("ad_astra", "block/%s_flipped".formatted(ModBlocks.REINFORCED_DOOR.getId().m_135815_())));
        consumer.accept(OxygenDistributorBlockEntityRenderer.TOP);
        consumer.accept(GravityNormalizerBlockEntityRenderer.TOP);
        consumer.accept(GravityNormalizerBlockEntityRenderer.TOE);
    }

    public static void onRegisterItemRenderers(BiConsumer<Item, BlockEntityWithoutLevelRenderer> consumer) {
        ModItems.GLOBES.stream().forEach(item -> consumer.accept((Item)item.get(), new GlobeBlockEntityRenderer.ItemRenderer()));
        consumer.accept((Item)ModItems.OXYGEN_DISTRIBUTOR.get(), new OxygenDistributorBlockEntityRenderer.ItemRenderer());
        consumer.accept((Item)ModItems.GRAVITY_NORMALIZER.get(), new GravityNormalizerBlockEntityRenderer.ItemRenderer());
        consumer.accept((Item)ModItems.ROVER.get(), new RoverRenderer.ItemRenderer());
        consumer.accept((Item)ModItems.TIER_1_ROCKET.get(), new RocketRenderer.ItemRenderer(RocketModel.TIER_1_LAYER, RocketRenderer.TIER_1_TEXTURE));
        consumer.accept((Item)ModItems.TIER_2_ROCKET.get(), new RocketRenderer.ItemRenderer(RocketModel.TIER_2_LAYER, RocketRenderer.TIER_2_TEXTURE));
        consumer.accept((Item)ModItems.TIER_3_ROCKET.get(), new RocketRenderer.ItemRenderer(RocketModel.TIER_3_LAYER, RocketRenderer.TIER_3_TEXTURE));
        consumer.accept((Item)ModItems.TIER_4_ROCKET.get(), new RocketRenderer.ItemRenderer(RocketModel.TIER_4_LAYER, RocketRenderer.TIER_4_TEXTURE));
    }

    public static void onRegisterHud(Consumer<ClientPlatformUtils.RenderHud> consumer) {
        consumer.accept(OverlayScreen::render);
    }

    public static void onAddItemColors(BiConsumer<ItemColor, ItemLike[]> consumer) {
        consumer.accept((stack, i) -> i > 0 ? -1 : ((DyeableArmorItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)ModItems.SPACE_HELMET.get(), (ItemLike)ModItems.SPACE_SUIT.get(), (ItemLike)ModItems.SPACE_PANTS.get(), (ItemLike)ModItems.SPACE_BOOTS.get()});
        consumer.accept((stack, i) -> i > 0 ? -1 : ((DyeableArmorItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)ModItems.NETHERITE_SPACE_HELMET.get(), (ItemLike)ModItems.NETHERITE_SPACE_SUIT.get(), (ItemLike)ModItems.NETHERITE_SPACE_PANTS.get(), (ItemLike)ModItems.NETHERITE_SPACE_BOOTS.get()});
        consumer.accept((stack, i) -> i > 0 ? -1 : ((DyeableArmorItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)ModItems.JET_SUIT_HELMET.get(), (ItemLike)ModItems.JET_SUIT.get(), (ItemLike)ModItems.JET_SUIT_PANTS.get(), (ItemLike)ModItems.JET_SUIT_BOOTS.get()});
    }

    public static void renderOverlays(PoseStack stack, Camera camera) {
        OXYGEN_OVERLAY_RENDERER.render(stack, camera);
        GRAVITY_OVERLAY_RENDERER.render(stack, camera);
    }

    public static void onAddReloadListener(BiConsumer<ResourceLocation, PreparableReloadListener> consumer) {
        consumer.accept(new ResourceLocation("ad_astra", "planet_renderers"), (PreparableReloadListener)new AdAstraPlanetRenderers());
    }

    public static void clientTick(Minecraft minecraft) {
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (KEY_OPEN_RADIO.m_90859_() && player.m_20202_() instanceof RadioHolder) {
            RadioHandler.open(null);
        }
        if (player.m_6844_(EquipmentSlot.CHEST).m_204117_(ModItemTags.JET_SUITS)) {
            Options options = minecraft.f_91066_;
            if (KEY_TOGGLE_SUIT_FLIGHT.m_90859_()) {
                AdAstraConfigClient.jetSuitEnabled = !AdAstraConfigClient.jetSuitEnabled;
                Minecraft.m_91087_().m_6937_(() -> AdAstra.CONFIGURATOR.saveConfig(AdAstraConfigClient.class));
                player.m_5661_(AdAstraConfigClient.jetSuitEnabled ? ConstantComponents.SUIT_FLIGHT_ENABLED : ConstantComponents.SUIT_FLIGHT_DISABLED, true);
            }
            KeybindManager.set((Player)player, options.f_92089_.m_90857_(), options.f_92091_.m_90857_(), AdAstraConfigClient.jetSuitEnabled);
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundSyncKeybindPacket(options.f_92089_.m_90857_(), options.f_92091_.m_90857_(), AdAstraConfigClient.jetSuitEnabled));
        }
    }
}

