/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization.item;

import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.fertilization.item.CompressedBoneMealItem;
import net.blay09.mods.fertilization.item.ExtremelyCompressedBoneMealItem;
import net.blay09.mods.fertilization.item.FloristsBoneMealItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ModItems {
    public static CompressedBoneMealItem compressedBoneMeal;
    public static ExtremelyCompressedBoneMealItem extremelyCompressedBoneMeal;
    public static FloristsBoneMealItem floristsBoneMeal;

    public static void initialize(BalmItems items) {
        items.registerItem(() -> {
            compressedBoneMeal = new CompressedBoneMealItem(items.itemProperties());
            return compressedBoneMeal;
        }, ModItems.id("compressed_bonemeal"));
        items.registerItem(() -> {
            extremelyCompressedBoneMeal = new ExtremelyCompressedBoneMealItem(items.itemProperties());
            return extremelyCompressedBoneMeal;
        }, ModItems.id("extremely_compressed_bonemeal"));
        items.registerItem(() -> {
            floristsBoneMeal = new FloristsBoneMealItem(items.itemProperties());
            return floristsBoneMeal;
        }, ModItems.id("florists_bonemeal"));
        items.registerCreativeModeTab(ModItems.id("fertilization"), () -> new ItemStack((ItemLike)compressedBoneMeal));
    }

    public static void registerBoneMealDispenseBehaviour(final CompressedBoneMealItem boneMealItem) {
        DispenserBlock.m_52672_((ItemLike)boneMealItem, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack itemStack) {
                this.m_123573_(true);
                ServerLevel level = source.m_7727_();
                BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                BlockState state = level.m_8055_(pos);
                if (boneMealItem.applyBoneMeal((Level)level, pos, state, itemStack, null) != InteractionResult.SUCCESS) {
                    this.m_123573_(false);
                } else if (!level.f_46443_) {
                    level.m_46796_(2005, pos, 0);
                }
                if (this.m_123570_()) {
                    itemStack.m_41774_(1);
                }
                return itemStack;
            }
        });
    }

    private static ResourceLocation id(String name) {
        return new ResourceLocation("fertilization", name);
    }
}

