/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization.item;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.fertilization.BoneMealHelper;
import net.blay09.mods.fertilization.FertilizationConfig;
import net.blay09.mods.fertilization.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CompressedBoneMealItem
extends Item {
    public CompressedBoneMealItem(Item.Properties properties) {
        super(properties);
        ModItems.registerBoneMealDispenseBehaviour(this);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState state = level.m_8055_(pos);
        InteractionHand hand = context.m_43724_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack handItem = player.m_21120_(hand);
        InteractionResult result = this.applyBoneMeal(level, pos, state, handItem, player);
        if (result == InteractionResult.FAIL) {
            player.m_6674_(hand);
        } else if (result == InteractionResult.SUCCESS && !player.m_150110_().f_35937_) {
            handItem.m_41774_(1);
        }
        return result;
    }

    public InteractionResult applyBoneMeal(Level level, BlockPos pos, BlockState state, ItemStack itemStack, @Nullable Player player) {
        if (!(state.m_60734_() instanceof BonemealableBlock) || !((BonemealableBlock)state.m_60734_()).m_214167_(level, level.f_46441_, pos, state)) {
            return InteractionResult.PASS;
        }
        if (BoneMealHelper.isGrowableDisabledForCompressed(state)) {
            return InteractionResult.FAIL;
        }
        boolean isStem = BoneMealHelper.isStemCrop(state);
        ItemStack boneMealStack = itemStack.m_41777_();
        for (int i = 0; i < this.getBoneMealCount(); ++i) {
            BoneMealHelper.tryHarvest(player, level, pos);
            boolean boneMealApplied = Balm.getHooks().growCrop(boneMealStack, level, pos, player);
            if (!boneMealApplied && !isStem) break;
            if (!isStem || level.f_46443_) continue;
            state.m_222963_((ServerLevel)level, pos, level.f_46441_);
        }
        return InteractionResult.SUCCESS;
    }

    protected int getBoneMealCount() {
        return FertilizationConfig.getActive().compressedBoneMealPower;
    }
}

