/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.fertilization.FancyTree;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import org.jetbrains.annotations.Nullable;

public class ModWorldGen {
    private static final Map<Block, ResourceKey<ConfiguredFeature<?, ?>>> fancyTrees = new HashMap();
    private static final Map<Block, ResourceKey<ConfiguredFeature<?, ?>>> fancyBeeTrees = new HashMap();

    public static void initialize(BalmWorldGen worldGen) {
        ModWorldGen.registerFancyTree(Blocks.f_50746_, "oak");
        ModWorldGen.registerFancyTree(Blocks.f_50747_, "spruce");
        ModWorldGen.registerFancyTree(Blocks.f_50748_, "birch");
        ModWorldGen.registerFancyTree(Blocks.f_50749_, "jungle");
        ModWorldGen.registerFancyTree(Blocks.f_50750_, "acacia");
        ModWorldGen.registerFancyTree(Blocks.f_50751_, "dark_oak");
    }

    private static void registerFancyTree(Block sapling, String name) {
        fancyTrees.put(sapling, ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ModWorldGen.id("fancy_" + name)));
        fancyBeeTrees.put(sapling, ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ModWorldGen.id("fancy_" + name + "_bees")));
    }

    @Nullable
    public static AbstractTreeGrower getFancyTreeForSapling(BlockState state) {
        ResourceKey<ConfiguredFeature<?, ?>> fancyTree = fancyTrees.get(state.m_60734_());
        ResourceKey<ConfiguredFeature<?, ?>> fancyBeeTree = fancyBeeTrees.get(state.m_60734_());
        if (fancyTree != null && fancyBeeTree != null) {
            return new FancyTree(fancyTree, fancyBeeTree);
        }
        return null;
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyTreeConfigBuilder(Block logBlock, Block leavesBlock) {
        FancyFoliagePlacer foliagePlacer = new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4);
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)logBlock.m_49966_()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)leavesBlock.m_49966_()), (FoliagePlacer)foliagePlacer, (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_();
    }

    private static ResourceLocation id(String name) {
        return new ResourceLocation("fertilization", name);
    }
}

