/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.config.Config;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

@Config(value="fertilization")
public class FertilizationConfigData
implements BalmConfigData {
    @Comment(value="Set to true if compressed bone meal drops should go straight into the player's inventory.")
    public boolean addDropsDirectlyToInventory = false;
    @Comment(value="Set to true if compressed bone meal drops should go straight into the machine's inventory when used automatically.")
    public boolean addDropsDirectlyToInventoryForFakePlayers = true;
    @Comment(value="This enables use of extremely compressed bone meal to turn saplings into large fancy trees.")
    public boolean allowBoneMealOnSaplings = true;
    @Comment(value="This enables use of normal Bone Meal on vines in order to grow them downwards.")
    public boolean allowBoneMealOnVines = true;
    @Comment(value="This enables use of normal Bone Meal on sugar canes in order to grow them upwards.")
    public boolean allowBoneMealOnSugarCanes = true;
    @Comment(value="The amount of bone meal applied to the plant when using compressed bone meal.")
    public int compressedBoneMealPower = 4;
    @Comment(value="The amount of bone meal applied to the plant when using extremely compressed bone meal.")
    public int extremelyCompressedBoneMealPower = 36;
    @Comment(value="The maximum amount of flowers that can spawn when using Florist's Bone Meal on grass.")
    public int floristsBoneMealMaxFlowers = 5;
    @Comment(value="The maximum range that flowers can spawn when using Florist's Bone Meal on grass.")
    public int floristsBoneMealMaxRange = 3;
    @Comment(value="List of blocks that can be duplicated by using Florist's Bone Meal on them.")
    public List<String> flowerBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:poppy", "minecraft:dandelion", "minecraft:blue_orchid", "minecraft:allium", "minecraft:azure_bluet", "minecraft:red_tulip", "minecraft:orange_tulip", "minecraft:white_tulip", "minecraft:pink_tulip", "minecraft:oxeye_daisy", "minecraft:rose_bush", "minecraft:peony", "minecraft:lilac", "minecraft:sunflower", "minecraft:cornflower", "minecraft:lily_of_the_valley"});

    public boolean isFlowerBlock(Block block) {
        ResourceLocation registryName = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        return this.flowerBlocks.contains(registryName.toString());
    }
}

