/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.fertilization.FertilizationConfig;
import net.blay09.mods.fertilization.mixin.CropBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BoneMealHelper {
    @Nullable
    public static Item getSeedFromCrop(BlockState state) {
        if (state.m_60734_() == Blocks.f_50262_) {
            return Items.f_42533_;
        }
        if (state.m_60734_() instanceof CropBlockAccessor) {
            return ((CropBlockAccessor)state.m_60734_()).callGetBaseSeedId().m_5456_();
        }
        return null;
    }

    public static boolean isGrassBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_50440_;
    }

    public static boolean tryHarvest(@Nullable Player player, Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (BoneMealHelper.tryHarvestGeneric(player, level, pos, state, it -> it.m_60734_() instanceof CropBlock && ((CropBlock)it.m_60734_()).m_52307_(it), () -> ((CropBlock)state.m_60734_()).m_52289_(0), 0.25f)) {
            return true;
        }
        return BoneMealHelper.tryHarvestGeneric(player, level, pos, state, it -> it.m_60734_() == Blocks.f_50262_ && (Integer)it.m_61143_((Property)CocoaBlock.f_51736_) >= 2, () -> ((Block)Blocks.f_50262_).m_49966_(), -0.75f);
    }

    public static boolean tryHarvestGeneric(@Nullable Player player, Level level, BlockPos pos, BlockState state, Predicate<BlockState> isMature, Supplier<BlockState> newCropState, float spawnOffsetY) {
        ItemStack seedInInventory;
        if (!isMature.test(state)) {
            return false;
        }
        List drops = level instanceof ServerLevel ? Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null) : Collections.emptyList();
        Item seedItem = BoneMealHelper.getSeedFromCrop(state);
        boolean foundSeed = false;
        for (ItemStack itemStack : drops) {
            if (itemStack.m_41619_() || itemStack.m_41720_() != seedItem) continue;
            itemStack.m_41774_(1);
            foundSeed = true;
            break;
        }
        ItemStack itemStack = seedInInventory = player != null ? BoneMealHelper.findSeedInInventory(player, seedItem) : ItemStack.f_41583_;
        if (!foundSeed && !seedInInventory.m_41619_()) {
            seedInInventory.m_41774_(1);
            foundSeed = true;
        }
        if (!foundSeed) {
            return false;
        }
        if (!level.f_46443_) {
            level.m_46597_(pos, newCropState.get());
            for (ItemStack itemStack2 : drops) {
                if ((seedInInventory.m_41619_() && itemStack2.m_41720_() == seedItem || FertilizationConfig.getActive().addDropsDirectlyToInventory || FertilizationConfig.getActive().addDropsDirectlyToInventoryForFakePlayers && Balm.getHooks().isFakePlayer(player)) && player != null && player.m_150109_().m_36054_(itemStack2)) continue;
                ItemEntity entityItem = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + spawnOffsetY), (double)pos.m_123343_() + 0.5, itemStack2);
                entityItem.m_32010_(10);
                level.m_7967_((Entity)entityItem);
            }
        }
        return true;
    }

    private static ItemStack findSeedInInventory(Player player, @Nullable Item seedItem) {
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            if (itemStack.m_41619_() || itemStack.m_41720_() != seedItem) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean isStemCrop(BlockState state) {
        return state.m_60734_() == Blocks.f_50190_ || state.m_60734_() == Blocks.f_50189_;
    }

    public static boolean isGrowableDisabledForCompressed(BlockState state) {
        return BoneMealHelper.isGrassBlock(state) || state.m_60734_() == Blocks.f_50359_;
    }
}

