/*
 * Decompiled with CFR 0.152.
 */
package weather2.client.tile;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import weather2.WeatherBlocks;
import weather2.blockentity.WindTurbineBlockEntity;
import weather2.client.entity.model.WindTurbineModel;

public class WindTurbineEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    private final Block block = (Block)WeatherBlocks.BLOCK_WIND_TURBINE.get();
    protected final WindTurbineModel model = new WindTurbineModel(Minecraft.m_91087_().m_167973_().m_171103_(WindTurbineModel.LAYER_LOCATION));

    public static Material getTEMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> WindTurbineEntityRenderer.createTEMaterial(path));
    }

    private static Material createTEMaterial(String path) {
        return new Material(TextureAtlas.f_118259_, WindTurbineEntityRenderer.getTextureTE(path));
    }

    public static ResourceLocation getTextureTE(String path) {
        return WindTurbineEntityRenderer.getTexture(String.format("textures/blocks/te/%s.png", path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindTurbineEntityRenderer.getResLoc(path));
    }

    private static ResourceLocation getResLoc(String path) {
        return new ResourceLocation("weather2", path);
    }

    public static void renderModel(Material material, Model model, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.m_7695_(stack, buffer.m_6299_(model.m_103119_(material.m_119203_())), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public WindTurbineEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void m_6922_(T te, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        this.model.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        ModelPart root = this.model.m_142109_();
        root.f_104200_ += 8.0f;
        root.f_104201_ += 8.0f;
        root.f_104202_ += 8.0f;
        root.f_104203_ = (float)((double)root.f_104203_ + Math.toRadians(180.0));
        root.f_104204_ = (float)((double)root.f_104204_ + Math.toRadians(180.0));
        root.f_104201_ += 16.0f;
        ModelPart top = this.model.m_142109_().m_171324_("root").m_171324_("shaft");
        if (top != null) {
            float lerpAngle;
            float renderAngle = lerpAngle = (float)Mth.m_14139_((double)partialTicks, (double)((WindTurbineBlockEntity)((Object)te)).smoothAnglePrev, (double)((WindTurbineBlockEntity)((Object)te)).smoothAngle);
            top.f_104204_ = (float)Math.toRadians(renderAngle);
        }
        WindTurbineEntityRenderer.renderModel(WindTurbineEntityRenderer.getTEMaterial("wind_turbine"), (Model)this.model, stack, buffer, combinedLightIn, combinedOverlayIn);
    }
}

