/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import extendedrenderer.particle.entity.ParticleTexFX;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import weather2.ClientTickHandler;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.wind.WindManager;

public class ParticleTexExtraRender
extends ParticleTexFX {
    private int severityOfRainRate = 2;
    private int extraParticlesBaseAmount = 5;
    public boolean noExtraParticles = false;
    private float extraRandomSecondaryYawRotation = 360.0f;

    public ParticleTexExtraRender(ClientLevel worldIn, double posXIn, double posYIn, double posZIn, double mX, double mY, double mZ, TextureAtlasSprite par8Item) {
        super(worldIn, posXIn, posYIn, posZIn, mX, mY, mZ, par8Item);
    }

    public int getSeverityOfRainRate() {
        return this.severityOfRainRate;
    }

    public void setSeverityOfRainRate(int severityOfRainRate) {
        this.severityOfRainRate = severityOfRainRate;
    }

    public int getExtraParticlesBaseAmount() {
        return this.extraParticlesBaseAmount;
    }

    public void setExtraParticlesBaseAmount(int extraParticlesBaseAmount) {
        this.extraParticlesBaseAmount = extraParticlesBaseAmount;
    }

    @Override
    public void tickExtraRotations() {
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        if (this.isSlantParticleToWind()) {
            double speed = this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_;
            this.rotationYaw = -((float)Math.toDegrees(Math.atan2(this.f_107217_, this.f_107215_))) - 90.0f;
            this.rotationPitch = Math.min(45.0f, (float)(speed * 120.0));
            this.rotationPitch += (float)(this.getEntityId() % 10 - 5);
        }
        windMan.applyWindForceNew(this, 0.5f, 0.5f);
    }

    @Override
    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternionf quaternion;
        Vec3 Vector3d = renderInfo.m_90583_();
        if (this.facePlayer || this.rotationPitch == 0.0f && this.rotationYaw == 0.0f) {
            quaternion = renderInfo.m_253121_();
        } else {
            quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
            quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(this.rotationYaw));
            quaternion.mul((Quaternionfc)Axis.f_252529_.m_252977_(this.rotationPitch));
            if (this.extraRandomSecondaryYawRotation > 0.0f) {
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)this.getEntityId() % this.extraRandomSecondaryYawRotation));
            }
        }
        float posX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - Vector3d.m_7096_());
        float posY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - Vector3d.m_7098_());
        float posZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - Vector3d.m_7094_());
        float f = this.m_5970_();
        float f1 = this.m_5952_();
        float f2 = this.m_5951_();
        float f3 = this.m_5950_();
        float fixY = 0.0f;
        float part = 5.3333335f;
        float offset = 0.0f;
        float posBottom = (float)(this.f_107213_ - 10.0);
        float height = this.f_107208_.m_5452_(Heightmap.Types.MOTION_BLOCKING, CoroUtilBlock.blockPos((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_)).m_123342_();
        if (posBottom < height) {
            float diff;
            offset = diff = height - posBottom;
            fixY = 0.0f;
            if (offset > part) {
                offset = part;
            }
        }
        int renderAmount = 0;
        renderAmount = this.noExtraParticles ? 1 : Math.min(1 + this.extraParticlesBaseAmount, CoroUtilParticle.maxRainDrops);
        try {
            for (int ii = 0; ii < renderAmount; ++ii) {
                int height2;
                double xx = 0.0;
                double zz = 0.0;
                double yy = 0.0;
                if (ii != 0) {
                    xx = CoroUtilParticle.rainPositions[ii].f_82479_;
                    zz = CoroUtilParticle.rainPositions[ii].f_82481_;
                    yy = CoroUtilParticle.rainPositions[ii].f_82480_;
                }
                if (this.isDontRenderUnderTopmostBlock() && this.f_107213_ + yy < (double)(height2 = this.f_107208_.m_5452_(Heightmap.Types.MOTION_BLOCKING, CoroUtilBlock.blockPos((double)(this.f_107212_ + xx), (double)this.f_107213_, (double)(this.f_107214_ + zz))).m_123342_())) continue;
                int i = this.m_6355_(partialTicks);
                if (i > 0) {
                    this.setLastNonZeroBrightness(i);
                } else {
                    i = this.getLastNonZeroBrightness();
                }
                Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
                float scale = this.m_5902_(partialTicks);
                for (int v = 0; v < 4; ++v) {
                    Vector3f vector3f = avector3f[v];
                    vector3f.rotate((Quaternionfc)quaternion);
                    vector3f.mul(scale);
                    vector3f.add(posX, posY, posZ);
                }
                buffer.m_5483_(xx + (double)avector3f[0].x(), yy + (double)avector3f[0].y(), zz + (double)avector3f[0].z()).m_7421_(f1, f3).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(i).m_5752_();
                buffer.m_5483_(xx + (double)avector3f[1].x(), yy + (double)avector3f[1].y(), zz + (double)avector3f[1].z()).m_7421_(f1, f2).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(i).m_5752_();
                buffer.m_5483_(xx + (double)avector3f[2].x(), yy + (double)avector3f[2].y(), zz + (double)avector3f[2].z()).m_7421_(f, f2).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(i).m_5752_();
                buffer.m_5483_(xx + (double)avector3f[3].x(), yy + (double)avector3f[3].y(), zz + (double)avector3f[3].z()).m_7421_(f, f3).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(i).m_5752_();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

