/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileDungeonController;
import wayoftime.bloodmagic.common.tile.TileDungeonSeal;
import wayoftime.bloodmagic.structures.DungeonRoom;
import wayoftime.bloodmagic.structures.DungeonRoomRegistry;
import wayoftime.bloodmagic.structures.DungeonSynthesizer;

public class TileSpecialRoomDungeonSeal
extends TileDungeonSeal {
    ResourceLocation chosenRoom = BloodMagic.rl("empty");
    BlockPos roomLocation = BlockPos.f_121853_;
    Rotation rotation = Rotation.NONE;

    public TileSpecialRoomDungeonSeal(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileSpecialRoomDungeonSeal(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.SPECIAL_DUNGEON_SEAL_TYPE.get(), pos, state);
    }

    public void acceptSpecificDoorInformation(ServerLevel world, BlockPos controllerPos, ResourceLocation specialRoomType, Direction doorFacing, BlockPos activatedDoorPos, String activatedDoorType, int roomDepth, int highestBranchRoomDepth, DungeonRoom room, Rotation rotation, BlockPos roomLocation) {
        this.chosenRoom = room.key;
        this.roomLocation = roomLocation;
        this.rotation = rotation;
        ArrayList<ResourceLocation> roomPools = new ArrayList<ResourceLocation>();
        roomPools.add(specialRoomType);
        this.acceptDoorInformation(controllerPos, activatedDoorPos, doorFacing, activatedDoorType, roomDepth, highestBranchRoomDepth, roomPools);
    }

    @Override
    public int requestRoomFromController(Player player, ItemStack heldStack) {
        BlockEntity tile;
        if (DungeonSynthesizer.displayDetailedInformation) {
            System.out.println("Potential rooms: " + this.potentialRoomTypes);
        }
        if (!this.f_58857_.f_46443_ && !this.potentialRoomTypes.isEmpty() && (tile = this.f_58857_.m_7702_(this.controllerPos)) instanceof TileDungeonController) {
            TileDungeonController tileController = (TileDungeonController)tile;
            DungeonRoom room = DungeonRoomRegistry.getDungeonRoom(this.chosenRoom);
            if (room == null) {
                System.out.println("The stored room is null!");
                return -1;
            }
            int state = tileController.handleRequestForPredesignatedRoomPlacement(player, heldStack, this.doorPos, this.doorDirection, this.doorType, this.activatedRoomDepth, this.highestBranchRoomDepth, this.potentialRoomTypes, room, this.rotation, this.roomLocation);
            if (state == -1) {
                return -1;
            }
        }
        return 3;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        CompoundTag masterTag = tag.m_128469_("room_location");
        this.roomLocation = new BlockPos(masterTag.m_128451_("xCoord"), masterTag.m_128451_("yCoord"), masterTag.m_128451_("zCoord"));
        this.chosenRoom = new ResourceLocation(tag.m_128461_("room_name"));
        this.rotation = Rotation.values()[Math.max(0, Math.min(3, tag.m_128451_("rotation")))];
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        CompoundTag roomTag = new CompoundTag();
        roomTag.m_128405_("xCoord", this.roomLocation.m_123341_());
        roomTag.m_128405_("yCoord", this.roomLocation.m_123342_());
        roomTag.m_128405_("zCoord", this.roomLocation.m_123343_());
        tag.m_128365_("room_location", (Tag)roomTag);
        tag.m_128359_("room_name", this.chosenRoom.toString());
        tag.m_128405_("rotation", this.rotation.ordinal());
        return tag;
    }
}

