/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import com.google.common.math.DoubleMath;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.common.CritRecord;
import net.mehvahdjukaar.dummmmmmy.common.DummyMobType;
import net.mehvahdjukaar.dummmmmmy.configs.CommonConfigs;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundDamageNumberMessage;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundSyncEquipMessage;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundUpdateAnimationMessage;
import net.mehvahdjukaar.dummmmmmy.network.NetworkHandler;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetDummyEntity
extends Mob {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(TargetDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastTickActuallyDamaged;
    private float totalDamageTakenInCombat;
    private final List<CritRecord> critRecordsThisTick = new ArrayList<CritRecord>();
    private DummyMobType mobType = DummyMobType.UNDEFINED;
    private int damageNumberPos = 0;
    private final NonNullList<ItemStack> lastArmorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final Map<ServerPlayer, Integer> currentlyAttacking = new HashMap<ServerPlayer, Integer>();
    private DamageSource currentDamageSource = null;
    private boolean unbreakable = false;
    private float prevAnimationPosition = 0.0f;
    private float animationPosition;
    private float shakeAmount = 0.0f;
    private float prevShakeAmount = 0.0f;

    public TargetDummyEntity(EntityType<TargetDummyEntity> type, Level world) {
        super(type, world);
    }

    public TargetDummyEntity(Level world) {
        this(Dummmmmmy.TARGET_DUMMY.get(), world);
        this.f_21364_ = 0;
        Arrays.fill(this.f_21348_, 1.1f);
    }

    public float getShake(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevShakeAmount, (float)this.shakeAmount);
    }

    public float getAnimationPosition(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevAnimationPosition, (float)this.animationPosition);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket((Entity)this);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Type", this.mobType.ordinal());
        tag.m_128405_("NumberPos", this.damageNumberPos);
        tag.m_128379_("Sheared", this.isSheared());
        if (this.unbreakable) {
            tag.m_128379_("Unbreakable", true);
        }
        this.applyEquipmentModifiers();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.mobType = DummyMobType.values()[tag.m_128451_("Type")];
        this.damageNumberPos = tag.m_128451_("NumberPos");
        this.setSheared(tag.m_128471_("Sheared"));
        if (tag.m_128441_("unbreakable")) {
            this.unbreakable = tag.m_128471_("unbreakable");
        }
    }

    public void m_5618_(float pOffset) {
        float r;
        this.f_19859_ = r = this.m_146908_();
        this.f_20884_ = this.f_20883_ = r;
    }

    public void m_5616_(float pRotation) {
        float r;
        this.f_19859_ = r = this.m_146908_();
        this.f_20886_ = this.f_20885_ = r;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        boolean inventoryChanged = false;
        if (!player.m_5833_() && player.m_150110_().f_35938_) {
            ItemStack itemstack = player.m_21120_(hand);
            EquipmentSlot equipmentSlot = TargetDummyEntity.m_147233_((ItemStack)itemstack);
            Item item = itemstack.m_41720_();
            if (item instanceof BannerItem || DummyMobType.get(itemstack) != DummyMobType.UNDEFINED || ForgeHelper.canEquipItem((LivingEntity)this, (ItemStack)itemstack, (EquipmentSlot)EquipmentSlot.HEAD)) {
                equipmentSlot = EquipmentSlot.HEAD;
            }
            Level level = player.m_9236_();
            if (itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                equipmentSlot = this.getClickedSlot(vec);
                if (this.m_21033_(equipmentSlot)) {
                    if (level.f_46443_) {
                        return InteractionResult.CONSUME;
                    }
                    this.unEquipArmor(player, equipmentSlot, hand);
                    inventoryChanged = true;
                }
            } else if (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR) {
                if (level.f_46443_) {
                    return InteractionResult.CONSUME;
                }
                this.equipArmor(player, equipmentSlot, itemstack, hand);
                inventoryChanged = true;
            } else if (item instanceof ShearsItem && !this.isSheared()) {
                level.m_6269_(player, (Entity)this, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (level.f_46443_) {
                    return InteractionResult.CONSUME;
                }
                this.setSheared(true);
                return InteractionResult.SUCCESS;
            }
            if (inventoryChanged) {
                this.setLastArmorItem(equipmentSlot, itemstack);
                if (!level.f_46443_) {
                    NetworkHandler.CHANNEL.sentToAllClientPlayersTrackingEntity((Entity)this, (Message)new ClientBoundSyncEquipMessage(this.m_19879_(), equipmentSlot.m_20749_(), this.m_6844_(equipmentSlot)));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void unEquipArmor(Player player, EquipmentSlot slot, InteractionHand hand) {
        ItemStack itemstack = this.m_6844_(slot);
        ItemStack itemstack2 = itemstack.m_41777_();
        player.m_21008_(hand, itemstack2);
        this.m_8061_(slot, ItemStack.f_41583_);
        this.m_21204_().m_22161_(itemstack2.m_41638_(slot));
        if (slot == EquipmentSlot.HEAD) {
            this.mobType = DummyMobType.UNDEFINED;
        }
    }

    private void equipArmor(Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack currentItem = this.m_6844_(slot);
        ItemStack newItem = stack.m_41777_();
        newItem.m_41764_(1);
        player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)stack.m_41777_(), (Player)player, (ItemStack)currentItem, (boolean)player.m_7500_()));
        this.m_8061_(slot, newItem);
        this.m_21204_().m_22178_(newItem.m_41638_(slot));
        if (slot == EquipmentSlot.HEAD) {
            this.mobType = DummyMobType.get(newItem);
        }
    }

    public boolean canScare() {
        return this.mobType == DummyMobType.SCARECROW;
    }

    public boolean canAttract() {
        return this.mobType == DummyMobType.DECOY;
    }

    private EquipmentSlot getClickedSlot(Vec3 vec3) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        double d0 = vec3.f_82480_;
        EquipmentSlot slot = EquipmentSlot.FEET;
        if (d0 >= 0.1 && d0 < 0.55 && this.m_21033_(slot)) {
            equipmentSlot = EquipmentSlot.FEET;
        } else if (d0 >= 0.9 && d0 < 1.6 && this.m_21033_(EquipmentSlot.CHEST)) {
            equipmentSlot = EquipmentSlot.CHEST;
        } else if (d0 >= 0.4 && d0 < 1.2000000000000002 && this.m_21033_(EquipmentSlot.LEGS)) {
            equipmentSlot = EquipmentSlot.LEGS;
        } else if (d0 >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            equipmentSlot = EquipmentSlot.HEAD;
        }
        return equipmentSlot;
    }

    private void setLastArmorItem(EquipmentSlot type, ItemStack stack) {
        this.lastArmorItems.set(type.m_20749_(), (Object)stack);
    }

    public void applyEquipmentModifiers() {
        if (!this.m_9236_().f_46443_) {
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = (ItemStack)this.lastArmorItems.get(equipmentSlot.m_20749_());
                ItemStack slot = this.m_6844_(equipmentSlot);
                if (ItemStack.m_41728_((ItemStack)slot, (ItemStack)itemstack)) continue;
                if (!slot.equals(itemstack)) {
                    ForgeHelper.onEquipmentChange((LivingEntity)this, (EquipmentSlot)equipmentSlot, (ItemStack)itemstack, (ItemStack)slot);
                }
                if (!itemstack.m_41619_()) {
                    this.m_21204_().m_22161_(itemstack.m_41638_(equipmentSlot));
                }
                if (slot.m_41619_()) continue;
                this.m_21204_().m_22178_(slot.m_41638_(equipmentSlot));
            }
        }
    }

    public void m_5907_() {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armor;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armor = this.m_6844_(slot)).m_41619_()) continue;
            this.m_5552_(armor, 1.0f);
        }
        this.m_5552_(this.m_142340_(), 1.0f);
    }

    public void dismantle(boolean drops) {
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.m_6084_()) {
            if (drops) {
                this.m_5907_();
            }
            level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5592_(), this.m_5720_(), 1.0f, 1.0f);
            ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    @NotNull
    public ItemStack m_142340_() {
        ItemStack itemStack = new ItemStack((ItemLike)Dummmmmmy.DUMMY_ITEM.get());
        if (this.m_8077_()) {
            itemStack.m_41714_(this.m_7770_());
        }
        return itemStack;
    }

    public void m_6074_() {
        this.dismantle(true);
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source == this.m_269291_().m_269063_() || source == this.m_269291_().m_269318_();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        CritRecord critRecord;
        if (source == this.m_269291_().m_269341_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        if (source.m_7640_() instanceof WitherBoss || source.m_7639_() instanceof WitherBoss) {
            this.dismantle(true);
            return true;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                this.currentlyAttacking.put(sp, CommonConfigs.MAX_COMBAT_INTERVAL.get());
            }
            if (player.m_6144_() && player.m_21205_().m_41619_() && !this.unbreakable) {
                this.dismantle(!player.m_7500_());
                return false;
            }
        }
        if (this.m_9236_().f_46443_) {
            return false;
        }
        DamageSource old = this.currentDamageSource;
        this.currentDamageSource = source;
        if (!this.critRecordsThisTick.isEmpty() && (critRecord = this.critRecordsThisTick.get(this.critRecordsThisTick.size() - 1)).canCompleteWith(source)) {
            critRecord.addSource(source);
        }
        boolean result = super.m_6469_(source, damage);
        this.currentDamageSource = old;
        this.f_20916_ = 0;
        return result;
    }

    public void m_21153_(float newHealth) {
        if (newHealth == this.m_21233_()) {
            super.m_21153_(newHealth);
        } else {
            Level level = this.m_9236_();
            if (level.f_46443_) {
                return;
            }
            float damage = this.m_21223_() - newHealth;
            if (damage > 0.0f) {
                DamageSource actualSource = null;
                if (PlatHelper.getPlatform().isForge()) {
                    CombatEntry currentCombatEntry = this.getLastEntry();
                    if (currentCombatEntry != null && this.m_21231_().f_19278_ == this.f_19797_ && DoubleMath.fuzzyEquals((double)damage, (double)currentCombatEntry.f_19252_(), (double)1.0E-6)) {
                        actualSource = currentCombatEntry.f_19250_();
                    }
                } else {
                    actualSource = this.currentDamageSource;
                }
                if (actualSource != null) {
                    this.showDamageAndAnimationsToClients(damage, actualSource);
                    this.updateTargetBlock(damage);
                }
                this.lastTickActuallyDamaged = this.f_19797_;
            }
        }
    }

    @Nullable
    public CombatEntry getLastEntry() {
        CombatTracker tracker = this.m_21231_();
        if (tracker.f_19276_.isEmpty()) {
            return null;
        }
        return (CombatEntry)tracker.f_19276_.get(tracker.f_19276_.size() - 1);
    }

    private void showDamageAndAnimationsToClients(float damage, @Nullable DamageSource source) {
        if (this.lastTickActuallyDamaged != this.f_19797_) {
            this.animationPosition = 0.0f;
        }
        this.animationPosition = Math.min(this.animationPosition + damage, 60.0f);
        NetworkHandler.CHANNEL.sentToAllClientPlayersTrackingEntity((Entity)this, (Message)new ClientBoundUpdateAnimationMessage(this.m_19879_(), this.animationPosition));
        if (source != null && !this.currentlyAttacking.isEmpty()) {
            CritRecord critRec = null;
            for (int j = this.critRecordsThisTick.size() - 1; j >= 0; --j) {
                CritRecord c = this.critRecordsThisTick.get(j);
                if (!c.matches(source)) continue;
                critRec = c;
                break;
            }
            for (ServerPlayer p : this.currentlyAttacking.keySet()) {
                NetworkHandler.CHANNEL.sendToClientPlayer(p, (Message)new ClientBoundDamageNumberMessage(this.m_19879_(), damage, source, critRec));
            }
            if (critRec != null) {
                this.critRecordsThisTick.remove(critRec);
            }
        }
        this.totalDamageTakenInCombat += damage;
    }

    private void updateTargetBlock(float damage) {
        Level level;
        BlockPos pos = this.m_20097_();
        BlockState state = this.m_20075_();
        if (state.m_60734_() instanceof TargetBlock && !(level = this.m_9236_()).m_183326_().m_183582_(pos, (Object)state.m_60734_())) {
            int power = (int)Mth.m_14036_((float)(damage / this.m_21223_() * 15.0f), (float)1.0f, (float)15.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(power)), 3);
            level.m_186460_(pos, state.m_60734_(), 20);
        }
    }

    protected void m_8022_() {
    }

    protected Vec3 m_7939_() {
        return new Vec3(0.0, (double)(this.m_20192_() - 1.0f), 0.0);
    }

    public void m_8107_() {
    }

    public void m_8119_() {
        float trueDamage;
        this.critRecordsThisTick.clear();
        Level level = this.m_9236_();
        if (this.lastTickActuallyDamaged + 1 == this.f_19797_ && !level.f_46443_ && (trueDamage = this.m_21233_() - this.m_21223_()) > 0.0f) {
            this.m_5634_(trueDamage);
            this.showDamageAndAnimationsToClients(trueDamage, null);
        }
        BlockPos onPos = this.m_20097_();
        if (!level.f_46443_ && level.m_46467_() % 20L == 0L && level.m_46859_(onPos)) {
            this.dismantle(true);
            return;
        }
        this.m_20242_(true);
        BlockState onState = level.m_8055_(onPos);
        onState.m_60734_().m_141947_(level, onPos, onState, (Entity)this);
        super.m_8119_();
        if (level.f_46443_) {
            this.f_20916_ = 0;
            this.prevShakeAmount = this.shakeAmount;
            this.prevAnimationPosition = this.animationPosition;
            if (this.animationPosition > 0.0f) {
                this.shakeAmount += 1.0f;
                this.animationPosition -= 0.8f;
                if (this.animationPosition <= 0.0f) {
                    this.shakeAmount = 0.0f;
                    this.animationPosition = 0.0f;
                }
            }
        } else {
            this.displayCombatMessages();
        }
    }

    private void displayCombatMessages() {
        CombatTracker tracker = this.m_21231_();
        tracker.m_19296_();
        if (tracker.f_19281_ && this.totalDamageTakenInCombat > 0.0f) {
            float combatDuration = tracker.m_19295_();
            CommonConfigs.DpsMode dpsMode = CommonConfigs.DYNAMIC_DPS.get();
            if (dpsMode != CommonConfigs.DpsMode.OFF && combatDuration > 0.0f) {
                boolean dynamic = dpsMode == CommonConfigs.DpsMode.DYNAMIC;
                float seconds = combatDuration / 20.0f + 1.0f;
                float dps = this.totalDamageTakenInCombat / seconds;
                ArrayList<ServerPlayer> outOfCombat = new ArrayList<ServerPlayer>();
                for (Map.Entry<ServerPlayer, Integer> e : this.currentlyAttacking.entrySet()) {
                    boolean showMessage;
                    ServerPlayer p = e.getKey();
                    int timer = e.getValue() - 1;
                    this.currentlyAttacking.replace(p, timer);
                    boolean bl = showMessage = dynamic && this.lastTickActuallyDamaged + 1 == this.f_19797_;
                    if (timer <= 0) {
                        outOfCombat.add(p);
                        if (!dynamic) {
                            showMessage = true;
                        }
                    }
                    if (!showMessage || !(p.m_20270_((Entity)this) < 64.0f)) continue;
                    p.m_5661_((Component)Component.m_237110_((String)"message.dummmmmmy.dps", (Object[])new Object[]{this.m_5446_(), new DecimalFormat("#.##").format(dps)}), true);
                }
                outOfCombat.forEach(this.currentlyAttacking::remove);
            }
        } else {
            this.currentlyAttacking.clear();
            this.totalDamageTakenInCombat = 0.0f;
        }
    }

    public void m_20256_(Vec3 motionIn) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    protected boolean m_6107_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_5834_() {
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_11683_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    @NotNull
    public MobType m_6336_() {
        return this.mobType.getType();
    }

    public static AttributeSupplier.Builder makeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22280_, 0.0);
    }

    public void updateAnimation(float shake) {
        this.animationPosition = shake;
    }

    public void moist(Entity attacker, float critModifier) {
        this.critRecordsThisTick.add(new CritRecord(attacker, critModifier));
    }

    public int getNextNumberPos() {
        return this.damageNumberPos++;
    }
}

