/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.compat.jei.purifier;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.deepresonance.compat.jei.DeepResonanceJeiPlugin;
import mcjty.deepresonance.compat.jei.purifier.PurifierRecipeWrapper;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.PurifierConfig;
import mcjty.deepresonance.modules.machines.util.config.SmelterConfig;
import mcjty.lib.varia.ComponentFactory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PurifierRecipeCategory
implements IRecipeCategory<PurifierRecipeWrapper> {
    private final IGuiHelper guiHelper;
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable arrow;
    private final IDrawable icon;
    public static final ResourceLocation ID = new ResourceLocation("deepresonance", "purifier");

    public PurifierRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MachinesModule.PURIFIER_BLOCK.get()));
        this.arrow = guiHelper.createDrawable(new ResourceLocation("deepresonance", "textures/gui/guielements.png"), 144, 0, 16, 16);
        this.background = guiHelper.createBlankDrawable(120, 80);
    }

    @Nonnull
    public RecipeType<PurifierRecipeWrapper> getRecipeType() {
        return DeepResonanceJeiPlugin.PURIFIER_RECIPE;
    }

    @Nonnull
    public Component getTitle() {
        return ComponentFactory.literal((String)"Deep Resonance Purifier");
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(PurifierRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.slot.draw(graphics, 20, 10);
        this.arrow.draw(graphics, 50, 10);
        this.slot.draw(graphics, 80, 10);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PurifierRecipeWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 20, 10).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, List.of(new ItemStack((ItemLike)CoreModule.FILTER_MATERIAL_ITEM.get())));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 10).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, List.of(new ItemStack((ItemLike)CoreModule.SPENT_FILTER_ITEM.get())));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 15, 35).setFluidRenderer((long)((Integer)PurifierConfig.RCL_PER_PURIFY.get()).intValue(), true, 30, 30).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(new FluidStack((Fluid)CoreModule.LIQUID_CRYSTAL.get(), ((Integer)SmelterConfig.RCL_PER_ORE.get()).intValue())))).addTooltipCallback((view, tooltip) -> tooltip.add(ComponentFactory.literal((String)"Purity: X").m_130940_(ChatFormatting.GREEN)));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 75, 35).setFluidRenderer((long)((Integer)PurifierConfig.RCL_PER_PURIFY.get()).intValue(), true, 30, 30).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(new FluidStack((Fluid)CoreModule.LIQUID_CRYSTAL.get(), ((Integer)SmelterConfig.RCL_PER_ORE.get()).intValue())))).addTooltipCallback((view, tooltip) -> tooltip.add(ComponentFactory.literal((String)"Purity: X + 25%").m_130940_(ChatFormatting.GREEN)));
    }
}

