/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.magnetsystem;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.MagnetBlockEntity;
import org.violetmoon.quark.addons.oddities.magnetsystem.DefaultMoveActions;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.api.IMagnetMoveAction;
import org.violetmoon.quark.api.IMagnetTracker;
import org.violetmoon.quark.api.QuarkCapabilities;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.util.RegistryUtil;
import org.violetmoon.zeta.util.handler.RecipeCrawlHandler;

public class MagnetSystem {
    private static final HashSet<Block> magnetizableBlocks = new HashSet();
    private static final HashMap<Block, IMagnetMoveAction> BLOCK_MOVE_ACTIONS = new HashMap();

    public static IMagnetMoveAction getMoveAction(Block block) {
        return BLOCK_MOVE_ACTIONS.get(block);
    }

    @Nullable
    public static IMagnetTracker getTracker(Level level) {
        return (IMagnetTracker)Quark.ZETA.capabilityManager.getCapability(QuarkCapabilities.MAGNET_TRACKER_CAPABILITY, level);
    }

    public static void tick(boolean start, Level level) {
        IMagnetTracker tracker = MagnetSystem.getTracker(level);
        if (tracker == null) {
            return;
        }
        if (!start) {
            for (BlockPos pos : tracker.getTrackedPositions()) {
                tracker.actOnForces(pos);
            }
        }
        tracker.clear();
    }

    public static void onRecipeReset() {
        magnetizableBlocks.clear();
    }

    public static void onDigest() {
        RecipeCrawlHandler.recursivelyFindCraftedItemsFromStrings(MagnetsModule.magneticDerivationList, Collections.emptyList(), Collections.emptyList(), i -> {
            if (i instanceof BlockItem) {
                BlockItem bi = (BlockItem)i;
                magnetizableBlocks.add(bi.m_40614_());
            }
        });
        List magneticWhitelist = RegistryUtil.massRegistryGet(MagnetsModule.magneticWhitelist, (Registry)BuiltInRegistries.f_256975_);
        List magneticBlacklist = RegistryUtil.massRegistryGet(MagnetsModule.magneticBlacklist, (Registry)BuiltInRegistries.f_256975_);
        magnetizableBlocks.addAll(magneticWhitelist);
        magneticBlacklist.forEach(magnetizableBlocks::remove);
    }

    public static void applyForce(Level world, BlockPos pos, int magnitude, boolean pushing, Direction dir, int distance, BlockPos origin) {
        IMagnetTracker tracker = MagnetSystem.getTracker(world);
        if (tracker != null) {
            tracker.applyForce(pos, magnitude, pushing, dir, distance, origin);
        }
    }

    public static PushReaction getPushAction(MagnetBlockEntity magnet, BlockPos pos, BlockState state, Direction moveDir) {
        Level world = magnet.m_58904_();
        if (world != null && MagnetSystem.isBlockMagnetic(state)) {
            BlockPos targetLocation = pos.m_121945_(moveDir);
            BlockState stateAtTarget = world.m_8055_(targetLocation);
            if (stateAtTarget.m_60795_()) {
                return PushReaction.IGNORE;
            }
            if (stateAtTarget.m_60811_() == PushReaction.DESTROY) {
                return PushReaction.DESTROY;
            }
        }
        return PushReaction.BLOCK;
    }

    public static boolean isBlockMagnetic(BlockState state) {
        Block block = state.m_60734_();
        if ((block == Blocks.f_50039_ || block == Blocks.f_50032_) && ((Boolean)state.m_61143_((Property)PistonBaseBlock.f_60153_)).booleanValue()) {
            return false;
        }
        return block != MagnetsModule.magnet && (magnetizableBlocks.contains(block) || BLOCK_MOVE_ACTIONS.containsKey(block) || block instanceof IMagnetMoveAction);
    }

    static {
        DefaultMoveActions.addActions(BLOCK_MOVE_ACTIONS);
    }
}

