/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.function.Supplier;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTypeTools;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketVariableToServer {
    private final BlockPos pos;
    private final int varIndex;
    private final CompoundTag tagCompound;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.varIndex);
        buf.m_130079_(this.tagCompound);
    }

    public PacketVariableToServer(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.varIndex = buf.readInt();
        this.tagCompound = buf.m_130260_();
    }

    public PacketVariableToServer(BlockPos pos, int varIndex, CompoundTag tagCompound) {
        this.pos = pos;
        this.varIndex = varIndex;
        this.tagCompound = tagCompound;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ProcessorTileEntity processor;
            Parameter[] variables;
            ServerPlayer playerEntity = ctx.getSender();
            BlockEntity te = playerEntity.m_20193_().m_7702_(this.pos);
            if (te instanceof ProcessorTileEntity && this.varIndex < (variables = (processor = (ProcessorTileEntity)te).getVariableArray()).length) {
                Parameter parameter = variables[this.varIndex];
                ParameterType type = parameter.getParameterType();
                ParameterValue value = ParameterTypeTools.readFromNBT(this.tagCompound, type);
                variables[this.varIndex] = Parameter.builder().type(type).value(value).build();
                processor.m_6596_();
            }
        });
        ctx.setPacketHandled(true);
    }
}

