/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketLogReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketGetLog
extends PacketGetListFromServer {
    private final boolean fromTablet;

    public PacketGetLog(FriendlyByteBuf buf) {
        super(buf);
        this.fromTablet = buf.readBoolean();
    }

    public PacketGetLog(ResourceKey<Level> dimension, BlockPos pos, boolean fromTablet) {
        super(dimension, pos, ProcessorTileEntity.CMD_GETLOG.name(), TypedMap.EMPTY);
        this.fromTablet = fromTablet;
    }

    public PacketGetLog(ResourceKey<Level> dimension, BlockPos pos, String cmd, @Nonnull TypedMap params) {
        super(dimension, pos, cmd, params);
        this.fromTablet = false;
    }

    public PacketGetLog(BlockPos pos, String cmd, @Nonnull TypedMap params) {
        super(pos, cmd, params);
        this.fromTablet = false;
    }

    public PacketGetLog(BlockPos pos, String cmd) {
        super(pos, cmd);
        this.fromTablet = false;
    }

    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.fromTablet);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity te;
            ServerLevel world = LevelTools.getLevel((Level)ctx.getSender().m_20193_(), (ResourceKey)this.dimension);
            if (world.m_46805_(this.pos) && (te = world.m_7702_(this.pos)) instanceof GenericTileEntity) {
                List list = ((GenericTileEntity)te).executeServerCommandList(ProcessorTileEntity.CMD_GETLOG.name(), (Player)ctx.getSender(), this.params, String.class);
                if (this.fromTablet) {
                    RFToolsCtrlMessages.INSTANCE.sendTo((Object)new PacketLogReady(null, ProcessorTileEntity.CMD_GETLOG.name(), list), ctx.getSender().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                } else {
                    RFToolsCtrlMessages.INSTANCE.sendTo((Object)new PacketLogReady(this.pos, ProcessorTileEntity.CMD_GETLOG.name(), list), ctx.getSender().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

