/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidType;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.PlaceableFluid;
import thelm.jaopca.api.fluids.PlaceableFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.fluids.FluidFormType;

public class JAOPCAFluid
extends PlaceableFluid
implements IMaterialFormFluid {
    private final IForm form;
    private final IMaterial material;
    protected final IFluidFormSettings settings;
    protected OptionalInt tickRate = OptionalInt.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected OptionalInt levelDecreasePerBlock = OptionalInt.empty();

    public JAOPCAFluid(IForm form, IMaterial material, IFluidFormSettings settings) {
        super(settings.getMaxLevelFunction().applyAsInt(material));
        this.form = form;
        this.material = material;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public int m_6718_(LevelReader world) {
        if (!this.tickRate.isPresent()) {
            this.tickRate = OptionalInt.of(this.settings.getTickRateFunction().applyAsInt(this.material));
        }
        return this.tickRate.getAsInt();
    }

    protected float m_6752_() {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.material));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    @Override
    protected int getDropOff(LevelReader world) {
        if (!this.levelDecreasePerBlock.isPresent()) {
            this.levelDecreasePerBlock = OptionalInt.of(this.settings.getLevelDecreasePerBlockFunction().applyAsInt(this.material));
        }
        return this.levelDecreasePerBlock.getAsInt();
    }

    @Override
    public FluidState getSourceState() {
        return (FluidState)this.m_76145_().m_61124_((Property)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel));
    }

    public FluidType getFluidType() {
        return FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getFluidType();
    }

    @Override
    protected PlaceableFluidBlock getFluidBlock() {
        return (PlaceableFluidBlock)FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getMaterialFormFluidBlock().toBlock();
    }

    public Item m_6859_() {
        return FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getBucketItem();
    }
}

