/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.theurgy.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class IncubationRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object mercury;
    public final Object salt;
    public final Object sulfur;
    public final Object output;
    public final int outputCount;
    public final int time;

    public IncubationRecipeSerializer(ResourceLocation key, Object mercury, Object salt, Object sulfur, Object output, int outputCount, int time) {
        this.key = Objects.requireNonNull(key);
        this.mercury = mercury;
        this.salt = salt;
        this.sulfur = sulfur;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient mercuryIng = MiscHelper.INSTANCE.getIngredient(this.mercury);
        if (mercuryIng == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.mercury);
        }
        Ingredient saltIng = MiscHelper.INSTANCE.getIngredient(this.salt);
        if (saltIng == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.salt);
        }
        Ingredient sulfurIng = MiscHelper.INSTANCE.getIngredient(this.sulfur);
        if (sulfurIng == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.sulfur);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "theurgy:incubation");
        json.add("mercury", mercuryIng.m_43942_());
        json.add("salt", saltIng.m_43942_());
        json.add("sulfur", sulfurIng.m_43942_());
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        json.addProperty("incubation_time", (Number)this.time);
        return json;
    }
}

