/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.railcraft;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.railcraft.RailcraftHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"railcraft"})
public class RailcraftModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("copper", "gold", "iron", "lead", "nickel", "silver"));

    @Override
    public String getName() {
        return "railcraft";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        builder.put((Object)1, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.INGOT_LEGACY);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        RailcraftHelper helper = RailcraftHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        for (IMaterial material : moduleData.getMaterials()) {
            if (BLACKLIST.contains(material.getName())) continue;
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            ResourceLocation extraDustLocation = miscHelper.getTagLocation("dusts", material.getExtra(1).getName());
            if (material.hasExtra(1)) {
                helper.registerCrusherRecipe(new ResourceLocation("jaopca", "railcraft.ore_to_dust." + material.getName()), oreLocation, 200, dustLocation, 2, Float.valueOf(1.0f), extraDustLocation, 1, Float.valueOf(0.1f));
            } else {
                helper.registerCrusherRecipe(new ResourceLocation("jaopca", "railcraft.ore_to_dust." + material.getName()), oreLocation, 200, dustLocation, 2, Float.valueOf(1.0f), extraDustLocation, 1, Float.valueOf(0.1f));
            }
            if (material.getType() != MaterialType.INGOT) continue;
            ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
            ResourceLocation rawStorageBlockLocation = miscHelper.getTagLocation("storage_blocks/raw", material.getName(), "_");
            helper.registerCrusherRecipe(new ResourceLocation("jaopca", "railcraft.raw_material_to_dust." + material.getName()), rawMaterialLocation, 200, dustLocation, 1, Float.valueOf(1.0f), dustLocation, 1, Float.valueOf(0.35f));
            if (!itemTags.contains(rawStorageBlockLocation)) continue;
            helper.registerCrusherRecipe(new ResourceLocation("jaopca", "railcraft.raw_storage_block_to_dust." + material.getName()), rawMaterialLocation, 200, dustLocation, 12, Float.valueOf(1.0f));
        }
    }
}

