/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.slurries;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Tables;
import com.google.common.collect.TreeBasedTable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.slurry.Slurry;
import net.minecraft.resources.ResourceLocation;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.mekanism.MekanismDataInjector;
import thelm.jaopca.compat.mekanism.MekanismHelper;
import thelm.jaopca.compat.mekanism.api.slurries.IMaterialFormSlurry;
import thelm.jaopca.compat.mekanism.api.slurries.ISlurryFormSettings;
import thelm.jaopca.compat.mekanism.api.slurries.ISlurryFormType;
import thelm.jaopca.compat.mekanism.api.slurries.ISlurryInfo;
import thelm.jaopca.compat.mekanism.custom.json.SlurryFormSettingsDeserializer;
import thelm.jaopca.compat.mekanism.slurries.SlurryFormSettings;
import thelm.jaopca.compat.mekanism.slurries.SlurryInfo;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.registries.RegistryHandler;
import thelm.jaopca.utils.MiscHelper;

public class SlurryFormType
implements ISlurryFormType {
    public static final SlurryFormType INSTANCE = new SlurryFormType();
    private static final TreeSet<IForm> FORMS = new TreeSet();
    private static final TreeBasedTable<IForm, IMaterial, java.util.function.Supplier<IMaterialFormSlurry>> SLURRIES = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, ISlurryInfo> SLURRY_INFOS = TreeBasedTable.create();
    private static boolean registered = false;

    private SlurryFormType() {
    }

    public static void init() {
        FormTypeHandler.registerFormType(INSTANCE);
    }

    @Override
    public String getName() {
        return "slurry";
    }

    @Override
    public void addForm(IForm form) {
        FORMS.add(form);
    }

    @Override
    public Set<IForm> getForms() {
        return Collections.unmodifiableNavigableSet(FORMS);
    }

    @Override
    public boolean shouldRegister(IForm form, IMaterial material) {
        ResourceLocation tagLocation = MiscHelper.INSTANCE.getTagLocation(form.getSecondaryName(), material.getName());
        return !MekanismHelper.INSTANCE.getSlurryTags().contains(tagLocation);
    }

    @Override
    public ISlurryInfo getMaterialFormInfo(IForm form, IMaterial material) {
        ISlurryInfo info = (ISlurryInfo)SLURRY_INFOS.get((Object)form, (Object)material);
        if (info == null && FORMS.contains(form) && form.getMaterials().contains(material)) {
            info = new SlurryInfo((IMaterialFormSlurry)((java.util.function.Supplier)SLURRIES.get((Object)form, (Object)material)).get());
            SLURRY_INFOS.put((Object)form, (Object)material, (Object)info);
        }
        return info;
    }

    @Override
    public ISlurryFormSettings getNewSettings() {
        return new SlurryFormSettings();
    }

    @Override
    public GsonBuilder configureGsonBuilder(GsonBuilder builder) {
        return builder;
    }

    @Override
    public ISlurryFormSettings deserializeSettings(JsonElement jsonElement, JsonDeserializationContext context) {
        return SlurryFormSettingsDeserializer.INSTANCE.deserialize(jsonElement, context);
    }

    @Override
    public void registerMaterialForms() {
        if (registered) {
            return;
        }
        registered = true;
        MiscHelper helper = MiscHelper.INSTANCE;
        for (IForm form : FORMS) {
            ISlurryFormSettings settings = (ISlurryFormSettings)form.getSettings();
            String secondaryName = form.getSecondaryName();
            for (IMaterial material : form.getMaterials()) {
                String name = form.getName() + "." + material.getName();
                ResourceLocation registryName = new ResourceLocation("jaopca", name);
                Supplier materialFormSlurry = Suppliers.memoize(() -> settings.getSlurryCreator().create(form, material, settings));
                SLURRIES.put((Object)form, (Object)material, (Object)materialFormSlurry);
                RegistryHandler.registerForgeRegistryEntry(MekanismAPI.SLURRY_REGISTRY_NAME, name, () -> SlurryFormType.lambda$registerMaterialForms$1((java.util.function.Supplier)materialFormSlurry));
                MekanismDataInjector.registerSlurryTag(helper.createResourceLocation(secondaryName), registryName);
                MekanismDataInjector.registerSlurryTag(helper.getTagLocation(secondaryName, material.getName()), registryName);
                for (String alternativeName : material.getAlternativeNames()) {
                    MekanismDataInjector.registerSlurryTag(helper.getTagLocation(secondaryName, alternativeName), registryName);
                }
            }
        }
    }

    public static Collection<IMaterialFormSlurry> getSlurries() {
        return Tables.transformValues(SLURRIES, java.util.function.Supplier::get).values();
    }

    private static /* synthetic */ Slurry lambda$registerMaterialForms$1(java.util.function.Supplier materialFormSlurry) {
        return ((IMaterialFormSlurry)materialFormSlurry.get()).toSlurry();
    }
}

