/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.finalcastle;

import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.finalcastle.FinalCastleBellTower21Component;
import twilightforest.world.components.structures.finalcastle.FinalCastleBossGazeboComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleBridgeComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleDungeonStepsComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleEntranceTowerComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleFoundation48Component;
import twilightforest.world.components.structures.finalcastle.FinalCastleLargeTowerComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleMazeTower13Component;
import twilightforest.world.components.structures.finalcastle.FinalCastleMuralComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleRoof48CrenellatedComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleStairTowerComponent;
import twilightforest.world.components.structures.finalcastle.StructureTFDecoratorCastle;

public class FinalCastleMainComponent
extends TFStructureComponentOld {
    public FinalCastleMainComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFFCMain.get(), nbt);
    }

    public FinalCastleMainComponent(int i, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFFCMain.get(), i, x, y, z);
        this.m_73519_(Direction.SOUTH);
        this.spawnListIndex = 1;
        x = x + 127 >> 8 << 8;
        z = z + 127 >> 8 << 8;
        this.f_73383_ = TFLandmark.getComponentToAddBoundingBox(x, y, z, -24, 120, -24, 48, 40, 48, Direction.SOUTH, false);
        BlockPos cc = LegacyLandmarkPlacements.getNearestCenterXZ(x >> 4, z >> 4);
        int cx = x >> 8 << 8;
        int cz = z >> 8 << 8;
        if (this.deco == null) {
            this.deco = new StructureTFDecoratorCastle();
        }
    }

    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        FinalCastleFoundation48Component foundation = new FinalCastleFoundation48Component(4, this, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_());
        list.m_142679_((StructurePiece)foundation);
        foundation.m_214092_(this, list, rand);
        FinalCastleRoof48CrenellatedComponent roof = new FinalCastleRoof48CrenellatedComponent(4, this, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_());
        list.m_142679_((StructurePiece)roof);
        roof.m_214092_(this, list, rand);
        FinalCastleBossGazeboComponent gazebo = new FinalCastleBossGazeboComponent(5, this, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_());
        list.m_142679_((StructurePiece)gazebo);
        gazebo.m_214092_(this, list, rand);
        FinalCastleStairTowerComponent tower0 = new FinalCastleStairTowerComponent(3, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_(), Direction.NORTH);
        list.m_142679_((StructurePiece)tower0);
        tower0.m_214092_(this, list, rand);
        FinalCastleLargeTowerComponent tower1 = new FinalCastleLargeTowerComponent(3, this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_(), Direction.EAST);
        list.m_142679_((StructurePiece)tower1);
        tower1.m_214092_(this, list, rand);
        FinalCastleStairTowerComponent tower2 = new FinalCastleStairTowerComponent(3, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_(), Direction.WEST);
        list.m_142679_((StructurePiece)tower2);
        tower2.m_214092_(this, list, rand);
        FinalCastleStairTowerComponent tower3 = new FinalCastleStairTowerComponent(3, this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_(), Direction.SOUTH);
        list.m_142679_((StructurePiece)tower3);
        tower3.m_214092_(this, list, rand);
        BlockPos dest = new BlockPos(this.f_73383_.m_162395_() - 4, this.f_73383_.m_162400_(), this.f_73383_.m_162398_() - 24);
        this.buildTowerMaze(list, rand, 48, 0, 24, 60, Direction.SOUTH, ((Block)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get()).m_49966_(), dest);
        dest = new BlockPos(this.f_73383_.m_162399_() + 4, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 24);
        this.buildTowerMaze(list, rand, 0, 30, 24, 60, Direction.NORTH, ((Block)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get()).m_49966_(), dest);
        FinalCastleDungeonStepsComponent steps0 = new FinalCastleDungeonStepsComponent(5, this.f_73383_.m_162395_() + 18, this.f_73383_.m_162396_() + 1, this.f_73383_.m_162398_() + 18, Direction.SOUTH);
        list.m_142679_((StructurePiece)steps0);
        steps0.m_214092_(this, list, rand);
        FinalCastleDungeonStepsComponent steps1 = steps0.buildMoreStepsTowards(list, rand, Rotation.COUNTERCLOCKWISE_90);
        FinalCastleDungeonStepsComponent steps2 = steps1.buildMoreStepsTowards(list, rand, Rotation.COUNTERCLOCKWISE_90);
        FinalCastleDungeonStepsComponent steps3 = steps2.buildMoreStepsTowards(list, rand, Rotation.COUNTERCLOCKWISE_90);
        steps3.buildLevelUnder(list, rand, 1);
        BlockPos mc = this.offsetTowerCCoords(48, 23, 25, 1, Direction.SOUTH);
        FinalCastleMuralComponent mural0 = new FinalCastleMuralComponent(7, mc.m_123341_(), mc.m_123342_(), mc.m_123343_(), 35, 30, Direction.SOUTH);
        list.m_142679_((StructurePiece)mural0);
        mural0.m_214092_(this, list, rand);
        BlockPos mc1 = this.offsetTowerCCoords(48, 33, 24, -1, Direction.SOUTH);
        FinalCastleMuralComponent mural1 = new FinalCastleMuralComponent(7, mc1.m_123341_(), mc1.m_123342_(), mc.m_123343_(), 19, 12, Direction.NORTH);
        list.m_142679_((StructurePiece)mural1);
        mural1.m_214092_(this, list, rand);
    }

    private void buildTowerMaze(StructurePieceAccessor list, RandomSource rand, int x, int y, int z, int howFar, Direction direction, BlockState type, BlockPos dest) {
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            boolean complete = false;
            for (int iterations = 0; !complete && iterations < 15; ++iterations) {
                LinkedList before = new LinkedList(start.f_192778_);
                BlockPos tc = this.offsetTowerCCoords(x, y, z, howFar, direction);
                FinalCastleMazeTower13Component sTower = new FinalCastleMazeTower13Component((StructurePieceType)TFStructurePieceTypes.TFFCSiTo.get(), rand, 3, tc.m_123341_(), tc.m_123342_(), tc.m_123343_(), type, direction);
                BlockPos bc = this.offsetTowerCCoords(x, y, z, 1, direction);
                FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.m_73548_() + 1, bc.m_123341_(), bc.m_123342_(), bc.m_123343_(), howFar - 7, direction);
                list.m_142679_((StructurePiece)bridge);
                bridge.m_214092_(this, list, rand);
                list.m_142679_((StructurePiece)sTower);
                sTower.buildTowards(this, list, rand, dest);
                if (this.isMazeComplete(list, type)) {
                    complete = true;
                    continue;
                }
                start.f_192778_.clear();
                start.f_192778_.addAll(before);
            }
        }
    }

    private boolean isMazeComplete(StructurePieceAccessor list, BlockState type) {
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            if (start.f_192778_.size() > 60) {
                // empty if block
            }
            for (StructurePiece structurecomponent : start.f_192778_) {
                BoundingBox boundingBox = structurecomponent.m_73547_();
                int x = boundingBox.m_162399_() - boundingBox.m_162395_() / 2 + boundingBox.m_162395_();
                int y = boundingBox.m_162400_() - boundingBox.m_162396_() / 2 + boundingBox.m_162396_();
                int z = boundingBox.m_162401_() - boundingBox.m_162398_() / 2 + boundingBox.m_162398_();
                if (type == ((Block)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get()).m_49966_() && structurecomponent instanceof FinalCastleEntranceTowerComponent) {
                    return true;
                }
                if (type != ((Block)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get()).m_49966_() || !(structurecomponent instanceof FinalCastleBellTower21Component)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected BlockPos offsetTowerCCoords(int x, int y, int z, int howFar, Direction direction) {
        int dx = this.m_73392_(x, z);
        int dy = this.m_73544_(y);
        int dz = this.m_73525_(x, z);
        switch (direction) {
            case SOUTH: {
                dx += howFar;
                break;
            }
            case WEST: {
                dz += howFar;
                break;
            }
            case NORTH: {
                dx -= howFar;
                break;
            }
            case EAST: {
                dz -= howFar;
                break;
            }
        }
        return new BlockPos(dx, dy, dz);
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.m_226776_(world, sbb, 0, 0, 0, 48, 40, 48, false, rand, this.deco.randomBlocks);
        this.m_226776_(world, sbb, 13, 30, 1, 47, 30, 12, false, rand, this.deco.randomBlocks);
        this.m_73441_(world, sbb, 13, 31, 12, 36, 31, 12, this.deco.fenceState, this.deco.fenceState, false);
        this.m_226776_(world, sbb, 13, 30, 36, 47, 30, 47, false, rand, this.deco.randomBlocks);
        this.m_73441_(world, sbb, 13, 31, 36, 36, 31, 36, this.deco.fenceState, this.deco.fenceState, false);
        this.m_226776_(world, sbb, 1, 30, 1, 12, 30, 47, false, rand, this.deco.randomBlocks);
        this.m_73441_(world, sbb, 12, 31, 12, 12, 31, 36, this.deco.fenceState, this.deco.fenceState, false);
        this.m_226776_(world, sbb, 38, 25, 13, 47, 25, 35, false, rand, this.deco.randomBlocks);
        for (int i = 0; i < 5; ++i) {
            int y = 30 - i;
            this.makeMezzTopStairs(world, sbb, y, 10 + i, Direction.SOUTH);
            this.makeMezzTopStairs(world, sbb, y, 38 - i, Direction.NORTH);
            y = 25 - i;
            int x = 37 - i;
            BlockState stairState = FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.WEST, false);
            this.m_73441_(world, sbb, x, y, 14, x, y, 22, stairState, stairState, false);
            this.m_73441_(world, sbb, x, y - 1, 14, x, y - 1, 22, this.deco.blockState, this.deco.blockState, false);
            this.m_73441_(world, sbb, x, y, 26, x, y, 34, stairState, stairState, false);
            this.m_73441_(world, sbb, x, y - 1, 26, x, y - 1, 34, this.deco.blockState, this.deco.blockState, false);
        }
        for (int x = 11; x < 47; x += 12) {
            for (int z = 11; z < 47; z += 12) {
                this.m_73441_(world, sbb, x, 1, z, x + 2, 40, z + 2, this.deco.pillarState, this.deco.blockState, false);
                this.makePillarBase(world, sbb, x, z, 1, false);
                this.makePillarBase(world, sbb, x, z, 19, true);
                this.makePillarBase(world, sbb, x, z, 21, false);
                this.makePillarBase(world, sbb, x, z, 39, true);
            }
        }
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            for (int z = 11; z < 47; z += 12) {
                if (z == 23 && (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180)) continue;
                this.fillBlocksRotated(world, sbb, 1, 1, z, 1, 40, z + 2, this.deco.pillarState, rotation);
                this.makeHalfPillarBase(world, sbb, rotation, 1, z, false);
                this.makeHalfPillarBase(world, sbb, rotation, 19, z, true);
                this.makeHalfPillarBase(world, sbb, rotation, 21, z, false);
                this.makeHalfPillarBase(world, sbb, rotation, 39, z, true);
            }
        }
        this.m_226776_(world, sbb, 1, 20, 1, 47, 20, 47, false, rand, this.deco.randomBlocks);
        BlockState fieldBlock = ((Block)TFBlocks.PINK_FORCE_FIELD.get()).m_49966_();
        this.m_73441_(world, sbb, 12, 1, 12, 24, 10, 12, fieldBlock, fieldBlock, false);
        this.m_73441_(world, sbb, 12, 1, 12, 12, 10, 24, fieldBlock, fieldBlock, false);
        this.m_73441_(world, sbb, 24, 1, 12, 24, 10, 24, fieldBlock, fieldBlock, false);
        this.m_73441_(world, sbb, 12, 1, 24, 24, 10, 24, fieldBlock, fieldBlock, false);
        this.m_73441_(world, sbb, 13, 10, 12, 23, 10, 24, fieldBlock, fieldBlock, false);
        this.m_73441_(world, sbb, 12, 10, 12, 12, 10, 24, fieldBlock, fieldBlock, false);
        this.m_73441_(world, sbb, 24, 10, 12, 24, 10, 24, fieldBlock, fieldBlock, false);
        this.m_73441_(world, sbb, 17, 1, 12, 19, 4, 12, ((Block)TFBlocks.PINK_CASTLE_DOOR.get()).m_49966_(), AIR, false);
        this.m_73441_(world, sbb, 17, 1, 24, 19, 4, 24, ((Block)TFBlocks.PINK_CASTLE_DOOR.get()).m_49966_(), AIR, false);
        this.makeSmallTowerStairs(world, sbb, Rotation.NONE);
        this.makeSmallTowerStairs(world, sbb, Rotation.CLOCKWISE_90);
        this.makeSmallTowerStairs(world, sbb, Rotation.COUNTERCLOCKWISE_90);
        this.makeLargeTowerStairs(world, sbb, Rotation.CLOCKWISE_180);
        this.m_73441_(world, sbb, 48, 1, 23, 48, 4, 25, ((Block)TFBlocks.YELLOW_CASTLE_DOOR.get()).m_49966_(), AIR, false);
        this.m_73441_(world, sbb, 0, 31, 23, 0, 34, 25, ((Block)TFBlocks.BLUE_CASTLE_DOOR.get()).m_49966_(), AIR, false);
    }

    private void makeSmallTowerStairs(WorldGenLevel world, BoundingBox sbb, Rotation rotation) {
        for (int y = 1; y < 4; ++y) {
            int z = 40 + y;
            this.fillBlocksRotated(world, sbb, 1, 1, z, 4, y, z, this.deco.blockState, rotation);
            this.fillBlocksRotated(world, sbb, 2, y, z, 3, y, z, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.NORTH, false), rotation);
        }
    }

    private void makeLargeTowerStairs(WorldGenLevel world, BoundingBox sbb, Rotation rotation) {
        BlockState stairState = FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.NORTH, false);
        for (int y = 1; y < 4; ++y) {
            int z = 38 + y;
            this.fillBlocksRotated(world, sbb, 2, 1, z, 6, y, z, this.deco.blockState, rotation);
            this.fillBlocksRotated(world, sbb, 3, y, z, 5, y, z, stairState, rotation);
        }
    }

    private void makeMezzTopStairs(WorldGenLevel world, BoundingBox sbb, int y, int z, Direction stairMeta) {
        BlockState stairState = FinalCastleMainComponent.getStairState(this.deco.stairState, stairMeta, false);
        this.m_73441_(world, sbb, 38, y, z, 46, y, z, stairState, stairState, false);
        this.m_73441_(world, sbb, 38, y - 1, z, 46, y - 1, z, this.deco.blockState, this.deco.blockState, false);
        this.m_73535_(world, sbb, 38, y + 1, z, 46, y + 3, z);
    }

    private void makeHalfPillarBase(WorldGenLevel world, BoundingBox sbb, Rotation rotation, int y, int z, boolean isFlipped) {
        this.fillBlocksRotated(world, sbb, 2, y, z - 1, 2, y, z + 3, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.EAST, isFlipped), rotation);
        this.setBlockStateRotated(world, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.NORTH, isFlipped), 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.SOUTH, isFlipped), 1, y, z + 3, rotation, sbb);
    }

    private void makePillarBase(WorldGenLevel world, BoundingBox sbb, int x, int z, int y, boolean isFlipped) {
        this.m_73441_(world, sbb, x, y, z + 3, x + 3, y, z + 3, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.SOUTH, isFlipped), AIR, false);
        this.m_73441_(world, sbb, x - 1, y, z - 1, x + 2, y, z - 1, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.NORTH, isFlipped), AIR, false);
        this.m_73441_(world, sbb, x + 3, y, z - 1, x + 3, y, z + 2, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.EAST, isFlipped), AIR, false);
        this.m_73441_(world, sbb, x - 1, y, z, x - 1, y, z + 3, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.WEST, isFlipped), AIR, false);
    }
}

