/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import mcjty.rftoolspower.modules.blazing.items.BlazingRodStack;
import mcjty.rftoolspower.modules.blazing.logic.BlazingAgitatorAlgorithm;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class BlazingAgitatorTileEntity
extends TickingTileEntity {
    public static final int BUFFER_SIZE = 9;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(18).box(SlotDefinition.specific(BlazingAgitatorTileEntity::isValidBlazingRod).in(), 0, 28, 7, 3, 3).box(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).out(), 9, 117, 7, 3, 3).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid((slot, stack) -> BlazingAgitatorTileEntity.isValidBlazingRod(stack)).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)BlazingConfiguration.AGITATOR_MAXENERGY.get()).intValue(), (long)((Integer)BlazingConfiguration.AGITATOR_ENERGY_INPUT_PERTICK.get()).intValue());
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Blazing Agitator").containerSupplier(DefaultContainerProvider.container(BlazingModule.CONTAINER_BLAZING_AGITATOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    public static final VoxelShape SLAB = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_00 = Value.create((String)"lock00", (Type)Type.BOOLEAN, te -> te.isLocked(0, 0), (te, v) -> te.setLocked(0, 0, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_01 = Value.create((String)"lock01", (Type)Type.BOOLEAN, te -> te.isLocked(0, 1), (te, v) -> te.setLocked(0, 1, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_02 = Value.create((String)"lock02", (Type)Type.BOOLEAN, te -> te.isLocked(0, 2), (te, v) -> te.setLocked(0, 2, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_10 = Value.create((String)"lock10", (Type)Type.BOOLEAN, te -> te.isLocked(1, 0), (te, v) -> te.setLocked(1, 0, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_11 = Value.create((String)"lock11", (Type)Type.BOOLEAN, te -> te.isLocked(1, 1), (te, v) -> te.setLocked(1, 1, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_12 = Value.create((String)"lock12", (Type)Type.BOOLEAN, te -> te.isLocked(1, 2), (te, v) -> te.setLocked(1, 2, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_20 = Value.create((String)"lock20", (Type)Type.BOOLEAN, te -> te.isLocked(2, 0), (te, v) -> te.setLocked(2, 0, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_21 = Value.create((String)"lock21", (Type)Type.BOOLEAN, te -> te.isLocked(2, 1), (te, v) -> te.setLocked(2, 1, (boolean)v));
    @GuiValue
    public static final Value<?, Boolean> VALUE_LOCK_22 = Value.create((String)"lock22", (Type)Type.BOOLEAN, te -> te.isLocked(2, 2), (te, v) -> te.setLocked(2, 2, (boolean)v));
    private final float[] rotationSpeed = new float[9];
    private final float[] currentAngle = new float[9];
    private int updateSpeedCounter = 10;
    private final BlazingAgitatorAlgorithm algorithm;
    private final boolean[] locked = new boolean[9];

    public BlazingAgitatorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlazingModule.TYPE_BLAZING_AGITATOR.get(), pos, state);
        this.algorithm = new BlazingAgitatorAlgorithm(slot -> new BlazingRodStack(this.items.getStackInSlot(slot.intValue())));
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60918_(SoundType.f_56743_)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/blazingagitator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(BlazingAgitatorTileEntity::new)){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }

            @Nonnull
            public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
                return SLAB;
            }
        };
    }

    private static boolean isValidBlazingRod(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42585_) {
            return true;
        }
        if (stack.m_41720_() == BlazingModule.BLAZING_ROD.get()) {
            return BlazingRod.getInfusionStepsLeft(stack) >= 64;
        }
        return false;
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        for (int i = 0; i < 9; ++i) {
            tagCompound.m_128350_("rs" + i, this.rotationSpeed[i]);
        }
        this.saveItemHandlerCap(tagCompound);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        for (int i = 0; i < 9; ++i) {
            this.rotationSpeed[i] = tagCompound.m_128457_("rs" + i);
        }
        this.loadItemHandlerCap(tagCompound);
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected void tickServer() {
        boolean active = false;
        if (this.isMachineEnabled() && this.energyStorage.getEnergy() >= (long)((Integer)BlazingConfiguration.AGITATOR_USE_PER_TICK.get()).intValue()) {
            this.energyStorage.consumeEnergy((long)((Integer)BlazingConfiguration.AGITATOR_USE_PER_TICK.get()).intValue());
            active = true;
            this.tickRods();
        }
        this.updateClientRotationSpeed(active);
    }

    private void tickRods() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == Items.f_42585_) {
                this.items.setStackInSlot(i, new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get()));
            } else {
                float timeLeft = BlazingRod.getAgitationTimeLeft(stack);
                if (timeLeft > 0.0f) {
                    this.algorithm.tickBlazingRod(i, new BlazingRodStack(stack), timeLeft, this.infusable.getInfusedFactor());
                } else if (!this.locked[i]) {
                    this.moveToOutput(i, stack);
                }
            }
            this.markDirtyQuick();
        }
    }

    private void updateClientRotationSpeed(boolean active) {
        --this.updateSpeedCounter;
        if (this.updateSpeedCounter < 0) {
            this.updateSpeedCounter = 10;
            boolean changed = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack;
                float newspeed = 0.0f;
                if (active && !(stack = this.items.getStackInSlot(i)).m_41619_()) {
                    float percentage = BlazingRod.getAgitationTimePercentage(stack);
                    newspeed = percentage / 50.0f;
                }
                if (!((double)Math.abs(newspeed - this.rotationSpeed[i]) > 0.01)) continue;
                this.rotationSpeed[i] = newspeed;
                changed = true;
            }
            if (changed) {
                BlockState state = this.m_58900_();
                this.f_58857_.m_7260_(this.f_58858_, state, state, 6);
            }
        }
    }

    private void moveToOutput(int i, ItemStack stack) {
        for (int j = 9; j < 18; ++j) {
            if (!this.items.getStackInSlot(j).m_41619_()) continue;
            this.items.setStackInSlot(i, ItemStack.f_41583_);
            this.items.setStackInSlot(j, stack);
            return;
        }
    }

    public float getCurrentAngle(int x, int y) {
        return this.currentAngle[y * 3 + x];
    }

    public void setCurrentAngle(int x, int y, float currentAngle) {
        this.currentAngle[y * 3 + x] = currentAngle;
    }

    public float getRotationSpeed(int x, int y) {
        return this.rotationSpeed[y * 3 + x];
    }

    public boolean isLocked(int x, int y) {
        return this.locked[y * 3 + x];
    }

    public void setLocked(int x, int y, boolean v) {
        this.locked[y * 3 + x] = v;
        this.m_6596_();
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        byte[] bytes = info.m_128463_("locked");
        if (bytes.length >= 9) {
            for (int i = 0; i < 9; ++i) {
                this.locked[i] = bytes[i] != 0;
            }
        }
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        byte[] bytes = new byte[9];
        for (int i = 0; i < 9; ++i) {
            bytes[i] = (byte)(this.locked[i] ? 1 : 0);
        }
        info.m_128382_("locked", bytes);
    }
}

