/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.networking;

import com.inventorypets.capabilities.DataProvider;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketKeyInput {
    private final int keyInput;

    public PacketKeyInput(int keyInput) {
        this.keyInput = keyInput;
    }

    public PacketKeyInput(FriendlyByteBuf packetBuffer) {
        this.keyInput = packetBuffer.readInt();
    }

    public void toBytes(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(this.keyInput);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ctx.getSender().getCapability(DataProvider.CAPS).ifPresent(props -> props.setKeyInput(this.keyInput)));
        return true;
    }
}

