/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.networking;

import com.inventorypets.networking.PacketBiomeFinder;
import com.inventorypets.networking.PacketBiomeName;
import com.inventorypets.networking.PacketBiomeSender;
import com.inventorypets.networking.PacketKeyInput;
import com.inventorypets.networking.PacketPetNamer;
import com.inventorypets.networking.PacketTeleport;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("inventorypets", "channel")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(PacketKeyInput.class, PacketHandler.id(), NetworkDirection.PLAY_TO_SERVER).decoder(PacketKeyInput::new).encoder(PacketKeyInput::toBytes).consumerNetworkThread(PacketKeyInput::handle).add();
        net.messageBuilder(PacketPetNamer.class, PacketHandler.id(), NetworkDirection.PLAY_TO_SERVER).decoder(PacketPetNamer::new).encoder(PacketPetNamer::toBytes).consumerNetworkThread(PacketPetNamer::handle).add();
        net.messageBuilder(PacketBiomeFinder.class, PacketHandler.id(), NetworkDirection.PLAY_TO_SERVER).decoder(PacketBiomeFinder::new).encoder(PacketBiomeFinder::toBytes).consumerNetworkThread(PacketBiomeFinder::handle).add();
        net.messageBuilder(PacketBiomeName.class, PacketHandler.id(), NetworkDirection.PLAY_TO_SERVER).decoder(PacketBiomeName::new).encoder(PacketBiomeName::toBytes).consumerNetworkThread(PacketBiomeName::handle).add();
        net.messageBuilder(PacketBiomeSender.class, PacketHandler.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(PacketBiomeSender::new).encoder(PacketBiomeSender::toBytes).consumerNetworkThread(PacketBiomeSender::handle).add();
        net.messageBuilder(PacketTeleport.class, PacketHandler.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(PacketTeleport::new).encoder(PacketTeleport::toBytes).consumerNetworkThread(PacketTeleport::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToAllAround(MSG message, PacketDistributor.TargetPoint targetPoint) {
        INSTANCE.send(PacketDistributor.NEAR.with(() -> targetPoint), message);
    }

    static {
        packetId = 0;
    }
}

