/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.networking;

import com.inventorypets.capabilities.DataProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkEvent;

public class PacketBiomeSender {
    private final String searchBiome;

    public PacketBiomeSender(String searchBiome) {
        this.searchBiome = searchBiome;
    }

    public PacketBiomeSender(FriendlyByteBuf packetBuffer) {
        this.searchBiome = packetBuffer.m_130136_(4000);
    }

    public void toBytes(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130070_(this.searchBiome);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ItemStack pet = Minecraft.m_91087_().f_91074_.m_150109_().m_36056_();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (pet != null || pet.m_41720_() == Blocks.f_50016_.m_5456_()) {
                pet.m_41783_().m_128359_("biometosend", this.searchBiome);
                pet.m_41783_().m_128379_("openme", true);
                if (player.f_108545_.f_46443_) {
                    player.getCapability(DataProvider.CAPS).ifPresent(props -> {
                        props.setShield(2);
                        props.setBiomeToSend(this.searchBiome);
                    });
                }
            }
        });
        return true;
    }
}

