/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.helper;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;

public class ItemHelper {
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};

    public static ItemStack cloneItemStack(ItemStack itemStack, int stacksize) {
        ItemStack clonedItemStack = itemStack.m_41777_();
        clonedItemStack.m_41764_(stacksize);
        return clonedItemStack;
    }

    public static boolean equalsIgnorestacksize(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1 != ItemStack.f_41583_ && itemStack2 != ItemStack.f_41583_ && Item.m_41393_((Item)itemStack1.m_41720_()) - Item.m_41393_((Item)itemStack2.m_41720_()) == 0 && itemStack1.m_41720_() == itemStack2.m_41720_() && itemStack1.m_41773_() == itemStack2.m_41773_() && (itemStack1.m_41782_() && itemStack2.m_41782_() ? ItemStack.m_41728_((ItemStack)itemStack1, (ItemStack)itemStack2) : !itemStack1.m_41782_() && !itemStack2.m_41782_());
    }

    public static int getHotbarSize() {
        return 9;
    }

    public static int getPetSlot(Player player, Item itemIn, int maxDamage) {
        int foundFlag = -1;
        for (int i = 0; i <= ItemHelper.getHotbarSize() - 1; ++i) {
            ItemStack itemchk = player.m_150109_().m_8020_(i);
            if (itemchk == ItemStack.f_41583_ || itemchk.m_41720_() != itemIn || itemchk.m_41773_() >= maxDamage) continue;
            return i;
        }
        return foundFlag;
    }

    public static ItemStack getFurnaceResult(Level worldIn, ItemStack stackIn) {
        List recipes = worldIn.m_7465_().m_44013_(RecipeType.f_44108_);
        ItemStack result = ItemStack.f_41583_;
        for (int r = 0; r < recipes.size(); ++r) {
            ItemStack[] chkIngredients;
            SmeltingRecipe chkRecipe = (SmeltingRecipe)recipes.get(r);
            if (chkRecipe.m_7527_().size() != 1 || (chkIngredients = ((Ingredient)chkRecipe.m_7527_().get(0)).m_43908_())[0].m_41720_() != stackIn.m_41720_()) continue;
            result = chkRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
        }
        return result;
    }

    public static String nameFixer(String currentName) {
        currentName = currentName.replace("[", "");
        currentName = currentName.replace("]", "");
        return currentName;
    }

    public static ArmorMaterial newArmor(final String nameIn, final int maxDamageFactorIn, final int[] damageReductionAmountsIn, final int enchantabilityIn, final SoundEvent equipSoundIn, final float toughness, final Supplier<Ingredient> repairMaterialSupplier) {
        return new ArmorMaterial(){

            public float m_6651_() {
                return toughness;
            }

            public SoundEvent m_7344_() {
                return equipSoundIn;
            }

            public Ingredient m_6230_() {
                return (Ingredient)repairMaterialSupplier.get();
            }

            public String m_6082_() {
                return "inventorypets:" + nameIn;
            }

            public int m_6646_() {
                return enchantabilityIn;
            }

            public int m_266425_(ArmorItem.Type slotIn) {
                return MAX_DAMAGE_ARRAY[slotIn.m_266308_().m_20749_()] * maxDamageFactorIn;
            }

            public int m_7366_(ArmorItem.Type slotIn) {
                return damageReductionAmountsIn[slotIn.m_266308_().m_20749_()];
            }

            public float m_6649_() {
                return 1.0f;
            }
        };
    }
}

