/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.events;

import com.inventorypets.InventoryPets;
import com.inventorypets.config.InventoryPetsConfig;
import com.inventorypets.helper.AdvancementHelper;
import com.inventorypets.helper.ItemHelper;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="inventorypets", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CobbleDirtAchieveHandler {
    @SubscribeEvent
    public void notifyAttack(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            Player entityplayer = (Player)event.getEntity();
            Level world = entityplayer.m_9236_();
            if (!entityplayer.m_9236_().f_46443_) {
                boolean hasCobble = false;
                boolean hasDirt = false;
                for (int i = 0; i <= ItemHelper.getHotbarSize() - 1; ++i) {
                    ItemStack itemchk = entityplayer.m_150109_().m_8020_(i);
                    if (itemchk != ItemStack.f_41583_ && !((Boolean)InventoryPetsConfig.disableCobblestone.get()).booleanValue() && itemchk.m_41720_() == InventoryPets.PET_COBBLESTONE.get()) {
                        hasCobble = true;
                        continue;
                    }
                    if (itemchk == ItemStack.f_41583_ || ((Boolean)InventoryPetsConfig.disableDirt.get()).booleanValue() || itemchk.m_41720_() != InventoryPets.PET_DIRT.get()) continue;
                    hasDirt = true;
                }
                if (hasCobble || hasDirt) {
                    AABB range = new AABB(entityplayer.m_20185_() - 48.0, entityplayer.m_20186_() - 48.0, entityplayer.m_20189_() - 48.0, entityplayer.m_20185_() + 48.0, entityplayer.m_20186_() + 48.0, entityplayer.m_20189_() + 48.0);
                    List entities = world.m_45933_((Entity)entityplayer, range);
                    int esize = entities.size();
                    for (int k = 0; k <= esize - 1; ++k) {
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(entity instanceof ServerPlayer)) continue;
                        double xt = entity.m_20185_();
                        double yt = entity.m_20186_();
                        double zt = entity.m_20189_();
                        int x1 = Mth.m_14107_((double)entityplayer.m_20185_());
                        int y1 = Mth.m_14107_((double)entityplayer.m_20186_());
                        int z1 = Mth.m_14107_((double)entityplayer.m_20189_());
                        double x2 = xt - (double)x1;
                        double y2 = yt - (double)y1;
                        double z2 = zt - (double)z1;
                        ServerPlayer killingEntity = (ServerPlayer)entity;
                        if (Mth.m_14040_((int)((int)x2)) >= 48 || Mth.m_14040_((int)((int)z2)) >= 48 || Mth.m_14040_((int)((int)y2)) >= 48) continue;
                        if (hasCobble && !AdvancementHelper.hasAdvancement(killingEntity, new ResourceLocation("inventorypets", "kill_cobble"))) {
                            AdvancementHelper.unlockAdvancement(killingEntity, new ResourceLocation("inventorypets", "kill_cobble"));
                        }
                        if (!hasDirt || AdvancementHelper.hasAdvancement(killingEntity, new ResourceLocation("inventorypets", "kill_dirt"))) continue;
                        AdvancementHelper.unlockAdvancement(killingEntity, new ResourceLocation("inventorypets", "kill_dirt"));
                    }
                }
            }
        }
    }
}

