/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.inventorypets.InventoryPets;
import com.inventorypets.helper.ProxyHelper;
import com.inventorypets.init.ModSoundEvents;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;

public class MiniQuantumEndermanEntity
extends Monster
implements NeutralMob {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Optional<BlockState>> DATA_CARRY_STATE = SynchedEntityData.m_135353_(MiniQuantumEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);
    private static final EntityDataAccessor<Boolean> DATA_CREEPY = SynchedEntityData.m_135353_(MiniQuantumEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_STARED_AT = SynchedEntityData.m_135353_(MiniQuantumEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(MiniQuantumEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private int lastStareSound = Integer.MIN_VALUE;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private int teleportDelay;
    private boolean isAggressive;

    public MiniQuantumEndermanEntity(EntityType<? extends MiniQuantumEndermanEntity> mqe, Level level) {
        super(mqe, level);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EndermanFreezeWhenLookedAt(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new EndermanLookForPlayerGoal(this, arg_0 -> ((MiniQuantumEndermanEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.0);
    }

    public void m_6710_(@Nullable LivingEntity living) {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (living == null) {
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)false);
            this.f_19804_.m_135381_(DATA_STARED_AT, (Object)false);
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        } else {
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)true);
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        }
        super.m_6710_(living);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CARRY_STATE, Optional.empty());
        this.f_19804_.m_135372_(DATA_CREEPY, (Object)false);
        this.f_19804_.m_135372_(DATA_STARED_AT, (Object)false);
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void playStareSound() {
        if (this.f_19797_ >= this.lastStareSound + 400) {
            this.lastStareSound = this.f_19797_;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_11851_, this.m_5720_(), 2.5f, 1.0f, false);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_32513_) {
        if (DATA_CREEPY.equals(p_32513_) && this.hasBeenStaredAt() && this.m_9236_().f_46443_) {
            this.playStareSound();
        }
        super.m_7350_(p_32513_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        BlockState blockstate = this.getCarriedBlock();
        if (blockstate != null) {
            compound.m_128365_("carriedBlockState", (Tag)NbtUtils.m_129202_((BlockState)blockstate));
        }
        if (this.getOwnerId() == null) {
            compound.m_128359_("OwnerUUID", "");
        } else {
            compound.m_128359_("OwnerUUID", this.getOwnerId().toString());
        }
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        String s;
        super.m_7378_(compound);
        BlockState blockstate = null;
        if (compound.m_128425_("carriedBlockState", 10) && (blockstate = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("carriedBlockState"))).m_60795_()) {
            blockstate = null;
        }
        this.setCarriedBlock(blockstate);
        if (compound.m_128425_("OwnerUUID", 8)) {
            s = compound.m_128461_("OwnerUUID");
        } else {
            String s1 = compound.m_128461_("Owner");
            s = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s1).toString();
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.m_147285_(this.m_9236_(), compound);
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    boolean isLookingAtMe(Player playerIn) {
        Vec3 vec3 = playerIn.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - playerIn.m_20185_(), this.m_20188_() - playerIn.m_20188_(), this.m_20189_() - playerIn.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? playerIn.m_142582_((Entity)this) : false;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.55f;
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                ProxyHelper.spawnPortalEffects2((ClientLevel)this.m_9236_(), (int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
            }
        }
        if (!this.m_9236_().f_46443_ && this.getOwnerId() != null) {
            Player entityplayer = this.m_9236_().m_46003_(this.getOwnerId());
            if (entityplayer != null) {
                if (Math.abs(entityplayer.m_20185_() - this.m_20185_()) + Math.abs(entityplayer.m_20186_() - this.m_20186_()) + Math.abs(entityplayer.m_20189_() - this.m_20189_()) >= 30.0) {
                    this.teleportTowards((Entity)entityplayer);
                }
                if (entityplayer.m_21214_() != null && entityplayer.m_21214_().m_6084_()) {
                    this.m_6710_(entityplayer.m_21214_());
                }
                if (entityplayer.m_21188_() != null && entityplayer.m_21188_().m_6084_()) {
                    this.m_6710_(entityplayer.m_21188_());
                }
                if (this.m_5448_() == entityplayer) {
                    this.m_6710_(null);
                }
            }
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        this.f_20899_ = false;
        if (!this.isCreepy() || this.isAggressive || this.f_19796_.m_188503_(100) == 0) {
            // empty if block
        }
        if (this.m_5448_() != null) {
            this.m_21391_((Entity)this.m_5448_(), 100.0f, 100.0f);
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            if (this.m_5448_() != null) {
                if (this.m_5448_() instanceof LivingEntity) {
                    this.teleportDelay = 0;
                } else if (this.m_5448_().m_20280_((Entity)this) > 256.0 && this.teleportDelay++ >= 60 && this.teleportTowards((Entity)this.m_5448_())) {
                    this.teleportDelay = 0;
                }
            } else {
                this.teleportDelay = 0;
            }
        }
        super.m_8107_();
    }

    protected boolean teleport() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    boolean teleportTowards(Entity entity) {
        double d1 = entity.m_20185_() + (double)this.f_19796_.m_216339_(-3, 3);
        double d2 = entity.m_20186_() + (double)this.f_19796_.m_216339_(1, 3);
        double d3 = entity.m_20189_() + (double)this.f_19796_.m_216339_(-3, 3);
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13132_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.mqeidle.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.mqehit.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.mqedeath.get();
    }

    protected void m_7472_(DamageSource damage, int slot, boolean bool) {
        int h = this.f_19796_.m_188503_(100);
        if (h >= 2 && h <= 20) {
            this.m_20000_((ItemLike)InventoryPets.NUGGET_ENDER.get(), 1);
        } else if (h == 1) {
            this.m_20000_((ItemLike)InventoryPets.NUGGET_DIAMOND.get(), 1);
        }
    }

    public void setCarriedBlock(@Nullable BlockState p_32522_) {
        this.f_19804_.m_135381_(DATA_CARRY_STATE, Optional.ofNullable(p_32522_));
    }

    @Nullable
    public BlockState getCarriedBlock() {
        return ((Optional)this.f_19804_.m_135370_(DATA_CARRY_STATE)).orElse(null);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269014_()) {
            boolean flag1 = false;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return flag1;
        }
        boolean flag = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && !(source.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
            this.teleport();
        }
        return flag;
    }

    public boolean isCreepy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CREEPY);
    }

    public boolean hasBeenStaredAt() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STARED_AT);
    }

    public void setBeingStaredAt() {
        this.f_19804_.m_135381_(DATA_STARED_AT, (Object)true);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.getCarriedBlock() != null;
    }

    public boolean m_6126_() {
        return false;
    }

    static class EndermanFreezeWhenLookedAt
    extends Goal {
        private final MiniQuantumEndermanEntity enderman;
        @Nullable
        private LivingEntity target;

        public EndermanFreezeWhenLookedAt(MiniQuantumEndermanEntity mqe) {
            this.enderman = mqe;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.enderman.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.m_20280_((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.isLookingAtMe((Player)this.target);
        }

        public void m_8056_() {
            this.enderman.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.enderman.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }

    static class EndermanLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final MiniQuantumEndermanEntity enderman;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public EndermanLookForPlayerGoal(MiniQuantumEndermanEntity mqe, @Nullable Predicate<LivingEntity> predicate) {
            super((Mob)mqe, Player.class, 10, false, false, predicate);
            this.enderman = mqe;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_32578_ -> mqe.isLookingAtMe((Player)p_32578_));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.enderman.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
            this.teleportTime = 0;
            this.enderman.setBeingStaredAt();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.enderman.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderman.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.isLookingAtMe((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderman) > 256.0 && this.teleportTime++ >= this.m_183277_(30) && this.enderman.teleportTowards((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

