/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.inventorypets.InventoryPets;
import com.inventorypets.entities.SmallFirelessBall;
import com.inventorypets.helper.ProxyHelper;
import com.inventorypets.init.ModSoundEvents;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;

public class MiniQuantumBlazeEntity
extends Monster {
    private float allowedHeightOffset = 0.5f;
    private int nextHeightOffsetChangeTick;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(MiniQuantumBlazeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(MiniQuantumBlazeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public MiniQuantumBlazeEntity(EntityType<? extends MiniQuantumBlazeEntity> entity, Level level) {
        super(entity, level);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new BlazeAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.mqbbreathe.get();
    }

    protected SoundEvent m_7975_(DamageSource p_32235_) {
        return (SoundEvent)ModSoundEvents.mqbhit.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.mqbdeath.get();
    }

    public float getBrightness() {
        return 2.0f;
    }

    public void m_8107_() {
        Player entityplayer;
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.m_9236_().f_46443_ && this.getOwnerId() != null && (entityplayer = this.m_9236_().m_46003_(this.getOwnerId())) != null) {
            if (Math.abs(entityplayer.m_20185_() - this.m_20185_()) + Math.abs(entityplayer.m_20186_() - this.m_20186_()) + Math.abs(entityplayer.m_20189_() - this.m_20189_()) >= 30.0) {
                this.teleportTowards((Entity)entityplayer);
            }
            if (entityplayer.m_21214_() != null && entityplayer.m_21214_().m_6084_()) {
                this.m_6710_(entityplayer.m_21214_());
            }
            if (entityplayer.m_21188_() != null && entityplayer.m_21188_().m_6084_()) {
                this.m_6710_(entityplayer.m_21188_());
            }
            if (this.m_5448_() == entityplayer) {
                this.m_6710_(null);
            }
        }
        if (this.m_9236_().f_46443_) {
            if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            ProxyHelper.spawnPortalEffects2((ClientLevel)this.m_9236_(), (int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return false;
    }

    protected void m_8024_() {
        LivingEntity livingentity;
        --this.nextHeightOffsetChangeTick;
        if (this.nextHeightOffsetChangeTick <= 0) {
            this.nextHeightOffsetChangeTick = 100;
            this.allowedHeightOffset = 0.5f + (float)this.f_19796_.m_188583_() * 3.0f;
        }
        if ((livingentity = this.m_5448_()) != null && livingentity.m_20188_() > this.m_20188_() + (double)this.allowedHeightOffset && this.m_6779_(livingentity)) {
            Vec3 vec3 = this.m_20184_();
            this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
            this.f_19812_ = true;
        }
        super.m_8024_();
    }

    public boolean m_142535_(float p_149683_, float p_149684_, DamageSource p_149685_) {
        return false;
    }

    public boolean m_6060_() {
        return this.isCharged();
    }

    private boolean isCharged() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    void setCharged(boolean p_32241_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_32241_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() == null) {
            compound.m_128359_("OwnerUUID", "");
        } else {
            compound.m_128359_("OwnerUUID", this.getOwnerId().toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        String s;
        super.m_7378_(compound);
        if (compound.m_128425_("OwnerUUID", 8)) {
            s = compound.m_128461_("OwnerUUID");
        } else {
            String s1 = compound.m_128461_("Owner");
            s = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s1).toString();
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    boolean teleportTowards(Entity entity) {
        double d1 = entity.m_20185_() + (double)this.f_19796_.m_216339_(-3, 3);
        double d2 = entity.m_20186_() + (double)this.f_19796_.m_216339_(1, 3);
        double d3 = entity.m_20189_() + (double)this.f_19796_.m_216339_(-3, 3);
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13132_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected void m_7472_(DamageSource damage, int slot, boolean bool) {
        int h = this.f_19796_.m_188503_(100);
        if (h >= 2 && h <= 20) {
            this.m_20000_((ItemLike)InventoryPets.NUGGET_COAL.get(), 1);
        } else if (h == 1) {
            this.m_20000_((ItemLike)InventoryPets.NUGGET_DIAMOND.get(), 1);
        }
    }

    static class BlazeAttackGoal
    extends Goal {
        private final MiniQuantumBlazeEntity blaze;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public BlazeAttackGoal(MiniQuantumBlazeEntity p_32247_) {
            this.blaze = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.blaze.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.blaze.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.blaze.setCharged(false);
            this.lastSeen = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.blaze.m_5448_();
            if (livingentity != null) {
                boolean flag = this.blaze.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.blaze.m_20280_((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blaze.m_7327_((Entity)livingentity);
                    }
                    this.blaze.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.m_20185_() - this.blaze.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - this.blaze.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - this.blaze.m_20189_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                            this.blaze.setCharged(true);
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                            this.blaze.setCharged(false);
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.blaze.m_20067_()) {
                                this.blaze.m_9236_().m_5898_((Player)null, 1018, this.blaze.m_20183_(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                SmallFirelessBall smallfireball = new SmallFirelessBall(this.blaze.m_9236_(), (LivingEntity)this.blaze, d1 + this.blaze.m_217043_().m_188583_() * d4, d2, d3 + this.blaze.m_217043_().m_188583_() * d4);
                                smallfireball.m_6034_(smallfireball.m_20185_(), this.blaze.m_20227_(0.5) + 0.5, smallfireball.m_20189_());
                                this.blaze.m_9236_().m_7967_((Entity)smallfireball);
                            }
                        }
                    }
                    this.blaze.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.blaze.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.blaze.m_21133_(Attributes.f_22277_);
        }
    }
}

