/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.capabilities;

import com.inventorypets.capabilities.PlayerData;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class DataProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PlayerData> CAPS = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerData>(){});
    private PlayerData playerData = null;
    private final LazyOptional<PlayerData> opt = LazyOptional.of(this::createCapability);

    @Nonnull
    private PlayerData createCapability() {
        if (this.playerData == null) {
            this.playerData = new PlayerData();
        }
        return this.playerData;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CAPS) {
            return this.opt.cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.createCapability().saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.createCapability().loadNBTData(nbt);
    }
}

