/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.common.item;

import cofh.core.common.capability.CapabilityArchery;
import cofh.core.common.item.IMultiModeItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ArcheryHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.api.ContainerType;
import cofh.lib.api.capability.IArcheryAmmoItem;
import cofh.lib.api.item.IColorableItem;
import cofh.lib.api.item.IFluidContainerItem;
import cofh.lib.common.fluid.FluidContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.common.item.FluidContainerItemAugmentable;
import cofh.thermal.lib.util.ThermalAugmentRules;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PotionQuiverItem
extends FluidContainerItemAugmentable
implements IColorableItem,
DyeableLeatherItem,
IMultiModeItem {
    protected int fluidPerUse = 50;
    protected int arrowCapacity;

    public PotionQuiverItem(Item.Properties builder, int fluidCapacity, int arrowCapacity) {
        this(builder, fluidCapacity, arrowCapacity, FluidHelper::hasPotionTag);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity, seed) -> this.m_41113_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("arrows"), (stack, world, entity, seed) -> (float)this.getStoredArrows(stack) / (float)this.getMaxArrows(stack));
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity, seed) -> (this.getFluidAmount(stack) > 0 ? 0.5f : 0.0f) + (this.getMode(stack) > 0 ? 0.25f : 0.0f));
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalCoreConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "Fluid", "Potion", "Filter"});
    }

    public PotionQuiverItem(Item.Properties builder, int fluidCapacity, int arrowCapacity, Predicate<FluidStack> validator) {
        super(builder, fluidCapacity, validator);
        this.arrowCapacity = arrowCapacity;
    }

    public void setFluidPerUse(int fluidPerUse) {
        this.fluidPerUse = fluidPerUse;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.quiver.use").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.quiver.use.sneak").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.quiver.mode." + this.getMode(stack))).m_130940_(ChatFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)(this.isCreative(stack, ContainerType.ITEM) ? StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.arrows") + ": ")).m_7220_((Component)StringHelper.getTextComponent((String)"info.cofh.infinite").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC)) : StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.arrows") + ": " + this.getStoredArrows(stack) + " / " + StringHelper.format((long)this.getMaxArrows(stack))))));
        FluidStack fluid = this.getFluid(stack);
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)fluid.getTag())) {
            effects.add(new MobEffectInstance(effect.m_19544_(), this.getEffectDuration(effect, stack), this.getEffectAmplifier(effect, stack), effect.m_19571_(), effect.m_19572_()));
        }
        this.potionTooltip(stack, worldIn, tooltip, flagIn, effects, 0.125f);
    }

    public int m_142159_(ItemStack stack) {
        if (this.getFluidAmount(stack) <= 0) {
            return super.m_142159_(stack);
        }
        return FluidHelper.color((FluidStack)this.getFluid(stack));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Arrows", "Fluid"}));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19098_((Object)stack);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)subTag, (CompoundTag)augmentData, (String)"PotionAmp");
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)subTag, (CompoundTag)augmentData, (String)"PotionDur");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected boolean useDelegate(ItemStack stack, Player player, InteractionHand hand) {
        if (Utils.isFakePlayer((Entity)player)) {
            return false;
        }
        if (player.m_36341_()) {
            ItemStack arrows = ArcheryHelper.findArrows((Player)player);
            if (!arrows.m_41619_() && arrows.m_41613_() < arrows.m_41741_()) {
                arrows.m_41769_(this.removeArrows(stack, arrows.m_41741_() - arrows.m_41613_(), false));
            } else {
                arrows = new ItemStack((ItemLike)Items.f_42412_, Math.min(this.getStoredArrows(stack), 64));
                if (Utils.addToPlayerInventory((Player)player, (ItemStack)arrows)) {
                    this.removeArrows(stack, arrows.m_41613_(), false);
                }
            }
        } else if (player.f_36077_.f_35937_) {
            this.putArrows(stack, this.getMaxArrows(stack), false);
        } else {
            ItemStack arrows = ArcheryHelper.findArrows((Player)player);
            arrows.m_41774_(this.putArrows(stack, arrows.m_41613_(), false));
        }
        stack.m_41754_(5);
        return true;
    }

    protected int getStoredArrows(ItemStack stack) {
        return this.isCreative(stack, ContainerType.ITEM) ? this.getMaxArrows(stack) : stack.m_41784_().m_128451_("Arrows");
    }

    protected int getMaxArrows(ItemStack stack) {
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"BaseMod", (float)1.0f);
        return this.getMaxStored(stack, Math.round((float)this.arrowCapacity * base));
    }

    protected int putArrows(ItemStack stack, int maxArrows, boolean simulate) {
        int stored = this.getStoredArrows(stack);
        int toAdd = Math.min(maxArrows, this.getMaxArrows(stack) - stored);
        if (!simulate && !this.isCreative(stack, ContainerType.ITEM)) {
            stack.m_41784_().m_128405_("Arrows", stored += toAdd);
        }
        return toAdd;
    }

    protected int removeArrows(ItemStack stack, int maxArrows, boolean simulate) {
        if (this.isCreative(stack, ContainerType.ITEM)) {
            return maxArrows;
        }
        int stored = Math.min(stack.m_41784_().m_128451_("Arrows"), this.getMaxArrows(stack));
        int toRemove = Math.min(maxArrows, stored);
        if (!simulate) {
            stack.m_41784_().m_128405_("Arrows", stored -= toRemove);
        }
        return toRemove;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PotionQuiverItemWrapper(stack, (IFluidContainerItem)this);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        int arrowExcess = this.getStoredArrows(container) - this.getMaxArrows(container);
        if (arrowExcess > 0) {
            this.removeArrows(container, arrowExcess, false);
        }
    }

    public int getColor(ItemStack item, int colorIndex) {
        if (colorIndex == 0) {
            CompoundTag nbt = item.m_41737_("display");
            return nbt != null && nbt.m_128425_("color", 99) ? nbt.m_128451_("color") : 0xFFFFFF;
        }
        if (colorIndex == 2) {
            return this.getFluidAmount(item) > 0 ? FluidHelper.color((FluidStack)this.getFluid(item)) : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.4f, 0.6f + 0.2f * (float)this.getMode(stack));
        ProxyUtils.setOverlayMessage((Player)player, (Component)Component.m_237115_((String)("info.thermal.quiver.mode." + this.getMode(stack))));
    }

    protected class PotionQuiverItemWrapper
    extends FluidContainerItemWrapper
    implements IArcheryAmmoItem {
        private final LazyOptional<IArcheryAmmoItem> holder;

        PotionQuiverItemWrapper(ItemStack containerIn, IFluidContainerItem itemIn) {
            super(containerIn, itemIn);
            this.holder = LazyOptional.of(() -> this);
        }

        public void onArrowLoosed(Player shooter) {
            if (shooter != null && !shooter.f_36077_.f_35937_) {
                PotionQuiverItem.this.removeArrows(this.container, 1, false);
                this.drain(PotionQuiverItem.this.fluidPerUse, PotionQuiverItem.this.getMode(this.container) == 1 ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE);
            }
        }

        public AbstractArrow createArrowEntity(Level world, Player shooter) {
            FluidStack fluid = PotionQuiverItem.this.getFluid(this.container);
            if (PotionQuiverItem.this.getMode(this.container) == 1 && fluid != null && fluid.getAmount() >= PotionQuiverItem.this.fluidPerUse) {
                ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
                for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)fluid.getTag())) {
                    effects.add(new MobEffectInstance(effect.m_19544_(), PotionQuiverItem.this.getEffectDuration(effect, this.container), PotionQuiverItem.this.getEffectAmplifier(effect, this.container), effect.m_19571_(), effect.m_19572_()));
                }
                ItemStack arrowStack = PotionUtils.m_43552_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), effects);
                return ((TippedArrowItem)arrowStack.m_41720_()).m_6394_(world, arrowStack, (LivingEntity)shooter);
            }
            ItemStack arrowStack = new ItemStack((ItemLike)Items.f_42412_);
            return ((ArrowItem)arrowStack.m_41720_()).m_6394_(world, arrowStack, (LivingEntity)shooter);
        }

        public boolean isEmpty(Player shooter) {
            if (PotionQuiverItem.this.isCreative(this.container, ContainerType.ITEM) || shooter != null && shooter.f_36077_.f_35937_) {
                return false;
            }
            return PotionQuiverItem.this.getStoredArrows(this.container) <= 0;
        }

        public boolean isInfinite(ItemStack bow, Player shooter) {
            return shooter != null && shooter.f_36077_.f_35937_ || Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)bow) > 0;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityArchery.AMMO_ITEM_CAPABILITY) {
                return CapabilityArchery.AMMO_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

