/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TagsUpdateListener {
    private static RegistryAccess registryAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
    private static Map<ResourceKey<? extends Registry>, Map> tagCache = new HashMap<ResourceKey<? extends Registry>, Map>();
    public static final ICondition.IContext REMOTE_TAG_ACCESS = new ICondition.IContext(){

        public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
            if (tagCache.containsKey(registry)) {
                return tagCache.get(registry);
            }
            Map<ResourceLocation, Collection<Holder<T>>> gen = registryAccess.m_6632_(registry).map(Registry::m_203612_).stream().flatMap(UnaryOperator.identity()).collect(Collectors.toMap(tag -> ((TagKey)tag.getFirst()).f_203868_(), tag -> ((HolderSet.Named)tag.getSecond()).m_203614_().toList()));
            tagCache.put(registry, gen);
            return gen;
        }
    };

    @SubscribeEvent
    public static void receiveClientsideTags(TagsUpdatedEvent e) {
        if (e.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            registryAccess = e.getRegistryAccess();
            tagCache.clear();
        }
    }
}

