/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.recipes.replacers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.zeith.api.registry.RegistryMapping;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.core.recipes.replacers.IRemainingItemReplacer;
import org.zeith.hammerlib.proxy.HLConstants;

@SimplyRegister
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RemainingReplacerRegistrar {
    @RegistryName(value="none")
    public static final IRemainingItemReplacer NONE = (container, slot, item) -> item;
    private static IForgeRegistry<IRemainingItemReplacer> registry;

    public static List<IRemainingItemReplacer> fromJson(JsonArray object) {
        ArrayList<IRemainingItemReplacer> lst = new ArrayList<IRemainingItemReplacer>();
        for (JsonElement element : object) {
            IRemainingItemReplacer r = RemainingReplacerRegistrar.get(new ResourceLocation(element.getAsString()));
            if (r == null) continue;
            lst.add(r);
        }
        return lst;
    }

    public static void toNetwork(List<IRemainingItemReplacer> lst, FriendlyByteBuf buf) {
        List<ResourceLocation> replacers = lst.stream().map(RemainingReplacerRegistrar::key).filter(Objects::nonNull).toList();
        buf.writeShort(replacers.size());
        for (ResourceLocation r : replacers) {
            buf.m_130085_(r);
        }
    }

    public static List<IRemainingItemReplacer> fromNetwork(FriendlyByteBuf buf) {
        ArrayList<IRemainingItemReplacer> lst = new ArrayList<IRemainingItemReplacer>();
        int size = buf.readShort();
        for (int i = 0; i < size; ++i) {
            IRemainingItemReplacer r = RemainingReplacerRegistrar.get(buf.m_130281_());
            if (r == null) continue;
            lst.add(r);
        }
        return lst;
    }

    public static IForgeRegistry<IRemainingItemReplacer> registry() {
        return registry;
    }

    public static IRemainingItemReplacer get(ResourceLocation key) {
        return (IRemainingItemReplacer)registry.getValue(key);
    }

    public static ResourceLocation key(IRemainingItemReplacer replacer) {
        return registry.getKey((Object)replacer);
    }

    @SubscribeEvent
    public static void allocRegistry(NewRegistryEvent e) {
        e.create(new RegistryBuilder().setName(HLConstants.id("recipe_replacer")).disableSync().disableSaving().disableOverrides().setDefaultKey(HLConstants.id("none")), r -> {
            registry = r;
            RegistryMapping.report(IRemainingItemReplacer.class, registry, false);
        });
    }
}

