/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.zeith.api.registry.RegistryMapping;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.annotations.Ref;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.client.ClientSetup;
import org.zeith.hammerlib.annotations.client.Particles;
import org.zeith.hammerlib.annotations.client.TileRenderer;
import org.zeith.hammerlib.api.blocks.ICreativeTabBlock;
import org.zeith.hammerlib.api.blocks.ICustomBlockItem;
import org.zeith.hammerlib.api.blocks.IItemPropertySupplier;
import org.zeith.hammerlib.api.blocks.INoItemBlock;
import org.zeith.hammerlib.api.fml.ICustomRegistrar;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.core.adapter.CreativeTabAdapter;
import org.zeith.hammerlib.core.adapter.OnlyIfAdapter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;

public class RegistryAdapter {
    private static final Map<Class<?>, List<Tuple2<Block, ResourceLocation>>> blocks = new ConcurrentHashMap();

    public static <T> Optional<BiConsumer<ResourceLocation, T>> createRegisterer(RegisterEvent event, ResourceKey<Registry<T>> registryType, String prefix) {
        if (event.getRegistryKey().equals(registryType)) {
            Registry reg = event.getVanillaRegistry();
            IForgeRegistry freg = event.getForgeRegistry();
            if (prefix == null) {
                prefix = "";
            }
            if (freg != null) {
                return Optional.of(RegistryAdapter.createRegisterer(freg, prefix));
            }
            if (reg != null) {
                return Optional.of(RegistryAdapter.createRegisterer(reg, prefix));
            }
        }
        return Optional.empty();
    }

    public static <T> BiConsumer<ResourceLocation, T> createRegisterer(IForgeRegistry<T> registry, String prefix) {
        return (name, entry) -> {
            name = new ResourceLocation(name.m_135827_(), prefix + name.m_135815_());
            IRegisterListener l = Cast.cast(entry, IRegisterListener.class);
            if (l != null) {
                l.onPreRegistered((ResourceLocation)name);
            }
            registry.register(name, entry);
            if (l != null) {
                l.onPostRegistered((ResourceLocation)name);
            }
        };
    }

    public static <T> BiConsumer<ResourceLocation, T> createRegisterer(Registry<T> registry, String prefix) {
        return (name, entry) -> {
            name = new ResourceLocation(name.m_135827_(), prefix + name.m_135815_());
            IRegisterListener l = Cast.cast(entry, IRegisterListener.class);
            if (l != null) {
                l.onPreRegistered((ResourceLocation)name);
            }
            Registry.m_122965_((Registry)registry, (ResourceLocation)name, (Object)entry);
            if (l != null) {
                l.onPostRegistered((ResourceLocation)name);
            }
        };
    }

    public static int register(RegisterEvent event, Class<?> source, String modid, String prefix) {
        IForgeRegistry reg = event.getForgeRegistry();
        if (reg == null) {
            reg = RegistryMapping.getRegistryByType(RegistryMapping.getSuperType(event.getRegistryKey()));
        }
        return RegistryAdapter.register(event, reg, source, modid, prefix);
    }

    public static <T> int register(RegisterEvent event, IForgeRegistry<T> registry, Class<?> source, String modid, String prefix) {
        Class superType = RegistryMapping.getSuperType(registry);
        ResourceKey regKey = event.getRegistryKey();
        List blockList = blocks.computeIfAbsent(source, s -> new ArrayList());
        SimplyRegister registrar = source.getAnnotation(SimplyRegister.class);
        List tabs = registrar != null ? Ref.Resolver.resolveFields(CreativeTab.class, registrar.creativeTabs()) : List.of();
        BiConsumer<ResourceLocation, Object> grabber = RegistryAdapter.createRegisterer(registry, prefix).andThen((key, handler) -> {
            if (handler instanceof Block) {
                Block b = (Block)handler;
                blockList.add(Tuples.immutable(b, key));
            }
            if (handler instanceof ItemLike) {
                ItemLike item = (ItemLike)handler;
                if (!tabs.isEmpty()) {
                    CreativeTabAdapter.bindTab(item, (CreativeTab[])tabs.toArray(CreativeTab[]::new));
                }
            }
        });
        if (Item.class.equals(superType)) {
            for (Tuple2 e : blockList) {
                BlockItem item;
                Block blk = (Block)e.a();
                if (blk instanceof INoItemBlock) continue;
                IItemPropertySupplier gen = Cast.cast(blk, IItemPropertySupplier.class);
                if (blk instanceof ICustomBlockItem) {
                    item = ((ICustomBlockItem)blk).createBlockItem();
                } else {
                    Item.Properties def = new Item.Properties();
                    Item.Properties props = gen != null ? gen.createItemProperties(def) : def;
                    item = new BlockItem(blk, props);
                    if (blk instanceof ICreativeTabBlock) {
                        ICreativeTabBlock t = (ICreativeTabBlock)blk;
                        t.getCreativeTab().add(item);
                    }
                }
                grabber.accept((ResourceLocation)e.b(), Cast.cast(item));
            }
        }
        boolean tileRegistryOnClient = BlockEntityType.class.equals(superType) && FMLEnvironment.dist == Dist.CLIENT;
        boolean particleRegistryOnClient = ParticleType.class.equals(superType) && FMLEnvironment.dist == Dist.CLIENT;
        int prevSize = registry != null ? registry.getValues().size() : 0;
        Arrays.stream(source.getDeclaredFields()).filter(f -> ICustomRegistrar.class.isAssignableFrom(f.getType())).filter(field -> Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())).forEach(field -> {
            try {
                field.setAccessible(true);
                RegistryName name = field.getAnnotation(RegistryName.class);
                ResourceLocation rl = new ResourceLocation(modid, prefix + name.value());
                Object val = field.get(null);
                OnlyIf onlyIf = field.getAnnotation(OnlyIf.class);
                if ((!RegistryMapping.isNonIntrusive(regKey) || OnlyIfAdapter.checkCondition(onlyIf, source.toString(), superType != null ? superType.getSimpleName() : field.getType().getSimpleName(), val, rl)) && val instanceof ICustomRegistrar) {
                    ICustomRegistrar cr = (ICustomRegistrar)val;
                    cr.performRegister(event, rl);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LogManager.getLogger((String)(modid + "/" + source.getSimpleName())).error("Failed to register field {}", (Object)field.getName(), (Object)e);
            }
        });
        if (superType == null) {
            return registry == null ? 0 : registry.getValues().size() - prevSize;
        }
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(SimplyRegister.class) != null && m.getParameterCount() == 1 && BiConsumer.class.isAssignableFrom(m.getParameterTypes()[0]) && ReflectionUtil.doesParameterTypeArgsMatch(m.getParameters()[0], ResourceLocation.class, superType)).filter(method -> Modifier.isStatic(method.getModifiers())).forEach(method -> {
            String prefix2 = Optional.ofNullable(method.getAnnotation(SimplyRegister.class)).map(SimplyRegister::prefix).orElse("");
            try {
                method.setAccessible(true);
                BiConsumer<ResourceLocation, Object> grabber2 = (id, obj) -> {
                    id = new ResourceLocation(id.m_135827_(), prefix2 + id.m_135815_());
                    grabber.accept((ResourceLocation)id, obj);
                };
                method.invoke(null, grabber2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LogManager.getLogger((String)(modid + "/" + source.getSimpleName())).error("Failed to register method {}", (Object)method.getName(), (Object)e);
            }
        });
        Arrays.stream(source.getDeclaredFields()).filter(f -> superType.isAssignableFrom(f.getType()) && !ICustomRegistrar.class.isAssignableFrom(f.getType())).filter(field -> Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())).forEach(field -> {
            try {
                field.setAccessible(true);
                RegistryName name = field.getAnnotation(RegistryName.class);
                ResourceLocation rl = new ResourceLocation(modid, name.value());
                Object val = field.get(null);
                OnlyIf onlyIf = field.getAnnotation(OnlyIf.class);
                if (!RegistryMapping.isNonIntrusive(regKey) || OnlyIfAdapter.checkCondition(onlyIf, source.toString(), superType.getSimpleName(), val, rl)) {
                    Particles.Info provider;
                    TileRenderer.Info tesr;
                    Object fval = superType.cast(val);
                    grabber.accept(rl, fval);
                    if (tileRegistryOnClient && (tesr = TileRenderer.Info.get(source, field.getName())) != null) {
                        tesr.apply();
                        HammerLib.LOG.debug("Applied TESR registration for " + field.getType().getSimpleName() + "[" + registry.getKey(fval) + "] " + source.getSimpleName() + "." + field.getName());
                    }
                    if (particleRegistryOnClient && (provider = Particles.Info.get(source, field.getName())) != null) {
                        provider.apply();
                        HammerLib.LOG.debug("Applied ParticleProvider for " + field.getType().getSimpleName() + "[" + registry.getKey(fval) + "] " + source.getSimpleName() + "." + field.getName());
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LogManager.getLogger((String)(modid + "/" + source.getSimpleName())).error("Failed to register field {}", (Object)field.getName(), (Object)e);
            }
        });
        return registry.getValues().size() - prevSize;
    }

    public static void setup(FMLCommonSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(Setup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "Setup", null, null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLCommonSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public static void clientSetup(FMLClientSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(ClientSetup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "ClientSetup", null, null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLClientSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }
}

