/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.Tags;
import org.zeith.hammerlib.core.init.TagsHL;
import org.zeith.hammerlib.proxy.HLConstants;

public class OreDictionaryAdapter {
    private static final Map<String, List<ResourceLocation>> MAPPING = new HashMap<String, List<ResourceLocation>>();
    private static final Function<String, List<ResourceLocation>> MAP_GEN = s -> new ArrayList();
    private static boolean hasInit;

    private static void addMapping(String key, ResourceLocation value) {
        MAPPING.computeIfAbsent(key, MAP_GEN).add(value);
    }

    public static void register(String key, String value) {
        OreDictionaryAdapter.register(key, new ResourceLocation((String)(value.contains(":") ? value : "forge:" + value)));
    }

    public static void register(String key, TagKey<Item> tag) {
        if (tag != null) {
            OreDictionaryAdapter.register(key, tag.f_203868_());
        }
    }

    public static void register(String key, ResourceLocation value) {
        OreDictionaryAdapter.addMapping(key, value);
    }

    @Nonnull
    public static List<ResourceLocation> get(String od) {
        if (!MAPPING.containsKey(od)) {
            if (od.startsWith("ingot")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "ingots/" + od.substring(5).toLowerCase()));
            }
            if (od.startsWith("ore")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "ores/" + od.substring(3).toLowerCase()));
            }
            if (od.startsWith("gem")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "gems/" + od.substring(3).toLowerCase()));
            }
            if (od.startsWith("block")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "storage_blocks/" + od.substring(5).toLowerCase()));
            }
            if (od.startsWith("dust")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "dusts/" + od.substring(4).toLowerCase()));
            }
            if (od.startsWith("gear")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "gears/" + od.substring(4).toLowerCase()));
            }
            if (od.startsWith("plate")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "plates/" + od.substring(5).toLowerCase()));
            }
            if (MAPPING.containsKey(od)) {
                HLConstants.LOG.debug("Generated mapping for " + od + ": " + MAPPING.get(od));
            }
        }
        return MAPPING.computeIfAbsent(od, MAP_GEN);
    }

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionaryAdapter.register("logWood", (TagKey<Item>)ItemTags.f_13182_);
            OreDictionaryAdapter.register("plankWood", (TagKey<Item>)ItemTags.f_13168_);
            OreDictionaryAdapter.register("slabWood", (TagKey<Item>)ItemTags.f_13175_);
            OreDictionaryAdapter.register("stairWood", (TagKey<Item>)ItemTags.f_13174_);
            OreDictionaryAdapter.register("fenceWood", (TagKey<Item>)Tags.Items.FENCES_WOODEN);
            OreDictionaryAdapter.register("fenceGateWood", (TagKey<Item>)Tags.Items.FENCE_GATES_WOODEN);
            OreDictionaryAdapter.register("doorWood", (TagKey<Item>)ItemTags.f_13173_);
            OreDictionaryAdapter.register("stickWood", (TagKey<Item>)Tags.Items.RODS_WOODEN);
            OreDictionaryAdapter.register("treeSapling", (TagKey<Item>)ItemTags.f_13180_);
            OreDictionaryAdapter.register("treeLeaves", (TagKey<Item>)ItemTags.f_13143_);
            OreDictionaryAdapter.register("oreGold", (TagKey<Item>)Tags.Items.ORES_GOLD);
            OreDictionaryAdapter.register("oreIron", (TagKey<Item>)Tags.Items.ORES_IRON);
            OreDictionaryAdapter.register("oreLapis", (TagKey<Item>)Tags.Items.ORES_LAPIS);
            OreDictionaryAdapter.register("oreDiamond", (TagKey<Item>)Tags.Items.ORES_DIAMOND);
            OreDictionaryAdapter.register("oreRedstone", (TagKey<Item>)Tags.Items.ORES_REDSTONE);
            OreDictionaryAdapter.register("oreEmerald", (TagKey<Item>)Tags.Items.ORES_EMERALD);
            OreDictionaryAdapter.register("oreQuartz", (TagKey<Item>)Tags.Items.ORES_QUARTZ);
            OreDictionaryAdapter.register("oreCoal", (TagKey<Item>)Tags.Items.ORES_COAL);
            OreDictionaryAdapter.register("ingotIron", (TagKey<Item>)Tags.Items.INGOTS_IRON);
            OreDictionaryAdapter.register("ingotGold", (TagKey<Item>)Tags.Items.INGOTS_GOLD);
            OreDictionaryAdapter.register("ingotBrick", (TagKey<Item>)Tags.Items.INGOTS_BRICK);
            OreDictionaryAdapter.register("ingotBrickNether", (TagKey<Item>)Tags.Items.INGOTS_NETHER_BRICK);
            OreDictionaryAdapter.register("nuggetIron", (TagKey<Item>)Tags.Items.NUGGETS_IRON);
            OreDictionaryAdapter.register("nuggetIron", (TagKey<Item>)Tags.Items.NUGGETS_GOLD);
            OreDictionaryAdapter.register("gemDiamond", (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
            OreDictionaryAdapter.register("gemEmerald", (TagKey<Item>)Tags.Items.GEMS_EMERALD);
            OreDictionaryAdapter.register("gemQuartz", (TagKey<Item>)Tags.Items.GEMS_QUARTZ);
            OreDictionaryAdapter.register("gemPrismarine", (TagKey<Item>)Tags.Items.GEMS_PRISMARINE);
            OreDictionaryAdapter.register("gemLapis", (TagKey<Item>)Tags.Items.GEMS_LAPIS);
            OreDictionaryAdapter.register("enderpearl", (TagKey<Item>)Tags.Items.ENDER_PEARLS);
            OreDictionaryAdapter.register("dustPrismarine", (TagKey<Item>)Tags.Items.DUSTS_PRISMARINE);
            OreDictionaryAdapter.register("dustRedstone", (TagKey<Item>)Tags.Items.DUSTS_REDSTONE);
            OreDictionaryAdapter.register("dustGlowstone", (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE);
            OreDictionaryAdapter.register("blockGold", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
            OreDictionaryAdapter.register("blockIron", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
            OreDictionaryAdapter.register("blockLapis", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS);
            OreDictionaryAdapter.register("blockDiamond", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
            OreDictionaryAdapter.register("blockRedstone", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE);
            OreDictionaryAdapter.register("blockEmerald", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD);
            OreDictionaryAdapter.register("blockQuartz", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ);
            OreDictionaryAdapter.register("blockCoal", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL);
            OreDictionaryAdapter.register("blockGlass", (TagKey<Item>)Tags.Items.GLASS);
            OreDictionaryAdapter.register("dye", (TagKey<Item>)Tags.Items.DYES);
            OreDictionaryAdapter.register("stone", (TagKey<Item>)Tags.Items.STONE);
            OreDictionaryAdapter.register("obsidian", (TagKey<Item>)Tags.Items.OBSIDIAN);
            OreDictionaryAdapter.register("sand", (TagKey<Item>)ItemTags.f_13137_);
            OreDictionaryAdapter.register("brickStone", (TagKey<Item>)ItemTags.f_13169_);
            OreDictionaryAdapter.register("chest", (TagKey<Item>)Tags.Items.CHESTS);
            OreDictionaryAdapter.register("chestWood", (TagKey<Item>)Tags.Items.CHESTS_WOODEN);
            OreDictionaryAdapter.register("chestTrapped", (TagKey<Item>)Tags.Items.CHESTS_TRAPPED);
            OreDictionaryAdapter.register("chestEnder", (TagKey<Item>)Tags.Items.CHESTS_ENDER);
            OreDictionaryAdapter.register("piston", TagsHL.Items.PISTONS);
        }
        hasInit = true;
    }

    static {
        OreDictionaryAdapter.initVanillaEntries();
    }
}

