/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.megane.module.create.provider;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.MountedFluidStorage;
import com.simibubi.create.content.contraptions.MountedStorage;
import lol.bai.megane.module.create.mixin.AccessContraption;
import lol.bai.megane.module.create.mixin.AccessMountedStorageManager;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.data.FluidData;
import mcp.mobius.waila.api.data.ItemData;
import mcp.mobius.waila.api.forge.ForgeFluidData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ContraptionProvider
implements IEntityComponentProvider,
IDataProvider<AbstractContraptionEntity> {
    public static final ResourceLocation CONFIG = new ResourceLocation("megane:create.contraption");
    public static final ResourceLocation CONTEXT = new ResourceLocation("megane:ctx.create.contraption");
    @Nullable
    private StructureTemplate.StructureBlockInfo lastInfo;
    private int lastUpdateId = 0;

    @Nullable
    private StructureTemplate.StructureBlockInfo getInfo(IEntityAccessor accessor) {
        if (accessor.getUpdateId() != this.lastUpdateId) {
            this.lastUpdateId = accessor.getUpdateId();
            AbstractContraptionEntity entity = (AbstractContraptionEntity)accessor.getEntity();
            Vec3 origin = accessor.getEntityHitResult().m_82450_();
            Vec3 viewVec = accessor.getRayCastDirection();
            double remaining = accessor.getRayCastMaxDistance() - accessor.getRayCastOrigin().m_82554_(origin);
            Vec3 max = origin.m_82520_(viewVec.f_82479_ * remaining, viewVec.f_82480_ * remaining, viewVec.f_82481_ * remaining);
            Vec3 localOrigin = entity.toLocalVector(origin, accessor.getFrameTime());
            Vec3 localMax = entity.toLocalVector(max, accessor.getFrameTime());
            this.lastInfo = (StructureTemplate.StructureBlockInfo)BlockGetter.m_151361_((Vec3)localOrigin, (Vec3)localMax, (Object)Unit.INSTANCE, (unit, pos) -> {
                StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)entity.getContraption().getBlocks().get(pos);
                if (info == null) {
                    return null;
                }
                Level world = accessor.getWorld();
                VoxelShape shape = info.f_74676_().m_60808_((BlockGetter)world, pos);
                BlockHitResult hit = world.m_45558_(localOrigin, localMax, pos.m_7949_(), shape, info.f_74676_());
                if (hit == null) {
                    return null;
                }
                return info;
            }, unit -> null);
        }
        return this.lastInfo;
    }

    public void appendDataContext(IDataWriter ctx, IEntityAccessor accessor, IPluginConfig config) {
        StructureTemplate.StructureBlockInfo info = this.getInfo(accessor);
        if (info == null) {
            return;
        }
        ctx.addImmediate((IData)new Context(info.f_74675_()));
    }

    @Nullable
    public Entity getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return this.getInfo(accessor) == null ? EMPTY_ENTITY : null;
    }

    @Nullable
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        StructureTemplate.StructureBlockInfo info = this.getInfo(accessor);
        if (info == null) {
            return null;
        }
        return new ItemComponent((ItemLike)info.f_74676_().m_60734_());
    }

    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        StructureTemplate.StructureBlockInfo info = this.getInfo(accessor);
        if (info == null) {
            return;
        }
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        Block block = info.f_74676_().m_60734_();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.blockName((Object)block.m_49954_().getString()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName((Object)ForgeRegistries.BLOCKS.getKey((Object)block)));
        }
    }

    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        StructureTemplate.StructureBlockInfo info = this.getInfo(accessor);
        if (info == null) {
            return;
        }
        IDataReader data = accessor.getData();
        Context ctx = (Context)data.get(Context.class);
        if (ctx == null) {
            return;
        }
        if (!ctx.localPos.equals((Object)info.f_74675_())) {
            data.invalidate(ItemData.class);
            data.invalidate(FluidData.class);
        }
    }

    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            return;
        }
        StructureTemplate.StructureBlockInfo info = this.getInfo(accessor);
        if (info == null) {
            return;
        }
        tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName((Object)IModInfo.get((Block)info.f_74676_().m_60734_()).getName()));
    }

    public void appendData(IDataWriter data, IServerAccessor<AbstractContraptionEntity> accessor, IPluginConfig config) {
        Context ctx = (Context)accessor.getContext().get(Context.class);
        if (ctx == null) {
            return;
        }
        data.addImmediate((IData)ctx);
        data.add(ItemData.class, res -> {
            AccessContraption contraption = (AccessContraption)((AbstractContraptionEntity)accessor.getTarget()).getContraption();
            AccessMountedStorageManager manager = (AccessMountedStorageManager)contraption.megane_getStorageForSpawnPacket();
            MountedStorage storage = manager.megane_storage().get(ctx.localPos);
            if (storage == null) {
                return;
            }
            IItemHandlerModifiable handler = storage.getItemHandler();
            res.add((IData)ItemData.of((IPluginConfig)config).getter(arg_0 -> ((IItemHandlerModifiable)handler).getStackInSlot(arg_0), handler.getSlots()));
        });
        data.add(FluidData.class, res -> {
            AccessContraption contraption = (AccessContraption)((AbstractContraptionEntity)accessor.getTarget()).getContraption();
            AccessMountedStorageManager manager = (AccessMountedStorageManager)contraption.megane_getStorageForSpawnPacket();
            MountedFluidStorage storage = manager.megane_fluidStorage().get(ctx.localPos);
            if (storage == null) {
                return;
            }
            IFluidHandler tank = storage.getFluidHandler();
            res.add((IData)ForgeFluidData.of((int)1).add((Object)tank.getFluidInTank(0), (double)tank.getTankCapacity(0)));
        });
    }

    public record Context(BlockPos localPos) implements IData
    {
        public Context(FriendlyByteBuf buf) {
            this(buf.m_130135_());
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130064_(this.localPos);
        }
    }
}

