/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei;

import com.mojang.blaze3d.platform.InputConstants;
import giselle.jei_mekanism_multiblocks.client.gui.ContainerWidget;
import giselle.jei_mekanism_multiblocks.client.jei.CostWidget;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class MultiblockCategory<WIDGET extends MultiblockWidget>
implements IRecipeCategory<WIDGET> {
    private final RecipeType<WIDGET> type;
    private final IDrawable icon;
    private final IDrawable background;
    private final Component title;

    public MultiblockCategory(IGuiHelper helper, ResourceLocation name, Class<? extends WIDGET> clazz, Component multiblockName, ItemStack icon) {
        this(helper, name, clazz, multiblockName, helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)icon));
    }

    public MultiblockCategory(IGuiHelper helper, ResourceLocation name, Class<? extends WIDGET> clazz, Component multiblockName, IDrawable icon) {
        this.type = RecipeType.create((String)"jei_mekanism_multiblocks", (String)("multiblock." + name.m_135827_() + "." + name.m_135815_()), clazz);
        this.icon = icon;
        this.background = helper.createBlankDrawable(180, 120);
        this.title = Component.m_237110_((String)"text.jei_mekanism_multiblocks.recipe_category.title", (Object[])new Object[]{multiblockName});
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, WIDGET widget, IFocusGroup focuses) {
        IDrawable background = this.getBackground();
        ((MultiblockWidget)((Object)widget)).initialize();
        ((ContainerWidget)((Object)widget)).m_93674_(background.getWidth());
        ((ContainerWidget)((Object)widget)).setHeight(background.getHeight());
        for (ItemStack cost : ((MultiblockWidget)((Object)widget)).getCosts()) {
            this.addSlots(recipeLayout, cost);
        }
    }

    private void addSlots(IRecipeLayoutBuilder recipeLayout, ItemStack cost) {
        ItemStack item;
        int maxStackSize = cost.m_41741_();
        for (int count = cost.m_41613_(); count > 0; count -= item.m_41613_()) {
            item = cost.m_41777_();
            item.m_41764_(Math.min(maxStackSize, count));
            recipeLayout.addSlot(RecipeIngredientRole.INPUT, 9999, 9999).addItemStack(item);
        }
    }

    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        RecipeType<WIDGET> type = this.getRecipeType();
        ArrayList list = new ArrayList();
        this.getRecipeCatalystItemStacks(list::add);
        for (ItemStack itemStack : list) {
            registration.addRecipeCatalyst(itemStack, new RecipeType[]{type});
        }
    }

    public void draw(WIDGET widget, IRecipeSlotsView recipeSlotsView, GuiGraphics pGuiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        float partialTicks = minecraft.m_91297_();
        ((MultiblockWidget)((Object)widget)).m_88315_(pGuiGraphics, (int)mouseX, (int)mouseY, partialTicks);
    }

    public List<Component> getTooltipStrings(WIDGET widget, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        CostWidget cost;
        if (((MultiblockWidget)((Object)widget)).costsButton.isSelected() && (cost = ((MultiblockWidget)((Object)widget)).getCostUnderMouse(mouseX, mouseY)) != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.addAll(Arrays.asList(cost.getHeadTooltip()));
            tooltip.addAll(Screen.m_280152_((Minecraft)minecraft, (ItemStack)cost.getItemStack()));
            tooltip.addAll(Arrays.asList(cost.getTailTooltip()));
            return tooltip;
        }
        return super.getTooltipStrings(widget, recipeSlotsView, mouseX, mouseY);
    }

    public boolean handleInput(WIDGET widget, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE) {
            return ((ContainerWidget)((Object)widget)).m_6375_(mouseX, mouseY, input.m_84873_());
        }
        return super.handleInput(widget, mouseX, mouseY, input);
    }

    public boolean handleScroll(WIDGET widget, double mouseX, double mouseY, double delta) {
        return ((ContainerWidget)((Object)widget)).m_6050_(mouseX, mouseY, delta);
    }

    public boolean handleDrag(WIDGET widget, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        return ((ContainerWidget)((Object)widget)).m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public boolean handleReleased(WIDGET widget, double mouseX, double mouseY, int mouseButton) {
        return ((ContainerWidget)((Object)widget)).m_6348_(mouseX, mouseY, mouseButton);
    }

    public RecipeType<WIDGET> getRecipeType() {
        return this.type;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public Component getTitle() {
        return this.title;
    }
}

