/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.gui;

import giselle.jei_mekanism_multiblocks.client.gui.ButtonWidget;
import giselle.jei_mekanism_multiblocks.client.gui.ContainerWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public class ListWidget
extends ContainerWidget {
    private int itemsLeft = 0;
    private int itemsTop = 0;
    private int itemsRight = 0;
    private int itemsBottom = 0;
    private int itemHeight;
    private int itemOffset;
    private boolean itemsHorizontalChanged;
    private boolean itemsVerticalChanged;
    private boolean itemsChanged;
    private int scrollBarWidth;
    private boolean scrollBarHorizontalChanged;
    private boolean scrollBarVerticalChanged;
    private ButtonWidget upButton;
    private ButtonWidget downButton;
    private IntSliderWidget scrollBar;

    public ListWidget(int pX, int pY, int pWidth, int pHeight, int itemHeight) {
        super(pX, pY, pWidth, pHeight);
        this.itemHeight = itemHeight;
        this.itemOffset = 0;
        this.scrollBarWidth = 12;
        this.upButton = new ButtonWidget(0, 0, 0, 0, (Component)Component.m_237113_((String)"\u25b2"));
        this.addFunctionWidget(this.upButton);
        this.upButton.addPressHandler(this::onScrollButtonClick);
        this.downButton = new ButtonWidget(0, 0, 0, 0, (Component)Component.m_237113_((String)"\u25bc"));
        this.addFunctionWidget(this.downButton);
        this.downButton.addPressHandler(this::onScrollButtonClick);
        this.scrollBar = new IntSliderWidget(0, 0, 0, 0, (Component)Component.m_237119_(), 0, 0, 0);
        this.addFunctionWidget(this.scrollBar);
        this.scrollBar.addValueChangeHanlder(this::onScrollChanged);
        this.scrollBar.setVertical();
        this.itemsChanged = true;
        this.updateScrollWidgetsHorizontal();
        this.updateScrollWidgetsVertical();
    }

    protected void onScrollChanged(int scroll) {
        this.itemsVerticalChanged = true;
    }

    protected void onScrollButtonClick(AbstractButton button) {
        if (button == this.upButton) {
            this.setScrollAmount(this.getScrollAmount() - 1);
        } else if (button == this.downButton) {
            this.setScrollAmount(this.getScrollAmount() + 1);
        }
    }

    public int getItemCountInHeight() {
        int height = this.m_93694_();
        int itemHeight = this.getItemHeight();
        int itemOffset = this.getItemOffset();
        return (height + itemOffset) / (itemHeight + itemOffset);
    }

    @Override
    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.f_93623_ && this.f_93624_ && this.m_5953_(pMouseX, pMouseY)) {
            long scrollDelta = Math.round(pDelta / Math.abs(pDelta));
            this.setScrollAmount(this.getScrollAmount() - (int)scrollDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    @Override
    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.scrollBarHorizontalChanged) {
            this.scrollBarHorizontalChanged = false;
            this.updateScrollWidgetsHorizontal();
        }
        if (this.scrollBarVerticalChanged) {
            this.scrollBarVerticalChanged = false;
            this.updateScrollWidgetsVertical();
        }
        if (this.itemsChanged) {
            this.itemsChanged = false;
            int scroll = this.scrollBar.getValue();
            int childCount = this.getChildren().size();
            this.scrollBar.setMaxValue(Math.max(childCount - this.getItemCountInHeight(), 0));
            this.scrollBar.setValue(scroll);
            this.upButton.f_93623_ = this.scrollBar.f_93623_ = this.scrollBar.getMaxValue() > 0;
            this.downButton.f_93623_ = this.scrollBar.f_93623_;
        }
        if (this.itemsHorizontalChanged) {
            this.itemsHorizontalChanged = false;
            this.updateItemsHorizontal();
        }
        if (this.itemsVerticalChanged) {
            this.itemsVerticalChanged = false;
            this.updateItemsVertical();
        }
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTicks);
    }

    protected void updateItemsVertical() {
        int itemHeight = this.getItemHeight();
        int itemOffset = this.getItemOffset();
        int itemY = this.getItemsTop() + -this.getScrollAmount() * (itemHeight + itemOffset);
        int top = 0;
        int bottom = this.m_93694_() - this.getItemsBottom() - itemHeight;
        for (AbstractWidget widget : this.getChildren()) {
            widget.m_253211_(itemY);
            widget.setHeight(itemHeight);
            widget.f_93624_ = top <= itemY && itemY <= bottom;
            itemY += itemHeight + itemOffset;
        }
    }

    protected void updateItemsHorizontal() {
        for (AbstractWidget widget : this.getChildren()) {
            this.updateItemHorizontal(widget);
        }
    }

    protected void updateItemHorizontal(AbstractWidget widget) {
        widget.m_252865_(this.getItemsLeft());
        widget.m_93674_(this.scrollBar.m_252754_() - this.getItemsRight() - widget.m_252754_());
    }

    @Override
    protected void onChildAdded(AbstractWidget widget) {
        super.onChildAdded(widget);
        this.updateItemHorizontal(widget);
        this.itemsChanged = true;
        this.itemsVerticalChanged = true;
    }

    @Override
    protected void onChildRemoved(AbstractWidget widget) {
        super.onChildRemoved(widget);
        this.itemsChanged = true;
        this.itemsVerticalChanged = true;
    }

    private void updateScrollWidgetsHorizontal() {
        int scrollBarWidth = this.getScrollBarWidth();
        int x = this.m_5711_() - scrollBarWidth;
        this.upButton.m_93674_(scrollBarWidth);
        this.upButton.m_252865_(x);
        this.downButton.m_93674_(scrollBarWidth);
        this.downButton.m_252865_(this.upButton.m_252754_());
        this.scrollBar.m_93674_(scrollBarWidth);
        this.scrollBar.m_252865_(this.downButton.m_252754_());
        this.itemsHorizontalChanged = true;
    }

    private void updateScrollWidgetsVertical() {
        int scrollBarWidth = this.getScrollBarWidth();
        this.upButton.setHeight(scrollBarWidth);
        this.upButton.m_253211_(0);
        this.downButton.setHeight(scrollBarWidth);
        this.downButton.m_253211_(this.m_93694_() - this.downButton.m_93694_());
        this.scrollBar.m_253211_(this.upButton.m_252907_() + this.upButton.m_93694_());
        this.scrollBar.setHeight(this.downButton.m_252907_() - this.scrollBar.m_252907_());
        this.itemsVerticalChanged = true;
    }

    @Override
    protected void onWidthChanged() {
        super.onWidthChanged();
        this.scrollBarHorizontalChanged = true;
    }

    @Override
    protected void onHeightChanged() {
        super.onHeightChanged();
        this.scrollBarVerticalChanged = true;
    }

    public int getItemsLeft() {
        return this.itemsLeft;
    }

    public void setItemsLeft(int itemsLeft) {
        itemsLeft = Math.max(itemsLeft, 0);
        if (this.getItemsLeft() != itemsLeft) {
            this.itemsLeft = itemsLeft;
            this.itemsHorizontalChanged = true;
        }
    }

    public int getItemsRight() {
        return this.itemsRight;
    }

    public void setItemsRight(int itemsRight) {
        itemsRight = Math.max(itemsRight, 0);
        if (this.getItemsRight() != itemsRight) {
            this.itemsRight = itemsRight;
            this.itemsHorizontalChanged = true;
        }
    }

    public int getItemsTop() {
        return this.itemsTop;
    }

    public void setItemsTop(int itemsTop) {
        itemsTop = Math.max(itemsTop, 0);
        if (this.getItemsTop() != itemsTop) {
            this.itemsTop = itemsTop;
            this.itemsVerticalChanged = true;
        }
    }

    public int getItemsBottom() {
        return this.itemsBottom;
    }

    public void setItemsBottom(int itemsBottom) {
        itemsBottom = Math.max(itemsBottom, 0);
        if (this.getItemsBottom() != itemsBottom) {
            this.itemsBottom = itemsBottom;
            this.itemsVerticalChanged = true;
        }
    }

    public void setItemsPadding(int padding) {
        this.setItemsLeft(padding);
        this.setItemsTop(padding);
        this.setItemsRight(padding);
        this.setItemsBottom(padding);
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int itemHeight) {
        itemHeight = Math.max(itemHeight, 0);
    }

    public int getItemOffset() {
        return this.itemOffset;
    }

    public void setItemOffset(int itemOffset) {
        itemOffset = Math.max(itemOffset, 0);
        if (this.getItemOffset() != itemOffset) {
            this.itemOffset = Math.max(itemOffset, 0);
            this.itemsVerticalChanged = true;
        }
    }

    public int getScrollBarWidth() {
        return this.scrollBarWidth;
    }

    public void setScrollBarWidth(int scrollBarWidth) {
        scrollBarWidth = Math.max(scrollBarWidth, 0);
        if (this.getScrollBarWidth() != scrollBarWidth) {
            this.scrollBarWidth = scrollBarWidth;
            this.scrollBarHorizontalChanged = true;
        }
    }

    public int getScrollMin() {
        return 0;
    }

    public int getScrollAmount() {
        return this.scrollBar.getValue();
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollBar.setValue(scrollAmount);
    }
}

