/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ScrollPane;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Objects;

public class TextDisplayWidget
implements DynamicWidget {
    private final ExtendedScreen parent;
    private int startX;
    private int startY;
    private int width;
    private int contentHeight;
    private String message;
    private List<String> renderLines;
    private boolean centered;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public TextDisplayWidget(ExtendedScreen parent, boolean centered, int startX, int startY, int width, String message) {
        this.parent = parent;
        this.setCentered(centered);
        this.setControlPosX(startX);
        this.setControlPosY(startY);
        this.setControlWidth(width);
        this.setMessage(message);
    }

    public TextDisplayWidget(ExtendedScreen parent, int startX, int startY, int width, String message) {
        this(parent, false, startX, startY, width, message);
    }

    public TextDisplayWidget(ExtendedScreen parent, boolean centered, int startX, int startY, int width) {
        this(parent, centered, startX, startY, width, "");
    }

    public TextDisplayWidget(ExtendedScreen parent, int startX, int startY, int width) {
        this(parent, false, startX, startY, width);
    }

    public TextDisplayWidget(ExtendedScreen parent, boolean centered, int width, String message) {
        this(parent, centered, 0, 0, width, message);
    }

    public TextDisplayWidget(ExtendedScreen parent, int width, String message) {
        this(parent, false, width, message);
    }

    public TextDisplayWidget(ExtendedScreen parent, boolean centered, int width) {
        this(parent, centered, width, "");
    }

    public TextDisplayWidget(ExtendedScreen parent, int width) {
        this(parent, false, width);
    }

    public String getMessage() {
        return this.message;
    }

    public TextDisplayWidget setMessage(String newMessage) {
        if (!Objects.equals(newMessage, this.message)) {
            this.message = newMessage;
            this.renderLines = this.refreshContent();
            this.getParent().refreshContentHeight();
        }
        return this;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public TextDisplayWidget setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public List<String> getRenderLines() {
        return StringUtils.newArrayList(this.renderLines);
    }

    public ExtendedScreen getParent() {
        return this.parent;
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
    }

    @Override
    public void draw(ExtendedScreen screen) {
        int padding = 0;
        int barWidth = 0;
        if (screen instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)screen;
            padding = pane.getPadding();
            barWidth = pane.getScrollBarWidth();
        }
        screen.drawMultiLineString(this.getRenderLines(), this.getControlPosX() + padding, this.getControlPosY() + padding, this.getControlWidth() - padding - barWidth, -1, -1, this.isCentered(), false, screen.createDefaultTooltip().putSecond(null).putThird(null));
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
    }

    @Override
    public int getControlPosX() {
        return this.startX;
    }

    @Override
    public void setControlPosX(int posX) {
        this.startX = posX;
    }

    @Override
    public int getControlPosY() {
        return this.startY;
    }

    @Override
    public void setControlPosY(int posY) {
        this.startY = posY;
    }

    @Override
    public int getControlWidth() {
        return this.width;
    }

    @Override
    public void setControlWidth(int width) {
        this.width = width;
    }

    @Override
    public int getControlHeight() {
        return this.contentHeight;
    }

    @Override
    public void setControlHeight(int height) {
        this.contentHeight = height;
    }

    public List<String> refreshContent() {
        int padding = 0;
        int barWidth = 0;
        if (this.getParent() instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)this.getParent();
            padding = pane.getPadding();
            barWidth = pane.getScrollBarWidth();
        }
        int width = MathUtils.clamp(this.getControlWidth() - this.getControlPosX() - padding * 2 - barWidth, 0, this.getParent().getMaxWidth());
        List<String> content = this.getParent().createRenderLines(this.getMessage(), width);
        int height = content.size() * (this.getParent().getFontHeight() + 1);
        this.setControlHeight(height + 2);
        return content;
    }
}

