/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.AboutGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.CommandsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ScrollPane;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;

public abstract class ConfigurationGui<T extends Module>
extends ExtendedScreen {
    private final String title;
    private final String subTitle;
    protected ScrollPane childFrame;
    protected ExtendedButtonControl resetConfigButton;
    protected ExtendedButtonControl syncConfigButton;
    protected ExtendedButtonControl proceedButton;

    public ConfigurationGui(Screen parentScreen, String title, String subTitle) {
        super(parentScreen);
        this.title = title;
        this.subTitle = subTitle;
    }

    public ConfigurationGui(Screen parentScreen, String title) {
        this(parentScreen, title, null);
    }

    public static void addIconSelector(ExtendedScreen currentScreen, ExtendedScreen parent, Supplier<TextWidget> textWidget, BiConsumer<String, String> onUpdatedCallback) {
        TextWidget textControl = textWidget.get();
        int left = parent.getScreenWidth() / 2 + 3;
        int right = left + textControl.getControlWidth();
        String currentValue = StringUtils.getOrDefault(textWidget.get().getControlMessage(), null);
        parent.addControl(new ExtendedButtonControl(right + 4, textControl.getTop() - parent.getTop(), 30, 20, "...", () -> currentScreen.openScreen(new SelectorGui((Screen)currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), currentValue, null, true, false, ScrollableListControl.RenderType.DiscordAsset, onUpdatedCallback, null)), new String[0]));
    }

    @Override
    public void initializeUi() {
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, 180, 20, "gui.config.message.button.back", () -> {
            this.applySettings();
            this.openScreen(this.parentScreen);
        }, new String[0]));
        this.resetConfigButton = this.addControl(new ExtendedButtonControl(6, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.reset_to_default", () -> {
            if (this.resetData()) {
                this.reloadUi();
            }
        }, () -> {
            if (this.resetConfigButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.button.reset.config", new Object[0])));
            }
        }, new String[0]));
        this.syncConfigButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 101, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.sync.config", () -> {
            if (this.syncData()) {
                this.reloadUi();
            }
        }, () -> {
            if (this.syncConfigButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.button.sync.config", new Object[0])));
            }
        }, new String[0]));
        this.childFrame = this.addControl(new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 32));
        this.appendControls();
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.syncRenderStates();
        super.preRender();
    }

    @Override
    public void renderExtra() {
        boolean hasSubTitle;
        boolean hasMainTitle = !StringUtils.isNullOrEmpty(this.title);
        boolean bl = hasSubTitle = !StringUtils.isNullOrEmpty(this.subTitle);
        if (hasMainTitle) {
            String mainTitle = Constants.TRANSLATOR.getLocalizedMessage(this.title);
            if (hasSubTitle) {
                String otherTitle = Constants.TRANSLATOR.getLocalizedMessage(this.subTitle);
                this.renderScrollingString(mainTitle, 30, 2, this.getScreenWidth() - 30, 16, 0xFFFFFF);
                this.renderScrollingString(otherTitle, 30, 16, this.getScreenWidth() - 30, 30, 0xFFFFFF);
            } else {
                this.renderScrollingString(mainTitle, 30, 0, this.getScreenWidth() - 30, 32, 0xFFFFFF);
            }
        }
        super.renderExtra();
    }

    protected void addIconSelector(ExtendedScreen parent, Supplier<TextWidget> textWidget, BiConsumer<String, String> onUpdatedCallback) {
        ConfigurationGui.addIconSelector(this, parent, textWidget, onUpdatedCallback);
    }

    protected boolean canProceed() {
        return true;
    }

    protected boolean canReset() {
        return this.allowedToReset() && this.getDefaultData() != null && !((Module)this.getCurrentData()).equals(this.getDefaultData());
    }

    protected boolean allowedToReset() {
        return false;
    }

    protected boolean canSync() {
        return this.allowedToSync();
    }

    protected boolean allowedToSync() {
        return false;
    }

    protected void syncRenderStates() {
        this.proceedButton.setControlEnabled(this.canProceed());
        this.resetConfigButton.setControlVisible(this.allowedToReset());
        this.resetConfigButton.setControlEnabled(this.canReset());
        this.syncConfigButton.setControlVisible(this.allowedToSync());
        this.syncConfigButton.setControlEnabled(this.canSync());
    }

    protected void appendControls() {
        this.addControl(new ExtendedButtonControl(6, 6, 20, 20, "?", () -> this.openScreen(new AboutGui(this.currentScreen)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.button.about", new Object[0]))), new String[0]));
        this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 26, 6, 20, 20, ">_", () -> this.openScreen(new CommandsGui(this.currentScreen, new String[0])), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.button.commands", new Object[0]))), new String[0]));
    }

    protected boolean resetData() {
        return this.setCurrentData(this.getDefaultData());
    }

    protected boolean syncData() {
        return this.setCurrentData(this.getSyncData());
    }

    protected void applySettings() {
        this.setCurrentData(this.getInstanceData());
    }

    protected abstract T getInstanceData();

    protected abstract T getCurrentData();

    protected T getDefaultData() {
        return null;
    }

    protected T getSyncData() {
        return null;
    }

    protected boolean setCurrentData(T data) {
        if (data != null && !((Module)this.getCurrentData()).equals(data)) {
            ((Module)this.getCurrentData()).transferFrom((Module)data);
            this.markAsChanged();
            return true;
        }
        return false;
    }

    protected void markAsChanged() {
        CraftPresence.CONFIG.hasChanged = true;
    }
}

