/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.Pack;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.atlauncher.ATLauncherUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.curse.CurseUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.mcupdater.MCUpdaterUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.modrinth.ModrinthUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.multimc.MultiMCUtils;
import com.gitlab.cdagaming.craftpresence.core.integrations.pack.technic.TechnicUtils;
import external.com.jagrosh.discordipc.entities.DiscordBuild;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.impl.TranslationManager;
import forge.com.gitlab.cdagaming.craftpresence.integrations.replaymod.ReplayModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.world.BiomeUtils;
import io.github.cdagaming.unicore.impl.TreeMapBuilder;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Map;
import net.minecraft.client.gui.screens.LoadingOverlay;

public class CommandUtils {
    private static final Map<String, TranslationManager> translationManagerList = StringUtils.newHashMap();
    private static final Map<String, Module> modules = new TreeMapBuilder<String, BiomeUtils>().put("_biome", CraftPresence.BIOMES).put("_dimension", (BiomeUtils)((Object)CraftPresence.DIMENSIONS)).put("_item", (BiomeUtils)((Object)CraftPresence.TILE_ENTITIES)).put("_entity", (BiomeUtils)((Object)CraftPresence.ENTITIES)).put("_server", (BiomeUtils)((Object)CraftPresence.SERVER)).put("_screen", (BiomeUtils)((Object)CraftPresence.GUIS)).build();
    private static final Map<String, Pack> packModules = new TreeMapBuilder<String, ATLauncherUtils>().put("atlauncher", new ATLauncherUtils(() -> CraftPresence.CONFIG.generalSettings.detectATLauncherInstance)).put("curse", (ATLauncherUtils)((Object)new CurseUtils(() -> CraftPresence.CONFIG.generalSettings.detectCurseManifest))).put("multimc", (ATLauncherUtils)((Object)new MultiMCUtils(() -> CraftPresence.CONFIG.generalSettings.detectMultiMCManifest))).put("mcupdater", (ATLauncherUtils)((Object)new MCUpdaterUtils(() -> CraftPresence.CONFIG.generalSettings.detectMCUpdaterInstance))).put("technic", (ATLauncherUtils)((Object)new TechnicUtils(() -> CraftPresence.CONFIG.generalSettings.detectTechnicPack))).put("modrinth", (ATLauncherUtils)((Object)new ModrinthUtils(() -> CraftPresence.CONFIG.generalSettings.detectModrinthPack))).build();
    private static MenuStatus status = MenuStatus.None;

    public static MenuStatus getMenuState() {
        return status;
    }

    public static void setMenuState(MenuStatus newState) {
        MenuStatus oldState = status;
        status = newState;
        if (oldState != newState) {
            CommandUtils.updateMenuPresence();
        }
    }

    public static void clearMenuState() {
        CommandUtils.setMenuState(MenuStatus.None);
    }

    public static void updateMenuPresence() {
        switch (status) {
            case Loading: {
                CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.loadingData);
                break;
            }
            case MainMenu: {
                CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.mainMenuData);
                break;
            }
            default: {
                CommandUtils.clearMenuPresence();
            }
        }
    }

    public static boolean isDebugMode() {
        return Constants.IS_DEV_FLAG || CommandUtils.isVerboseMode() || CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.debugMode;
    }

    public static boolean isVerboseMode() {
        return Constants.IS_VERBOSE_FLAG || CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.verboseMode;
    }

    public static void syncModuleArguments() {
        for (Map.Entry<String, Module> module : modules.entrySet()) {
            Object name = module.getKey();
            name = (((String)name).startsWith("_") ? "" : "_") + (String)name;
            CraftPresence.CLIENT.syncArgument((String)name + ".instance", module.getValue());
        }
    }

    public static void syncPackArguments() {
        boolean foundPack = false;
        for (Map.Entry<String, Pack> pack : packModules.entrySet()) {
            Pack data = pack.getValue();
            if (!data.hasPackType()) {
                data.setPackType(pack.getKey());
            }
            if (!data.isEnabled() || !data.hasPackName()) continue;
            CraftPresence.CLIENT.syncArgument("pack.type", data.getPackType());
            CraftPresence.CLIENT.syncArgument("pack.name", data.getPackName());
            CraftPresence.CLIENT.syncArgument("pack.icon", CraftPresence.CLIENT.imageOf("pack.icon", true, data.getPackIcon(), data.getPackType()));
            foundPack = true;
            break;
        }
        if (!foundPack) {
            CraftPresence.CLIENT.removeArguments("pack");
        }
    }

    public static void addModule(String moduleId, Module instance) {
        modules.put(moduleId, instance);
    }

    public static void addModule(String moduleId, Pack instance) {
        packModules.put(moduleId, instance);
    }

    public static void addModule(String moduleId, TranslationManager instance) {
        translationManagerList.put(moduleId, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadData(boolean forceUpdateRPC) {
        for (TranslationManager manager : translationManagerList.values()) {
            manager.onTick();
        }
        CraftPresence.SCHEDULER.onTick();
        CraftPresence.instance.execute(CraftPresence.KEYBINDINGS::onTick);
        CraftPresence.SCHEDULER.TICK_LOCK.lock();
        try {
            for (Module module : modules.values()) {
                if (!module.canBeLoaded()) continue;
                module.onTick();
                if (!forceUpdateRPC || !module.isInUse()) continue;
                module.updatePresence();
            }
            if (forceUpdateRPC) {
                CommandUtils.updateMenuPresence();
            }
            CraftPresence.CLIENT.onTick();
        }
        catch (Throwable ex) {
            String messagePrefix = Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
            String verbosePrefix = Constants.TRANSLATOR.translate("craftpresence.logger.error.verbose", new Object[0]);
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.module", new Object[0]), new Object[0]);
            Constants.LOG.printStackTrace(ex, messagePrefix, verbosePrefix, new Appendable[0]);
            CraftPresence.CLIENT.shutDown();
        }
        finally {
            CraftPresence.SCHEDULER.TICK_LOCK.unlock();
            CraftPresence.SCHEDULER.postTick();
        }
    }

    public static void setupRPC() {
        CraftPresence.CLIENT.shutDown();
        CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.generalSettings.clientId;
        CraftPresence.CLIENT.AUTO_REGISTER = CraftPresence.CONFIG.generalSettings.autoRegister;
        CraftPresence.CLIENT.PREFERRED_CLIENT = DiscordBuild.from(CraftPresence.CONFIG.generalSettings.preferredClientLevel);
        CraftPresence.CLIENT.UPDATE_TIMESTAMP = CraftPresence.CONFIG.generalSettings.resetTimeOnInit;
        CraftPresence.CLIENT.ALLOW_DUPLICATE_PACKETS = CraftPresence.CONFIG.advancedSettings.allowDuplicatePackets;
        CraftPresence.CLIENT.MAX_CONNECTION_ATTEMPTS = CraftPresence.CONFIG.advancedSettings.maxConnectionAttempts;
        CraftPresence.CLIENT.init();
    }

    public static void init() {
        CommandUtils.updateModes();
        for (Map.Entry<String, Pack> pack : packModules.entrySet()) {
            String type = pack.getKey();
            Pack data = pack.getValue();
            if (!data.isEnabled()) continue;
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.pack.init", type), new Object[0]);
            if (data.load()) {
                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.pack.loaded", type, data.getPackName(), data.getPackIcon()), new Object[0]);
                break;
            }
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.pack", type), new Object[0]);
        }
        CraftPresence.KEYBINDINGS.register();
        if (FileUtils.findValidClass("com.replaymod.core.ReplayMod") != null) {
            CommandUtils.addModule("integration.replaymod", new ReplayModUtils());
        }
    }

    public static void onTick() {
        if (!Constants.HAS_GAME_LOADED) {
            boolean bl = Constants.HAS_GAME_LOADED = CraftPresence.instance.f_91080_ != null && !(CraftPresence.instance.m_91265_() instanceof LoadingOverlay) || CraftPresence.player != null;
            if (Constants.HAS_GAME_LOADED) {
                CommandUtils.addModule("craftpresence", new TranslationManager(Constants.TRANSLATOR.setStripColors(CraftPresence.CONFIG != null && CraftPresence.CONFIG.accessibilitySettings.stripTranslationColors).setStripFormatting(CraftPresence.CONFIG != null && CraftPresence.CONFIG.accessibilitySettings.stripTranslationFormatting)));
                if (ModUtils.RAW_TRANSLATOR != null) {
                    CommandUtils.addModule("minecraft", new TranslationManager(ModUtils.RAW_TRANSLATOR));
                }
            }
        }
        CraftPresence.CLIENT.updatePresence();
    }

    public static void updateModes() {
        Constants.LOG.setDebugMode(CommandUtils.isVerboseMode());
        if (CraftPresence.CLIENT.isAvailable()) {
            CraftPresence.CLIENT.ipcInstance.setDebugMode(CommandUtils.isDebugMode());
            CraftPresence.CLIENT.ipcInstance.setVerboseLogging(CommandUtils.isVerboseMode());
        }
        if (CraftPresence.CONFIG != null) {
            CraftPresence.SCHEDULER.setRefreshRate(CraftPresence.CONFIG.advancedSettings.refreshRate);
        }
    }

    public static void syncMenuData(ModuleData currentData) {
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : "";
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : CraftPresence.CONFIG.generalSettings.defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("menu.icon", true, currentIcon);
        CraftPresence.CLIENT.clearPartyData();
        CraftPresence.CLIENT.syncOverride(currentData, "menu.message", "menu.icon");
        CraftPresence.CLIENT.syncArgument("menu.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("menu.icon", formattedIcon);
    }

    public static void clearMenuPresence() {
        CraftPresence.CLIENT.clearOverride("menu.message", "menu.icon");
        CraftPresence.CLIENT.removeArguments("menu");
    }

    public static enum MenuStatus {
        MainMenu,
        Loading,
        None;

    }
}

