/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.PartyPrivacy;
import external.com.jagrosh.discordipc.entities.DiscordBuild;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.General;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.gui.screens.Screen;

public class GeneralSettingsGui
extends ConfigurationGui<General> {
    private final General INSTANCE;
    private final General DEFAULTS;
    private ExtendedButtonControl partyPrivacyLevelButton;
    private ExtendedButtonControl preferredClientLevelButton;
    private CheckBoxControl detectCurseManifestButton;
    private CheckBoxControl detectMultiMCManifestButton;
    private CheckBoxControl detectMCUpdaterInstanceButton;
    private CheckBoxControl detectTechnicPackButton;
    private CheckBoxControl detectATLauncherButton;
    private CheckBoxControl detectModrinthPackButton;
    private CheckBoxControl detectBiomeDataButton;
    private CheckBoxControl detectDimensionDataButton;
    private CheckBoxControl detectWorldDataButton;
    private CheckBoxControl enableJoinRequestButton;
    private CheckBoxControl resetTimeOnInitButton;
    private CheckBoxControl autoRegisterButton;
    private TextWidget clientId;
    private TextWidget defaultIcon;
    private int currentPartyPrivacy = PartyPrivacy.Public.ordinal();
    private int currentPreferredClient = DiscordBuild.ANY.ordinal();

    GeneralSettingsGui(Screen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.general");
        this.DEFAULTS = this.getCurrentData().getDefaults();
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        this.clientId = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            this.getInstanceData().clientId = this.clientId.getControlMessage();
        }, "gui.config.name.general.client_id", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.client_id", new Object[0])))));
        this.clientId.setControlMessage(this.getInstanceData().clientId);
        this.clientId.setControlMaxLength(32);
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.defaultIcon = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(1), 147, 20, () -> {
            this.getInstanceData().defaultIcon = this.defaultIcon.getControlMessage();
        }, "gui.config.name.general.default_icon", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.default_icon", new Object[0])))));
        this.addIconSelector(this.childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
            this.getInstanceData().defaultIcon = currentValue;
        });
        this.defaultIcon.setControlMessage(this.getInstanceData().defaultIcon);
        this.currentPartyPrivacy = this.getInstanceData().partyPrivacyLevel;
        this.partyPrivacyLevelButton = this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(2), 180, 20, "gui.config.name.general.party_privacy => " + PartyPrivacy.from(this.currentPartyPrivacy).name(), () -> {
            this.currentPartyPrivacy = (this.currentPartyPrivacy + 1) % PartyPrivacy.values().length;
            this.partyPrivacyLevelButton.setControlMessage("gui.config.name.general.party_privacy => " + PartyPrivacy.from(this.currentPartyPrivacy).name());
            this.getInstanceData().partyPrivacyLevel = this.currentPartyPrivacy;
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.party_privacy", new Object[0]))), new String[0]));
        this.currentPreferredClient = this.getInstanceData().preferredClientLevel;
        this.preferredClientLevelButton = this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(2), 180, 20, "gui.config.name.general.preferred_client => " + DiscordBuild.from(this.currentPreferredClient).name(), () -> {
            this.currentPreferredClient = (this.currentPreferredClient + 1) % DiscordBuild.values().length;
            this.preferredClientLevelButton.setControlMessage("gui.config.name.general.preferred_client => " + DiscordBuild.from(this.currentPreferredClient).name());
            this.getInstanceData().preferredClientLevel = this.currentPreferredClient;
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.preferred_client", new Object[0]))), new String[0]));
        this.detectCurseManifestButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(3), "gui.config.name.general.detect_curse_manifest", this.getInstanceData().detectCurseManifest, () -> {
            this.getInstanceData().detectCurseManifest = this.detectCurseManifestButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_curse_manifest", new Object[0])))));
        this.detectMultiMCManifestButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(3), "gui.config.name.general.detect_multimc_manifest", this.getInstanceData().detectMultiMCManifest, () -> {
            this.getInstanceData().detectMultiMCManifest = this.detectMultiMCManifestButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_multimc_manifest", new Object[0])))));
        this.detectMCUpdaterInstanceButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(4, -10), "gui.config.name.general.detect_mcupdater_instance", this.getInstanceData().detectMCUpdaterInstance, () -> {
            this.getInstanceData().detectMCUpdaterInstance = this.detectMCUpdaterInstanceButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_mcupdater_instance", new Object[0])))));
        this.detectTechnicPackButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(4, -10), "gui.config.name.general.detect_technic_pack", this.getInstanceData().detectTechnicPack, () -> {
            this.getInstanceData().detectTechnicPack = this.detectTechnicPackButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_technic_pack", new Object[0])))));
        this.detectATLauncherButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(5, -20), "gui.config.name.general.detect_atlauncher_instance", this.getInstanceData().detectATLauncherInstance, () -> {
            this.getInstanceData().detectATLauncherInstance = this.detectATLauncherButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_atlauncher_instance", new Object[0])))));
        this.detectModrinthPackButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(5, -20), "gui.config.name.general.detect_modrinth_pack", this.getInstanceData().detectModrinthPack, () -> {
            this.getInstanceData().detectModrinthPack = this.detectModrinthPackButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_modrinth_pack", new Object[0])))));
        this.enableJoinRequestButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(6, -30), "gui.config.name.general.enable_join_request", this.getInstanceData().enableJoinRequests, () -> {
            this.getInstanceData().enableJoinRequests = this.enableJoinRequestButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.enable_join_request", new Object[0])))));
        this.detectDimensionDataButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(6, -30), "gui.config.name.general.detect_dimension_data", this.getInstanceData().detectDimensionData, () -> {
            this.getInstanceData().detectDimensionData = this.detectDimensionDataButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_dimension_data", new Object[0])))));
        this.autoRegisterButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(7, -40), "gui.config.name.general.auto_register", this.getInstanceData().autoRegister, () -> {
            this.getInstanceData().autoRegister = this.autoRegisterButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.auto_register", new Object[0])))));
        this.detectBiomeDataButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(7, -40), "gui.config.name.general.detect_biome_data", this.getInstanceData().detectBiomeData, () -> {
            this.getInstanceData().detectBiomeData = this.detectBiomeDataButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_biome_data", new Object[0])))));
        this.resetTimeOnInitButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(8, -50), "gui.config.name.general.reset_time_on_init", this.getInstanceData().resetTimeOnInit, () -> {
            this.getInstanceData().resetTimeOnInit = this.resetTimeOnInitButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.reset_time_on_init", new Object[0])))));
        this.detectWorldDataButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(8, -50), "gui.config.name.general.detect_world_data", this.getInstanceData().detectWorldData, () -> {
            this.getInstanceData().detectWorldData = this.detectWorldDataButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.general.detect_world_data", new Object[0])))));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(DiscordAssetUtils.isValidId(this.clientId.getControlMessage()));
    }

    @Override
    protected General getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected General getCurrentData() {
        return CraftPresence.CONFIG.generalSettings;
    }

    @Override
    protected General getDefaultData() {
        return this.DEFAULTS;
    }

    @Override
    protected General getSyncData() {
        return Config.loadOrCreate().generalSettings;
    }
}

