/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.migration;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.google.gson.JsonElement;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.migration.DataMigrator;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Map;

public class TextReplacer
implements DataMigrator {
    final Map<String, String> replacers;
    final boolean placeholderMode;
    final boolean matchCase;
    final boolean matchWholeWorld;
    final boolean useRegex;

    public TextReplacer(Map<String, String> replacers, boolean placeholderMode, boolean matchCase, boolean matchWholeWorld, boolean useRegex) {
        this.replacers = StringUtils.newHashMap(replacers);
        this.placeholderMode = placeholderMode;
        this.matchCase = matchCase;
        this.matchWholeWorld = matchWholeWorld;
        this.useRegex = useRegex;
    }

    @Override
    public Config apply(Config instance, JsonElement rawJson, Object ... args) {
        this.processElement(instance, rawJson, new String[0]);
        return instance;
    }

    private String processReplacement(String original) {
        String result = original;
        if (this.placeholderMode) {
            List<String> expressions = StringUtils.getMatches("\\{[^{}]*\\}", original);
            if (!expressions.isEmpty()) {
                for (String match : expressions) {
                    result = result.replace(match, StringUtils.sequentialReplace(match, this.matchCase, this.matchWholeWorld, this.useRegex, this.replacers));
                }
            }
        } else {
            result = StringUtils.sequentialReplace(result, this.matchCase, this.matchWholeWorld, this.useRegex, this.replacers);
        }
        return result;
    }

    private JsonElement processElement(Config instance, JsonElement rawJson, String ... path) {
        Object pathPrefix = String.join((CharSequence)".", path);
        if (!StringUtils.isNullOrEmpty((String)pathPrefix)) {
            pathPrefix = (String)pathPrefix + ".";
        }
        if (rawJson != null) {
            for (Map.Entry entry : rawJson.getAsJsonObject().entrySet()) {
                String rawName = (String)pathPrefix + (String)entry.getKey();
                List<String> configPath = StringUtils.newArrayList(path);
                configPath.add((String)entry.getKey());
                String[] pathData = configPath.toArray(new String[0]);
                Object defaultValue = instance.getDefaults().getProperty(pathData);
                Object currentValue = instance.getProperty(pathData);
                boolean shouldContinue = true;
                if (defaultValue == null) {
                    if (currentValue == null) {
                        shouldContinue = false;
                    } else {
                        defaultValue = currentValue;
                    }
                }
                if (!shouldContinue) continue;
                if (Module.class.isAssignableFrom(defaultValue.getClass())) {
                    List<String> paths = StringUtils.newArrayList(path);
                    paths.add((String)entry.getKey());
                    this.processElement(instance, (JsonElement)entry.getValue(), paths.toArray(new String[0]));
                    continue;
                }
                if (currentValue instanceof String) {
                    String originalResult = (String)currentValue;
                    String processResult = this.processReplacement(originalResult);
                    if (processResult.equals(originalResult)) continue;
                    Constants.LOG.debugInfo("Modified property \"%s\": \"%s\" => \"%s\"", rawName, originalResult, processResult);
                    instance.setProperty((Object)processResult, pathData);
                    continue;
                }
                if (!(currentValue instanceof Map)) continue;
                Map newData = StringUtils.newHashMap((Map)currentValue);
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                for (Object dataEntry : newData.keySet()) {
                    List<String> paths = StringUtils.newArrayList(path);
                    paths.add((String)entry.getKey());
                    paths.add(dataEntry.toString());
                    JsonElement dataValue = ((JsonElement)entry.getValue()).getAsJsonObject().get(dataEntry.toString());
                    if (!dataValue.isJsonObject()) continue;
                    this.processElement(instance, dataValue, paths.toArray(new String[0]));
                }
            }
        }
        return rawJson;
    }
}

