/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.client.model;

import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.snow.CoreModule;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.client.SnowClientConfig;

public class SnowVariantModel
extends BakedModelWrapper<BakedModel> {
    public static final ModelData USE_SNOW_VARIANT = ModelData.builder().build();
    private final BakedModel variantModel;

    public SnowVariantModel(BakedModel model, BakedModel variantModel) {
        super(model);
        this.variantModel = variantModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        BakedModel model = extraData == USE_SNOW_VARIANT ? this.variantModel : this.originalModel;
        return model.getQuads(state, side, rand, extraData, renderType);
    }

    public ModelData getModelData(@NotNull BlockAndTintGetter blockView, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        if (SnowClientConfig.snowVariants && modelData != USE_SNOW_VARIANT) {
            if (modelData.has(SnowBlockEntity.OPTIONS)) {
                return USE_SNOW_VARIANT;
            }
            if (state.m_61138_((Property)DoublePlantBlock.f_52858_) && CoreModule.TILE_BLOCK.is(blockView.m_8055_(pos.m_7495_()))) {
                return USE_SNOW_VARIANT;
            }
        }
        return super.getModelData(blockView, pos, state, modelData);
    }
}

